/***************************************************************************
	              wakeup.cpp  -  alarm plugin for noatun
	                       -------------------
	         begin    : Wed Apr 11 CEST 2000
	         copyright: (C) 2001 by Mickael Marchand <mikmak@linuxfr.net>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <engine.h>
#include <player.h>
#include <noatunapp.h>

#include <klocale.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qspinbox.h>
#include <klocale.h>
#include <qtimer.h>
#include <qdatetime.h>
#include <qlayout.h>

#include <kconfig.h>
#include <kglobal.h>
#include "wakeup.h"
#include "kminutespinbox.h"


extern "C" Plugin *create_plugin()
{
	return new Wakeup();
}

Wakeup *Wakeup::wakeme = 0;

Wakeup::Wakeup() : QObject(), Plugin()
{
	wakeme = this;

	NOATUNPLUGINC(Wakeup);
	new WakeupPrefs(this);

	update();

	QTimer *timer=new QTimer(this);
	connect (timer,SIGNAL(timeout()),SLOT(slotCheckTime()));
	timer->start(60000,false);
}

Wakeup::~Wakeup()
{
}

void Wakeup::update()
{
	KConfig *config=KGlobal::config();
	config->setGroup("Noatun Alarm");

	hour=config->readNumEntry("Hour",7);
	minute=config->readNumEntry("Minute",0);

	days[0]=config->readBoolEntry("Monday",false);
	days[1]=config->readBoolEntry("Tuesday",false);
	days[2]=config->readBoolEntry("Wednesday",false);
	days[3]=config->readBoolEntry("Thursday",false);
	days[4]=config->readBoolEntry("Friday",false);
	days[5]=config->readBoolEntry("Saturday",false);
	days[6]=config->readBoolEntry("Sunday",false);

	songlist=config->readEntry("List","");
}

void Wakeup::slotCheckTime()
{
	QTime t;
	QDate d;

	t=QTime::currentTime();
	d=QDate::currentDate();

	if (t.minute()!=minute || t.hour()!=hour) return;

	if (days[d.dayOfWeek()-1])
	{
		napp->player()->play();
	}
}


// for later use
void Wakeup::slotVolumeUp()
{
	int vol = napp->player()->volume();
	if ( vol >= 100 )
	return;

	napp->player()->setVolume( vol + 2 );
}

void Wakeup::slotVolumeDown()
{
	int vol = napp->player()->volume();
	if ( vol <= 0 )
	return;

	napp->player()->setVolume( vol - 2 );
}

///////////////////////////////////////////////////////////////////

WakeupPrefs::WakeupPrefs( QObject *parent ) :
	CModule( i18n("Wakeup"), i18n("Alarm Configuration"), parent )
{
	monday=new QCheckBox(i18n("Monday"),this);
	tuesday=new QCheckBox(i18n("Tuesday"),this);
	wednesday=new QCheckBox(i18n("Wednesday"),this);
	thursday=new QCheckBox(i18n("Thursday"),this);
	friday=new QCheckBox(i18n("Friday"),this);
	saturday=new QCheckBox(i18n("Saturday"),this);
	sunday=new QCheckBox(i18n("Sunday"),this);

	QFrame *timeFrame = new QFrame(this);

	QLabel *timeLabel = new QLabel(i18n("Time:"), timeFrame);
	QLabel *colonLabel = new QLabel(":", timeFrame);
	colonLabel->setMinimumWidth(7);
	colonLabel->setMaximumWidth(7);
	hour1 = new QSpinBox(0, 23, 1, timeFrame, "Hour1");
	hour1->setButtonSymbols(QSpinBox::PlusMinus);
	minute1 = new KMinuteSpinBox(1, timeFrame, "Minute1");

	QVBoxLayout *layout = new QVBoxLayout(this, KDialog::marginHint(), KDialog::spacingHint());
	layout->addWidget(monday);
	layout->addWidget(tuesday);
	layout->addWidget(wednesday);
	layout->addWidget(thursday);
	layout->addWidget(friday);
	layout->addWidget(saturday);
	layout->addWidget(sunday);
	layout->addWidget(timeFrame);
	layout->addStretch();

	QHBoxLayout *timeLayout = new QHBoxLayout(timeFrame, KDialog::marginHint(), KDialog::spacingHint());
	timeLayout->addWidget(timeLabel);
	timeLayout->addWidget(hour1);
	timeLayout->addWidget(colonLabel);
	timeLayout->addWidget(minute1);
	timeLayout->addStretch();

	load();
}

void WakeupPrefs::save()
{
	KConfig *config=KGlobal::config();
	config->setGroup("Noatun Alarm");
	config->writeEntry("Monday",monday->isChecked());
	config->writeEntry("Tuesday",tuesday->isChecked());
	config->writeEntry("Wednesday",wednesday->isChecked());
	config->writeEntry("Thursday",thursday->isChecked());
	config->writeEntry("Friday",friday->isChecked());
	config->writeEntry("Saturday",saturday->isChecked());
	config->writeEntry("Sunday",sunday->isChecked());
	config->writeEntry("Hour",hour1->text());
	config->writeEntry("Minute",minute1->text());
	config->sync();

	Wakeup *wake = Wakeup::wakeme;
	if (wake) wake->update();
}

void WakeupPrefs::load()
{
	KGlobal::config()->setGroup("Noatun Alarm");
	monday->setChecked(KGlobal::config()->readBoolEntry("Monday",false));
	tuesday->setChecked(KGlobal::config()->readBoolEntry("Tuesday",false));
	wednesday->setChecked(KGlobal::config()->readBoolEntry("Wednesday",false));
	thursday->setChecked(KGlobal::config()->readBoolEntry("Thursday",false));
	friday->setChecked(KGlobal::config()->readBoolEntry("Friday",false));
	saturday->setChecked(KGlobal::config()->readBoolEntry("Saturday",false));
	sunday->setChecked(KGlobal::config()->readBoolEntry("Sunday",false));

	hour1->setValue(KGlobal::config()->readNumEntry("Hour",7));
	minute1->setValue(KGlobal::config()->readNumEntry("Minute",0));
}

#include "wakeup.moc"
