//////////////////////////////////////////////////////////////
//      $Id: debAptInterface.h,v 1.9 2001/01/14 16:44:21 toivo Exp $ 
//
// Author: Toivo Pedaste
//
//////////////////////////////////////////////////////////////

#ifndef DEBAPT_IFACE_H
#define DEBAPT_IFACE_H

#include "../config.h"

#include <kaction.h>

#include "debInterface.h"

class DEBAPT: public DEB
{
  Q_OBJECT

public:
  DEBAPT(QString remote);
  ~DEBAPT();

  void setRemote(QString remote);
  // set remote access if requested

  void listPackages(QList<packageInfo> *pki);
  QStringList listInstalls(QStringList packs, bool install);

  QString doUninstall(int uninstallFlags, QString packs, bool &test);
  QString doInstall(int installFlags, QString packs, bool &test);
  QString install(int installFlags, QList<packageInfo> *p,
		  bool &test);

  void listRemotePackages(QList<packageInfo> *pki);
  QStringList getFileList(packageInfo *p);

  KAction *updateM, *upgradeM, *fixupM;

  void makeMenu(KAccel *keys, KActionCollection* act);
  void setMenu(KActionCollection* act, bool enable);

private slots:
  void updateS();	
  void upgradeS();
  void fixupS();

private:
  void listAvail(QList<packageInfo> *pki);
  void listRPack(QList<packageInfo> *pki);
  QStringList getRFileList(packageInfo *p);

};
#endif
