/***************************************************************************
                            HTMLObjectElement.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Generic embedded object. Note. In principle, all properties on the
 object element are read-write but in some environments some
 properties may be read-only once the underlying object is
 instantiated. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#edef-OBJECT">
 OBJECT element definition </a> in HTML 4.0.

 
 @short 
 Generic embedded object.
*/
public class HTMLObjectElement extends HTMLElement  {
	protected HTMLObjectElement(Class dummy){super((Class) null);}

	private native void newHTMLObjectElement();
	public HTMLObjectElement() {
		super((Class) null);
		newHTMLObjectElement();
	}
	private native void newHTMLObjectElement( HTMLObjectElement other);
	public HTMLObjectElement( HTMLObjectElement other) {
		super((Class) null);
		newHTMLObjectElement( other);
	}
	private native void newHTMLObjectElement( DOMNode other);
	public HTMLObjectElement( DOMNode other) {
		super((Class) null);
		newHTMLObjectElement( other);
	}
	protected native void finalize() throws InternalError;

/** 
 Returns the <code> FORM </code> element containing this
 control. Returns null if this control is not within the context
 of a form.

     
*/
	public native HTMLFormElement form();

/** 
 Applet class file. See the <code> code </code> attribute for
 HTMLAppletElement.

     
*/
	public native String code();

/** 
 see {@link code}
     
*/
	public native void setCode( String arg1);

/** 
 Aligns this object (vertically or horizontally) with respect to
 its surrounding text. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-align-IMG">
 align attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
	public native String align();

/** 
 see {@link align}
     
*/
	public native void setAlign( String arg1);

/** 
 Space-separated list of archives. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-archive-OBJECT">
 archive attribute definition </a> in HTML 4.0.

     
*/
	public native String archive();

/** 
 see {@link archive}
     
*/
	public native void setArchive( String arg1);

/** 
 Width of border around the object. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-border">
 border attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
	public native String border();

/** 
 see {@link border}
     
*/
	public native void setBorder( String arg1);

/** 
 Base URI for <code> classid </code> , <code> data </code> , and
 <code> archive </code> attributes. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-codebase-OBJECT">
 codebase attribute definition </a> in HTML 4.0.

     
*/
	public native String codeBase();

/** 
 see {@link codeBase}
     
*/
	public native void setCodeBase( String arg1);

/** 
 Content type for data downloaded via <code> classid </code>
 attribute. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-codetype">
 codetype attribute definition </a> in HTML 4.0.

     
*/
	public native String codeType();

/** 
 see {@link codeType}
     
*/
	public native void setCodeType( String arg1);

/** 
 A URI specifying the location of the object's data. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-data">
 data attribute definition </a> in HTML 4.0.

     
*/
	public native String data();

/** 
 see {@link data}
     
*/
	public native void setData( String arg1);

/** 
 Declare (for future reference), but do not instantiate, this
 object. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-declare">
 declare attribute definition </a> in HTML 4.0.

     
*/
	public native boolean declare();

/** 
 see {@link declare}
     
*/
	public native void setDeclare( boolean arg1);

/** 
 Override height. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-height-IMG">
 height attribute definition </a> in HTML 4.0.

     
*/
	public native String height();

/** 
 see {@link height}
     
*/
	public native void setHeight( String arg1);

/** 
 Horizontal space to the left and right of this image, applet,
 or object. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-hspace">
 hspace attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
	public native String hspace();

/** 
 see {@link hspace}
     
*/
	public native void setHspace( String arg1);

/** 
 Form control or object name when submitted with a form. See the
 <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-name-INPUT">
 name attribute definition </a> in HTML 4.0.

     
*/
	public native String name();

/** 
 see {@link name}
     
*/
	public native void setName( String arg1);

/** 
 Message to render while loading the object. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-standby">
 standby attribute definition </a> in HTML 4.0.

     
*/
	public native String standby();

/** 
 see {@link standby}
     
*/
	public native void setStandby( String arg1);

/** 
 Index that represents the element's position in the tabbing
 order. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-tabindex">
 tabindex attribute definition </a> in HTML 4.0.

     
*/
	public native long tabIndex();

/** 
 see {@link tabIndex}
     
*/
	public native void setTabIndex( long arg1);

/** 
 Content type for data downloaded via <code> data </code>
 attribute. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-type-OBJECT">
 type attribute definition </a> in HTML 4.0.

     
*/
	public native String type();

/** 
 see {@link type}
     
*/
	public native void setType( String arg1);

/** 
 Use client-side image map. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-usemap">
 usemap attribute definition </a> in HTML 4.0.

     
*/
	public native String useMap();

/** 
 see {@link useMap}
     
*/
	public native void setUseMap( String arg1);

/** 
 Vertical space above and below this image, applet, or object.
 See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-vspace">
 vspace attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
	public native String vspace();

/** 
 see {@link vspace}
     
*/
	public native void setVspace( String arg1);

/** 
 Override width. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-width-IMG">
 width attribute definition </a> in HTML 4.0.

     
*/
	public native String width();

/** 
 see {@link width}
     
*/
	public native void setWidth( String arg1);
//	private native void newHTMLObjectElement( HTMLObjectElementImpl impl);
//	public HTMLObjectElement( HTMLObjectElementImpl impl) {
//		super((Class) null);
//		newHTMLObjectElement( impl);
//	}
}
