package org.kde.koala;
import org.kde.qt.*;


/** {@link KDialogBase} emits these signals */
public interface KDialogBaseSignals {

/**  
 The User3 button was pressed. This signal is only emitted if
 {@link KDialogBase#slotUser3} is not replaced.
     
*/
	void user3Clicked();
	void destroyed();

/**  
 The Yes button was pressed. This signal is only emitted if
 {@link KDialogBase#slotYes} is not replaced.
     
*/
	void yesClicked();

/**  
 The Help button was pressed. This signal is only emitted if
 {@link KDialogBase#slotHelp} is not replaced.
     
*/
	void helpClicked();

/**  
 The Apply button was pressed. This signal is only emitted if
 {@link KDialogBase#slotApply} is not replaced.
     
*/
	void applyClicked();

/**  
 The Default button was pressed. This signal is only emitted if
 {@link KDialogBase#slotDefault} is not replaced.
     
*/
	void defaultClicked();

/**  
 The Try button was pressed. This signal is only emitted if
 {@link KDialogBase#slotTry} is not replaced.
     
*/
	void tryClicked();

/**  
 The No button was pressed. This signal is only emitted if
 {@link KDialogBase#slotNo} is not replaced.
     
*/
	void noClicked();

/**  
 The detailsWidget is about to get shown. This is your last chance
 to call setDetailsWidget if you haven't done so yet.
     
*/
	void aboutToShowDetails();

/**  
 The Cancel button was pressed. This signal is only emitted if
 {@link KDialogBase#slotCancel} is not replaced.
     
*/
	void cancelClicked();

/**  
 Do not use this signal. Is is kept for compatibility reasons.
 Use {@link KDialogBase#applyClicked} instead.
     
*/
	void apply();

/** 
 The dialog has finished.

 A dialog emits finished after a user clicks a button that ends
 the dialog.

 This signal is also emitted when you call {@link KDialogBase#hide}

 If you have stored a pointer to the
 dialog do <em>not</em> try to delete the pointer in the slot that is
 connected to this signal.

 You should use {@link KDialogBase#delayedDestruct} instead.
     
*/
	void finished();

/**  
 The background tile has changed.
     
*/
	void backgroundChanged();

/**  
 The User1 button was pressed. This signal is only emitted if
 {@link KDialogBase#slotUser1} is not replaced.
     
*/
	void user1Clicked();

/** 
 Emitted when the margin size and/or spacing size 
 have changed.

 Use {@link KDialogBase#marginHint} and  {@link KDialogBase#spacingHint} in your slot
 to get the new values.
     
*/
	void layoutHintChanged();

/**  
 The Close button was pressed. This signal is only emitted if
 {@link KDialogBase#slotClose} is not replaced.
     
*/
	void closeClicked();

/**  
 The OK button was pressed. This signal is only emitted if
 {@link KDialogBase#slotOk} is not replaced.
     
*/
	void okClicked();

/** 
 The dialog is about to be hidden.

 A dialog is hidden after a user clicks a button that ends
 the dialog or when the user switches to another desktop or
 minimizes the dialog.
     
*/
	void hidden();

/**  
 The User2 button was pressed. This signal is only emitted if
 {@link KDialogBase#slotUser2} is not replaced.
     
*/
	void user2Clicked();
}

