/***************************************************************************
                            Slave.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 There are two classes that specifies the protocol between application (job)
 and kioslave. SlaveInterface is the class to use on the application end,
 SlaveBase is the one to use on the slave end.

 A call to foo() results in a call to slotFoo() on the other end.
 
 See {@link SlaveInterfaceSignals} for signals emitted by SlaveInterface.

 See {@link SlaveInterfaceEventHandling} for event handlers to override in subclasses of SlaveInterface.

 @short 
 There are two classes that specifies the protocol between application (job)
 and kioslave.
*/
public class Slave extends QObject  {
	protected Slave(Class dummy){super((Class) null);}

	private native void newSlave( Connection connection);
	public Slave( Connection connection) {
		super((Class) null);
		newSlave( connection);
	}
	protected native void finalize() throws InternalError;
	public native void setConnection( Connection connection);
	public native Connection connection();
	public native void setProgressId( int identifier);
	public native int progressId();
	public native void sendResumeAnswer( boolean resume);
	protected native boolean dispatch();
	protected native boolean dispatch( int _cmd, byte[] data);

/** 
 Prompt the user for authrization info (login & password).

 Use this function to request authorization info from the
 the end user. For example to open an empty password dialog
 using default values:

 <pre>
 KIO.AuthInfo authInfo;
 boolean result = openPassDlg( authInfo );
 if ( result )
 {
    printf( "Username: %s", result.username.latin1() );
    printf( "Username: %s", result.username.latin1() );
 }
 </pre>

 You can also pre-set some values like the username before hand
 if it is known as well as the comment and caption to be displayed:

 <pre>
 authInfo.comment= "Enter username and password to access acmeone";
 authInfo.caption= "Acme Password Dialog";
 authInfo.username= "Wily E. kaiody";
 boolean result = openPassDlg( authInfo );
 if ( result )
 {
    printf( "Username: %s", result.username.latin1() );
    printf( "Username: %s", result.username.latin1() );
 }
 </pre>

 NOTE: A call to this function can also fail and result
 in a return value of <code>false</code>, if the UIServer could not
 be started for whatever reason.

*/
	protected native void openPassDlg( int info);

/** 
 Same as above except in the argument it accepts.

    
*/
	protected native void openPassDlg( String prompt, String user, String caption, String comment, String label, boolean readOnly);

/** 
 Same as above except in the argument it accepts.

    
*/
	protected native void openPassDlg( String prompt, String user, boolean readOnly);
	protected native void messageBox( int type, String text, String caption, String buttonYes, String buttonNo);
	protected native void requestNetwork( String arg1, String arg2);
	protected native void dropNetwork( String arg1, String arg2);

/** 

     
*/
	protected static native void sigpipe_handler( int arg1);
}
