/***************************************************************************
                          KDEJavaSlot.cpp  -  description
                             -------------------
    copyright            : (C) 2000-2001 by Richard Dale
    email                : Richard_Dale@tipitina.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "KDEJavaSlot.moc"
#include <qtjava/QtSupport.h>
#include <kdejava/KDESupport.h>

/*
 Converts a Java type signature, from a signal or slot, to the corresponding C++ KDE type.
 Used to connect a Java slot to a signal emitted by the underlying C++ KDE instance.
 Note that all Java slots and signals are of type jobjectArray, and so no conversion is needed for them.
*/
static const char * const javaToQtTypeSignatureMap[][2] = {
	{"(int)",													"(int)"},
	{"(Node)",													"(const DOM::Node&)"},
	{"(Node,long)",												"(const DOM::Node&,long)"},
	{"(KBookmark,QPopupMenu)",									"(const KBookmark&,QPopupMenu*)"},
	{"(KDataToolInfo,String)",									"(const KDataToolInfo&,const QString&)"},
	{"(KFileItem)",												"(const KFileItem*)"},
	{"(KFileItem,QPixmap)",										"(const KFileItem*,const QPixmap&)"},
	{"(KFileItem,QPoint)",										"(const KFileItem*,const QPoint&)"},
	{"(KFileItemList)",											"(const KFileItemList&)"},
	{"(KFileItem,QDropEvent,ArrayList)",						"(const KFileItem*,QDropEvent*,const KURL::List&)"},
	{"(KShortcut)",												"(const KShortcut&)"},
	{"(KURL)",													"(const KURL&)"},
	{"(KURL,KURL)",												"(const KURL&,const KURL&)"},
	{"(KURL,QPixmap)",											"(const KURL&,const QPixmap&)"},
	{"(KURL,String)",											"(const KURL&,const QString&)"},
	{"(KURL,URLArgs)",											"(const KURL&,const KParts::URLArgs&)"},
	{"(ArrayList)",												"(const KURL::List&)"},
	{"(QPoint,ArrayList)",										"(const QPoint&,const KFileItemList&)"},
	{"(QPoint,KURL,String)",									"(const QPoint&,const KURL&,const QString&)"},
	{"(QPoint,KURL,String,int)",								"(const QPoint&,const KURL&,const QString&,mode_t)"},
	{"(KAction)",												"(KAction*)"},
	{"(KAction,boolean)",										"(KAction*,bool)"},
	{"(int)",													"(KCompletionBase::KeyBindingType)"},
	{"(KDockWidget)",											"(KDockWidget*)"},
	{"(KDockWidget,KDockWidget)",								"(KDockWidget*,KDockWidget*)"},
	{"(KDockWidget,int)",										"(KDockWidget*,KDockWidget::DockPosition)"},
	{"(int)",													"(KDualColorButton::DualColor)"},
	{"(KFileItem)",												"(KFileItem*)"},
	{"(KFileTreeViewItem)",										"(KFileTreeViewItem*)"},
	{"(KFileTreeViewItem,int)",									"(KFileTreeViewItem*,int)"},
	{"(KFileTreeView,QDropEvent,QListViewItem)",				"(KFileTreeView*,QDropEvent*,QListViewItem*)"},
	{"(KFileTreeView,QDropEvent,QListViewItem,QListViewItem)",	"(KFileTreeView*,QDropEvent*,QListViewItem*,QListViewItem*)"},
	{"(KFileView)",												"(KFileView*)"},
	{"(int)",													"(KGlobalSettings::Completion)"},
	{"(Job)",													"(KIO::Job*)"},
	{"(Job,KURL)",												"(KIO::Job*,const KURL&)"},
	{"Job,KURL,KURL)",											"(KIO::Job*,const KURL&,const KURL&)"},
	{"Job,KURL,KURL,boolean,boolean)",							"(KIO::Job*,const KURL&,const KURL&,bool,bool)"},
	{"Job,KURL,String,KURL)",									"(KIO::Job*,const KURL&,const QString&,const KURL&)"},
	{"Job,byte[])",												"(KIO::Job*,const QByteArray&)"},
	{"Job,String)",												"(KIO::Job*,const QString&)"},
	{"Job,String,KURL)",										"(KIO::Job*,const QString&,const KURL&)"},
	{"Job,long)",												"(KIO::Job*,KIO::filesize_t)"},
	{"Job,ByteArrayOutputStream)",								"(KIO::Job*,QByteArray&)"},
	{"Job,long)",												"(KIO::Job*,unsigned long)"},
	{"(Slave)",													"(KIO::Slave*)"},
	{"(SkipDlg,int)",											"(KIO::SkipDlg*,int)"},
	{"(Slave,int,String)",										"(KIO::Slave*,int,const QString&)"},
	{"(KListView,QDropEvent,QListViewItem)",					"(KListView*,QDropEvent*,QListViewItem*)"},
	{"(KListView,QDropEvent,QListViewItem,QListViewItem)",		"(KListView*,QDropEvent*,QListViewItem*,QListViewItem*)"},
	{"(KListView,QListViewItem)",								"(KListView*,QListViewItem*)"},
	{"(KListView,QListViewItem,QPoint)",						"(KListView*,QListViewItem*,const QPoint&)"},
	{"(KMdiChildFrm)",											"(KMdiChildFrm*)"},
	{"(KMdiChildFrm,KMdiChildFrm)",								"(KMdiChildFrm*,KMdiChildFrm*)"},
	{"(KMdiChildView)",											"(KMdiChildView*)"},
	{"(KMdiChildView,boolean)",									"(KMdiChildView*,bool)"},
	{"(int)",													"(KMdi::MdiMode)"},
	{"(Part)",													"(KParts::Part*)"},
	{"(KPopupMenu,Calendar)",									"(KPopupMenu*,const QDate&)"},
	{"(KPopupMenu,int,QPopupMenu)",								"(KPopupMenu*,int,QPopupMenu*)"},
	{"(KProcess)",												"(KProcess*)"},
	{"(KProcess,String,int)",									"(KProcess*,char*,int)"},
	{"(KProcIO)",												"(KProcIO*)"},
	{"(KSpell)",												"(KSpell*)"},
	{"(int)",													"(KToolBar::BarPosition)"},
	{"(ArrayList,KURL)",										"(KURL::List&,KURL&)"},
	{"(KURLRequester)",											"(KURLRequester*)"},
	{"(KXMLGUIClient)",											"(KXMLGUIClient*)"},
	{"(KXMLGUIClient,QPoint,KFileItemList)",					"(KXMLGUIClient*,const QPoint&,const KFileItemList&)"},
	{"(KXMLGUIClient,QPoint,KURL,String)",						"(KXMLGUIClient*,const QPoint&,const KURL&,const QString&)"},
	{"(KXMLGUIClient,QPoint,KURL,String,int)",					"(KXMLGUIClient*,const QPoint&,const KURL&,const QString&,mode_t)"},
	{"(int,String,String,boolean)",								"(pid_t,const QCString&,const QString&,bool)"},
	{"(QDropEvent,ArrayList,KURL)",								"(QDropEvent*,const KURL::List&,const KURL&)"},
	{"(QDropEvent,KFileItem)",									"(QDropEvent*,KFileItem*)"},
	{"(QWidget,QDropEvent,ArrayList)",							"(QWidget*,QDropEvent*,KURL::List&)"},
	{"(QWidget,QDropEvent,ArrayList,KURL)",						"(QWidget*,QDropEvent*,KURL::List&,KURL&)"}
};

KDEJavaSlot::KDEJavaSlot(JNIEnv * env, jobject receiver, jstring slot)
	: JavaSlot(env, receiver, slot)
{
}

KDEJavaSlot::~KDEJavaSlot()
{
}


const char *
KDEJavaSlot::javaToQtSignalType(const char * signalName, const char * javaTypeSignature, QMetaObject * smeta)
{
static char qtSignalString[200];

	for (	unsigned int index = 0;
			index < sizeof(javaToQtTypeSignatureMap)/sizeof(*javaToQtTypeSignatureMap);
			index++ )
	{
		if (strcmp(javaTypeSignature, javaToQtTypeSignatureMap[index][0]) == 0) {
			(void) sprintf(qtSignalString, "%s%s", signalName, javaToQtTypeSignatureMap[index][1]);
			
			if (smeta == 0 || smeta->findSignal(((const char *) qtSignalString + 1), TRUE) >= 0) {
				return qtSignalString;
			}
		}
	}

	return JavaSlot::javaToQtSignalType(signalName, javaTypeSignature, smeta);
}

const char *
KDEJavaSlot::javaToQtSlotType(const char * javaTypeSignature, const char * signalString)
{
	for (	unsigned int index = 0;
			index < sizeof(javaToQtTypeSignatureMap)/sizeof(*javaToQtTypeSignatureMap);
			index++ )
	{
		if (	strcmp(javaTypeSignature, javaToQtTypeSignatureMap[index][0]) == 0
				&& (	signalString == 0
						|| QObject::checkConnectArgs(signalString, (const QObject *) 0, javaToQtTypeSignatureMap[index][1]) ) )
		{
			return javaToQtTypeSignatureMap[index][1];
		}
	}

	return JavaSlot::javaToQtSlotType(javaTypeSignature, signalString);
}

void
KDEJavaSlot::invoke(const DOM::Node& arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.kde.koala.DOMNode") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(const DOM::Node& arg1,long arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;J)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.kde.koala.DOMNode"), (jlong) arg2 );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(const KBookmark& arg1,QPopupMenu* arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.kde.koala.KBookmark"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.kde.qt.QPopupMenu") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(const KDataToolInfo& arg1,const QString& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.kde.koala.KDataToolInfo"),
									QtSupport::fromQString(env, (QString *) &arg2) );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(const KFileItem* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KFileItem") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(const KFileItem* arg1,const QPixmap& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KFileItem"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.kde.qt.QPixmap") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(const KFileItem* arg1,const QPoint& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KFileItem"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.kde.qt.QPoint") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(const KFileItem* arg1,QDropEvent* arg2,const KURL::List& arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KFileItem"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.kde.qt.QDropEvent"),
									KDESupport::arrayWithKURLList(env, (KURL::List *) &arg3) );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(const KFileItemList& arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									KDESupport::arrayWithKFileItemList(env, (KFileItemList*) &arg1) );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(const KShortcut& arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.kde.koala.KShortcut") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(const KURL& arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.kde.koala.KURL") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(const KURL& arg1,const KURL& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.kde.koala.KURL"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.kde.koala.KURL") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(const KURL& arg1,const QPixmap& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.kde.koala.KURL"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.kde.qt.QPixmap") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(const KURL& arg1,const QString& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.kde.koala.KURL"),
									QtSupport::fromQString(env, (QString *) &arg2) );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(const KURL&arg1, const KParts::URLArgs& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.kde.koala.KURL"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.kde.koala.URLArgs") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(const KURL::List& arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, KDESupport::arrayWithKURLList(env, (KURL::List *) &arg1));
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(const QPoint& arg1,const KFileItemList& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.kde.qt.QPoint"),
									KDESupport::arrayWithKFileItemList(env, (KFileItemList*) &arg2) );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(const QPoint& arg1,const KURL& arg2,const QString& arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.kde.qt.QPoint"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.kde.koala.KURL"),
									QtSupport::fromQString(env, (QString*) &arg3) );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(const QPoint& arg1,const KURL& arg2,const QString& arg3,mode_t arg4)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.kde.qt.QPoint"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.kde.koala.KURL"),
									QtSupport::fromQString(env, (QString*) &arg3),
									(jint) arg4 );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KAction* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KAction"));
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KAction* arg1,bool arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Z)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KAction"), (jboolean) arg2);
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KCompletionBase::KeyBindingType arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, (jint) arg1);
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KDockWidget* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KDockWidget"));
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KDockWidget*arg1,KDockWidget*arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KDockWidget"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.kde.koala.KDockWidget") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KDockWidget*arg1,KDockWidget::DockPosition arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KDockWidget"), (jint) arg2);
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KDualColorButton::DualColor arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, (jint) arg1);
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KFileItem* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KFileItem") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KFileTreeView* arg1,QDropEvent* arg2,QListViewItem* arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KFileTreeView"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.kde.qt.QDropEvent"),
									QtSupport::objectForQtKey(env, (void *) arg3, "org.kde.qt.QListViewItem") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KFileTreeView* arg1,QDropEvent* arg2,QListViewItem* arg3,QListViewItem* arg4)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KFileTreeView"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.kde.qt.QDropEvent"),
									QtSupport::objectForQtKey(env, (void *) arg3, "org.kde.qt.QListViewItem"),
									QtSupport::objectForQtKey(env, (void *) arg4, "org.kde.qt.QListViewItem") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KFileTreeViewItem* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KFileTreeViewItem") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KFileTreeViewItem* arg1,int arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KFileTreeViewItem"),
									(jint) arg2 );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KFileView* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KFileView") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KGlobalSettings::Completion arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, (jint) arg1);
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KIO::Job* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Job") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KIO::Job* arg1,const KURL& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Job"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.kde.koala.KURL") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KIO::Job* arg1,const KURL& arg2,const KURL& arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Job"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.kde.koala.KURL"),
									QtSupport::objectForQtKey(env, (void *) &arg3, "org.kde.koala.KURL") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KIO::Job* arg1,const KURL& arg2,const KURL& arg3,bool arg4,bool arg5)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;ZZ)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Job"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.kde.koala.KURL"),
									QtSupport::objectForQtKey(env, (void *) &arg3, "org.kde.koala.KURL"),
									(jboolean) arg4,
									(jboolean) arg5 );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KIO::Job* arg1,const KURL& arg2,const QString& arg3,const KURL& arg4)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Job"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.kde.koala.KURL"),
									QtSupport::fromQString(env, (QString *) &arg3),
									QtSupport::objectForQtKey(env, (void *) &arg4, "org.kde.koala.KURL") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KIO::Job* arg1,const QByteArray& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;[B)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Job"),
									QtSupport::fromQByteArray(env, (QByteArray*) &arg2) );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KIO::Job* arg1,const QString& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Job"),
									QtSupport::fromQString(env, (QString *) &arg2) );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KIO::Job* arg1,const QString& arg2,const KURL& arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Job"),
									QtSupport::fromQString(env, (QString *) &arg2),
									QtSupport::objectForQtKey(env, (void *) &arg3, "org.kde.koala.KURL") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KIO::Job* arg1,KIO::filesize_t arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;J)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Job"),
									(jlong) arg2 );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KIO::Job* arg1,QByteArray& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jclass          byteStreamClass;
	jmethodID       resetMid;
	jobject         result;
	jobject         byteStream;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	
	byteStream = QtSupport::objectForQtKey(env, (void *) &arg2, "java.io.ByteArrayOutputStream");
	
	byteStreamClass = env->GetObjectClass(byteStream);
	resetMid = env->GetMethodID(byteStreamClass, "reset", "()V");
	if (resetMid == NULL) {
		return ;
	}

	env->CallVoidMethod(byteStream, resetMid);
	
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Job"),
									byteStream );
	(void) KDESupport::toQByteArrayFromStream(env, &arg2, byteStream);
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KIO::Job* arg1,unsigned long arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;J)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Job"),
									(jlong) arg2 );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KIO::SkipDlg* arg1,int arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.SkipDlg"),
									(jint) arg2 );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KIO::Slave* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Slave") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KIO::Slave* arg1,int arg2,const QString& arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;ILjava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Slave"),
									(jint) arg2,
									QtSupport::fromQString(env, (QString *) &arg3) );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KListView*arg1,QDropEvent*arg2,QListViewItem*arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KListView"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.kde.qt.QDropEvent"),
									QtSupport::objectForQtKey(env, (void *) arg3, "org.kde.qt.QListViewItem") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KListView*arg1,QDropEvent*arg2,QListViewItem*arg3,QListViewItem*arg4)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KListView"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.kde.qt.QDropEvent"),
									QtSupport::objectForQtKey(env, (void *) arg3, "org.kde.qt.QListViewItem"),
									QtSupport::objectForQtKey(env, (void *) arg4, "org.kde.qt.QListViewItem") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KListView*arg1,QListViewItem*arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KListView"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.kde.qt.QListViewItem") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KListView*arg1,QListViewItem*arg2,const QPoint&arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KListView"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.kde.qt.QListViewItem"),
									QtSupport::objectForQtKey(env, (void *) &arg3, "org.kde.qt.QPoint") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KMdiChildFrm* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KMdiChildFrm"));
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KMdiChildFrm* arg1,KMdiChildFrm* arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid, 
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KMdiChildFrm"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.kde.koala.KMdiChildFrm") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KMdiChildView* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KMdiChildView"));
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KMdiChildView* arg1,bool arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Z)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KMdiChildView"), (jboolean) arg2);
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KMdi::MdiMode arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, (jint) arg1);
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KParts::Part* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.Part") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KPopupMenu* arg1,const QDate& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid, 
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KPopupMenu"),
									QtSupport::fromQDate(env, (QDate*) &arg2) );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KPopupMenu* arg1,int arg2,QPopupMenu* arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;ILjava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid, 
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KPopupMenu"),
									(jint) arg2,
									QtSupport::objectForQtKey(env, (void *) arg3, "org.kde.koala.QPopupMenu") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KProcess* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KProcess") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KProcess* arg1,char* arg2, int arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KProcess"),
									QtSupport::fromCharString(env, arg2),
									(jint) arg3 );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KProcIO* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KProcIO") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KSpell* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KSpell") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KToolBar::BarPosition arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, (jint) arg1);
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KURL::List& arg1,KURL& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									KDESupport::arrayWithKURLList(env, (KURL::List *) &arg1),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.kde.koala.KURL") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KURLRequester* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KURLRequester") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KXMLGUIClient* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KXMLGUIClient") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KXMLGUIClient* arg1,const QPoint& arg2,const KFileItemList& arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KXMLGUIClient"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.kde.qt.QPoint"),
									KDESupport::arrayWithKFileItemList(env, (KFileItemList*) &arg3) );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KXMLGUIClient* arg1,const QPoint& arg2,const KURL& arg3,const QString& arg4)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KXMLGUIClient"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.kde.qt.QPoint"),
									QtSupport::objectForQtKey(env, (void *) &arg3, "org.kde.qt.KURL"),
									QtSupport::fromQString(env, (QString*)&arg4) );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(KXMLGUIClient* arg1,const QPoint& arg2,const KURL& arg3,const QString& arg4,mode_t arg5)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.koala.KXMLGUIClient"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.kde.qt.QPoint"),
									QtSupport::objectForQtKey(env, (void *) &arg3, "org.kde.qt.KURL"),
									QtSupport::fromQString(env, (QString*)&arg4),
									(jint) arg5 );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(pid_t arg1,const QCString& arg2,const QString& arg3,bool arg4)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(ILjava/lang/Object;Ljava/lang/Object;Z)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									(jint) arg1,
									QtSupport::fromQCString(env, (QCString *) &arg2),
									QtSupport::fromQString(env, (QString *) &arg3),
									(jboolean) arg4 );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(QDropEvent* arg1,const KURL::List& arg2,const KURL& arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.qt.QDropEvent"),
									KDESupport::arrayWithKURLList(env, (KURL::List *) &arg2),
									QtSupport::objectForQtKey(env, (void *) &arg3, "org.kde.koala.KURL") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(QDropEvent* arg1,KFileItem* arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.qt.QDropEvent"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.kde.koala.KFileItem") );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(QWidget* arg1,QDropEvent* arg2,KURL::List& arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.qt.QWidget"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.kde.qt.QDropEvent"),
									KDESupport::arrayWithKURLList(env, (KURL::List *) &arg3) );
	env->PopLocalFrame(0);
}

void
KDEJavaSlot::invoke(QWidget* arg1,QDropEvent* arg2,KURL::List& arg3,KURL& arg4)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.kde.qt.QWidget"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.kde.qt.QDropEvent"),
									KDESupport::arrayWithKURLList(env, (KURL::List *) &arg3),
									QtSupport::objectForQtKey(env, (void *) &arg4, "org.kde.koala.KURL") );
	env->PopLocalFrame(0);
}

KDEJavaSlotFactory::KDEJavaSlotFactory()
	: JavaSlotFactory()
{
}

JavaSlot *
KDEJavaSlotFactory::createJavaSlot(JNIEnv * env, jobject receiver, jstring slot)
{
	return new KDEJavaSlot(env, receiver, slot);
}


