/*
 * This file is part of the QPackageKit project
 * Copyright (C) 2008 Adrien Bustany <madcat@mymadcat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB. If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "PkKPolkitClient.h"

//#include "config.h"

//#ifdef USE_SECURITY_POLKIT
#include <polkit-dbus/polkit-dbus.h>
//#endif

#include <QCoreApplication>

#include <KDebug>
#include <kglobal.h>


class PkKPolkitClientHelper
{
public:
    PkKPolkitClientHelper() : q(0) {}
    ~PkKPolkitClientHelper() {
        delete q;
    }
    PkKPolkitClient *q;
};

K_GLOBAL_STATIC(PkKPolkitClientHelper, s_globalPkKPolkitClient)

PkKPolkitClient *PkKPolkitClient::instance()
{
    if (!s_globalPkKPolkitClient->q) {
        new PkKPolkitClient;
    }

    return s_globalPkKPolkitClient->q;
}

PkKPolkitClient::PkKPolkitClient(QObject *parent)
        : QObject(parent)
{
    Q_ASSERT(!s_globalPkKPolkitClient->q);
    s_globalPkKPolkitClient->q = this;
}

//#ifdef USE_SECURITY_POLKIT
bool PkKPolkitClient::getAuth(const QString &action)
{
    DBusError e;
    dbus_error_init(&e);

    if (polkit_check_auth(QCoreApplication::applicationPid(), action.toAscii().data(), NULL))
        return true;

    bool auth = polkit_auth_obtain(action.toAscii().data(), 0, QCoreApplication::applicationPid(), &e);
    if (!auth) {
        kDebug() << "Authentication error :" << e.name << ":" << e.message;
    }

    return auth;
}
//#else
//bool PolkitClient::getAuth(const QString &action) {
//      qDebug() << "Not configured with PolicyKit support";
//      return false;
//}
//#endif

#include "PkKPolkitClient.moc"
