//Auto-generated by kalyptus. DO NOT EDIT.
namespace Plasma {
    using Plasma;
    using System;
    using Kimono;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  @class Wallpaper plasma/wallpaper.h <Plasma/Wallpaper>
    ///  "Wallpapers" are components that paint the background for Containments that
    ///  do not provide their own background rendering.
    ///  Wallpaper plugins are registered using .desktop files. These files should be
    ///  named using the following naming scheme:
    ///      plasma-wallpaper-\<pluginname\>.desktop
    ///  If a wallpaper plugin provides more than on mode (e.g. Single Image, Wallpaper)
    ///  it should include a Actions= entry in the .desktop file, listing the possible
    ///  actions. An actions group should be included to provide for translatable names.
    ///   See <see cref="IWallpaperSignals"></see> for signals emitted by Wallpaper
    /// </remarks>        <short> The base Wallpaper class.</short>
    [SmokeClass("Plasma::Wallpaper")]
    public abstract class Wallpaper : QObject {
        protected Wallpaper(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Wallpaper), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static Wallpaper() {
            staticInterceptor = new SmokeInvocation(typeof(Wallpaper), null);
        }
        /// <remarks>
        ///  Various resize modes supported by the built in image renderer
        ///          </remarks>        <short>    Various resize modes supported by the built in image renderer          </short>
        public enum ResizeMethod {
            ScaledResize = 0,
            CenteredResize = 1,
            ScaledAndCroppedResize = 2,
            TiledResize = 3,
            CenterTiledResize = 4,
            MaxpectResize = 5,
        }
        [Q_PROPERTY("QRectF", "boundingRect")]
        public QRectF BoundingRect {
            get { return (QRectF) interceptor.Invoke("boundingRect", "boundingRect()", typeof(QRectF)); }
            set { interceptor.Invoke("setBoundingRect#", "setBoundingRect(QRectF)", typeof(void), typeof(QRectF), value); }
        }
        [Q_PROPERTY("QString", "name")]
        public string Name {
            get { return (string) interceptor.Invoke("name", "name()", typeof(string)); }
        }
        [Q_PROPERTY("QString", "pluginName")]
        public string PluginName {
            get { return (string) interceptor.Invoke("pluginName", "pluginName()", typeof(string)); }
        }
        [Q_PROPERTY("QString", "icon")]
        public string icon {
            get { return (string) interceptor.Invoke("icon", "icon()", typeof(string)); }
        }
        [Q_PROPERTY("KServiceAction", "renderingMode")]
        public KServiceAction RenderingMode {
            get { return (KServiceAction) interceptor.Invoke("renderingMode", "renderingMode()", typeof(KServiceAction)); }
        }
        [Q_PROPERTY("QList<KServiceAction>", "listRenderingModes")]
        public List<KServiceAction> ListRenderingModes {
            get { return (List<KServiceAction>) interceptor.Invoke("listRenderingModes", "listRenderingModes()", typeof(List<KServiceAction>)); }
        }
        [Q_PROPERTY("bool", "usingRenderingCache")]
        public bool UsingRenderingCache {
            get { return (bool) interceptor.Invoke("isUsingRenderingCache", "isUsingRenderingCache()", typeof(bool)); }
            set { interceptor.Invoke("setUsingRenderingCache$", "setUsingRenderingCache(bool)", typeof(void), typeof(bool), value); }
        }
        /// <remarks>
        ///  Default constructor for an empty or null wallpaper
        ///          </remarks>        <short>    Default constructor for an empty or null wallpaper          </short>
        public Wallpaper(QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Wallpaper#", "Wallpaper(QObject*)", typeof(void), typeof(QObject), parent);
        }
        public Wallpaper() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Wallpaper", "Wallpaper()", typeof(void));
        }
        /// <remarks>
        ///  Accessor for the associated Package object if any.
        /// </remarks>        <return> the Package object, or 0 if none
        /// </return>
        ///         <short>    Accessor for the associated Package object if any.</short>
        public Plasma.Package Package() {
            return (Plasma.Package) interceptor.Invoke("package", "package() const", typeof(Plasma.Package));
        }
        /// <remarks>
        /// </remarks>        <return> true if initialized (usually by calling restore), false otherwise
        ///          </return>
        ///         <short>   </short>
        public bool IsInitialized() {
            return (bool) interceptor.Invoke("isInitialized", "isInitialized() const", typeof(bool));
        }
        /// <remarks>
        ///  This method is called when the wallpaper should be painted.
        /// <param> name="painter" the QPainter to use to do the painting
        /// </param><param> name="exposedRect" the rect to paint within
        /// </param></remarks>        <short>    This method is called when the wallpaper should be painted.</short>
        [SmokeMethod("paint(QPainter*, const QRectF&)")]
        public abstract void Paint(QPainter painter, QRectF exposedRect);
        /// <remarks>
        ///  This method should be called once the wallpaper is loaded or mode is changed.
        /// <param> name="config" Config group to load settings
        /// </param></remarks>        <short>    This method should be called once the wallpaper is loaded or mode is changed.</short>
        ///         <see> init</see>
        public void Restore(KConfigGroup config) {
            interceptor.Invoke("restore#", "restore(const KConfigGroup&)", typeof(void), typeof(KConfigGroup), config);
        }
        /// <remarks>
        ///  This method is called when settings need to be saved.
        /// <param> name="config" Config group to save settings
        /// </param></remarks>        <short>    This method is called when settings need to be saved.</short>
        [SmokeMethod("save(KConfigGroup&)")]
        public virtual void Save(KConfigGroup config) {
            interceptor.Invoke("save#", "save(KConfigGroup&)", typeof(void), typeof(KConfigGroup), config);
        }
        /// <remarks>
        ///  Returns a widget that can be used to configure the options (if any)
        ///  associated with this wallpaper. It will be deleted by the caller
        ///  when it complete. The default implementation returns a null pointer.
        ///  To signal that settings have changed connect to
        ///  settingsChanged(bool modified) in <code>parent.</code>
        ///  @code connect(this, SIGNAL(settingsChanged(bool), parent, SLOT("settingsChanged(bool)"))
        ///  @endcode
        ///  Emit settingsChanged(true) when the settings are changed and false when the original state is restored.
        ///  Implementation detail note: for best visual results, use a QGridLayout with two columns,
        ///  with the option labels in column 0
        ///          </remarks>        <short>    Returns a widget that can be used to configure the options (if any)  associated with this wallpaper.</short>
        [SmokeMethod("createConfigurationInterface(QWidget*)")]
        public virtual QWidget CreateConfigurationInterface(QWidget parent) {
            return (QWidget) interceptor.Invoke("createConfigurationInterface#", "createConfigurationInterface(QWidget*)", typeof(QWidget), typeof(QWidget), parent);
        }
        /// <remarks>
        ///  Mouse move event. To prevent further propagation of the event,
        ///  the event must be accepted.
        /// <param> name="event" the mouse event object
        ///          </param></remarks>        <short>    Mouse move event.</short>
        [SmokeMethod("mouseMoveEvent(QGraphicsSceneMouseEvent*)")]
        public virtual void MouseMoveEvent(QGraphicsSceneMouseEvent arg1) {
            interceptor.Invoke("mouseMoveEvent#", "mouseMoveEvent(QGraphicsSceneMouseEvent*)", typeof(void), typeof(QGraphicsSceneMouseEvent), arg1);
        }
        /// <remarks>
        ///  Mouse press event. To prevent further propagation of the even,
        ///  and to receive mouseMoveEvents, the event must be accepted.
        /// <param> name="event" the mouse event object
        ///          </param></remarks>        <short>    Mouse press event.</short>
        [SmokeMethod("mousePressEvent(QGraphicsSceneMouseEvent*)")]
        public virtual void MousePressEvent(QGraphicsSceneMouseEvent arg1) {
            interceptor.Invoke("mousePressEvent#", "mousePressEvent(QGraphicsSceneMouseEvent*)", typeof(void), typeof(QGraphicsSceneMouseEvent), arg1);
        }
        /// <remarks>
        ///  Mouse release event. To prevent further propagation of the event,
        ///  the event must be accepted.
        /// <param> name="event" the mouse event object
        ///          </param></remarks>        <short>    Mouse release event.</short>
        [SmokeMethod("mouseReleaseEvent(QGraphicsSceneMouseEvent*)")]
        public virtual void MouseReleaseEvent(QGraphicsSceneMouseEvent arg1) {
            interceptor.Invoke("mouseReleaseEvent#", "mouseReleaseEvent(QGraphicsSceneMouseEvent*)", typeof(void), typeof(QGraphicsSceneMouseEvent), arg1);
        }
        /// <remarks>
        ///  Mouse wheel event. To prevent further propagation of the event,
        ///  the event must be accepted.
        /// <param> name="event" the wheel event object
        ///          </param></remarks>        <short>    Mouse wheel event.</short>
        [SmokeMethod("wheelEvent(QGraphicsSceneWheelEvent*)")]
        public virtual void WheelEvent(QGraphicsSceneWheelEvent arg1) {
            interceptor.Invoke("wheelEvent#", "wheelEvent(QGraphicsSceneWheelEvent*)", typeof(void), typeof(QGraphicsSceneWheelEvent), arg1);
        }
        /// <remarks>
        ///  Loads the given DataEngine
        ///  Tries to load the data engine given by <code>name.</code>  Each engine is
        ///  only loaded once, and that instance is re-used on all subsequent
        ///  requests.
        ///  If the data engine was not found, an invalid data engine is returned
        ///  (see DataEngine.IsValid()).
        ///  Note that you should <em>not</em> delete the returned engine.
        /// <param> name="name" Name of the data engine to load
        /// </param></remarks>        <return> pointer to the data engine if it was loaded,
        ///          or an invalid data engine if the requested engine
        ///          could not be loaded
        /// </return>
        ///         <short>    Loads the given DataEngine </short>
        public Plasma.DataEngine DataEngine(string name) {
            return (Plasma.DataEngine) interceptor.Invoke("dataEngine$", "dataEngine(const QString&) const", typeof(Plasma.DataEngine), typeof(string), name);
        }
        /// <remarks>
        /// </remarks>        <return> true if the wallpaper currently needs to be configured,
        ///          otherwise, false
        /// </return>
        ///         <short>   </short>
        public bool ConfigurationRequired() {
            return (bool) interceptor.Invoke("configurationRequired", "configurationRequired() const", typeof(bool));
        }
        /// <remarks>
        ///  Allows one to set rendering hints that may differ from the actualities of the
        ///  Wallpaper's current state, allowing for better selection of papers from packages,
        ///  for instance.
        ///  @arg resizeMethod The resize method to assume will be used for future wallpaper
        ///                    scaling; may later be changed by calls to render()
        /// </remarks>        <short>    Allows one to set rendering hints that may differ from the actualities of the  Wallpaper's current state, allowing for better selection of papers from packages,  for instance.</short>
        public void SetResizeMethodHint(Plasma.Wallpaper.ResizeMethod resizeMethod) {
            interceptor.Invoke("setResizeMethodHint$", "setResizeMethodHint(Plasma::Wallpaper::ResizeMethod)", typeof(void), typeof(Plasma.Wallpaper.ResizeMethod), resizeMethod);
        }
        /// <remarks>
        ///  Allows one to set rendering hints that may differ from the actualities of the
        ///  Wallpaper's current state, allowing for better selection of papers from packages,
        ///  for instance.
        ///  @arg targetSize The size to assume will be used for future wallpaper scaling
        /// </remarks>        <short>    Allows one to set rendering hints that may differ from the actualities of the  Wallpaper's current state, allowing for better selection of papers from packages,  for instance.</short>
        public void SetTargetSizeHint(QSizeF targetSize) {
            interceptor.Invoke("setTargetSizeHint#", "setTargetSizeHint(const QSizeF&)", typeof(void), typeof(QSizeF), targetSize);
        }
        /// <remarks>
        ///  Returns a list of wallpaper contextual actions (nothing by default)
        ///          </remarks>        <short>    Returns a list of wallpaper contextual actions (nothing by default)          </short>
        public List<QAction> ContextualActions() {
            return (List<QAction>) interceptor.Invoke("contextualActions", "contextualActions() const", typeof(List<QAction>));
        }
        /// <remarks>
        ///  This constructor is to be used with the plugin loading systems
        ///  found in KPluginInfo and KService. The argument list is expected
        ///  to have one element: the KService service ID for the desktop entry.
        /// <param> name="parent" a QObject parent; you probably want to pass in 0
        /// </param><param> name="args" a list of strings containing one entry: the service id
        ///          </param></remarks>        <short>    This constructor is to be used with the plugin loading systems  found in KPluginInfo and KService.</short>
        public Wallpaper(QObject parent, List<QVariant> args) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Wallpaper#?", "Wallpaper(QObject*, const QList<QVariant>&)", typeof(void), typeof(QObject), parent, typeof(List<QVariant>), args);
        }
        /// <remarks>
        ///  This method is called once the wallpaper is loaded or mode is changed.
        ///  The mode can be retrieved using the renderingMode() method.
        /// <param> name="config" Config group to load settings
        /// </param></remarks>        <short>    This method is called once the wallpaper is loaded or mode is changed.</short>
        [SmokeMethod("init(const KConfigGroup&)")]
        protected virtual void Init(KConfigGroup config) {
            interceptor.Invoke("init#", "init(const KConfigGroup&)", typeof(void), typeof(KConfigGroup), config);
        }
        /// <remarks>
        ///  When the wallpaper needs to be configured before being usable, this
        ///  method can be called to denote that action is required
        /// <param> name="needsConfiguring" true if the applet needs to be configured,
        ///                          or false if it doesn't
        /// </param><param> name="reason" a translated message for the user explaining that the
        ///                applet needs configuring; this should note what needs
        ///                to be configured
        /// </param></remarks>        <short>    When the wallpaper needs to be configured before being usable, this  method can be called to denote that action is required </short>
        protected void SetConfigurationRequired(bool needsConfiguring, string reason) {
            interceptor.Invoke("setConfigurationRequired$$", "setConfigurationRequired(bool, const QString&)", typeof(void), typeof(bool), needsConfiguring, typeof(string), reason);
        }
        protected void SetConfigurationRequired(bool needsConfiguring) {
            interceptor.Invoke("setConfigurationRequired$", "setConfigurationRequired(bool)", typeof(void), typeof(bool), needsConfiguring);
        }
        /// <remarks>
        ///  Renders the wallpaper asyncronously with the given parameters. When the rendering is
        ///  complete, the renderCompleted signal is emitted.
        /// <param> name="sourceImagePath" the path to the image file on disk. Common image formats such as
        ///                         PNG, JPEG and SVG are supported
        /// </param><param> name="size" the size to render the image as
        /// </param><param> name="resizeMethod" the method to use when resizing the image to fit size, @see
        ///                      ResizeMethod
        /// </param><param> name="color" the color to use to pad the rendered image if it doesn't take up the
        ///               entire size with the given ResizeMethod
        /// </param></remarks>        <short>    Renders the wallpaper asyncronously with the given parameters.</short>
        protected void Render(string sourceImagePath, QSize size, Plasma.Wallpaper.ResizeMethod resizeMethod, QColor color) {
            interceptor.Invoke("render$#$#", "render(const QString&, const QSize&, Plasma::Wallpaper::ResizeMethod, const QColor&)", typeof(void), typeof(string), sourceImagePath, typeof(QSize), size, typeof(Plasma.Wallpaper.ResizeMethod), resizeMethod, typeof(QColor), color);
        }
        protected void Render(string sourceImagePath, QSize size, Plasma.Wallpaper.ResizeMethod resizeMethod) {
            interceptor.Invoke("render$#$", "render(const QString&, const QSize&, Plasma::Wallpaper::ResizeMethod)", typeof(void), typeof(string), sourceImagePath, typeof(QSize), size, typeof(Plasma.Wallpaper.ResizeMethod), resizeMethod);
        }
        protected void Render(string sourceImagePath, QSize size) {
            interceptor.Invoke("render$#", "render(const QString&, const QSize&)", typeof(void), typeof(string), sourceImagePath, typeof(QSize), size);
        }
        /// <remarks>
        ///  Tries to load pixmap with the specified key from cache.
        /// <param> name="key" the name to use in the cache for this image
        /// </param><param> name="image" the image object to populate with the resulting data if found
        /// </param><param> name="lastModified" if non-zero, the time stamp is also checked on the file,
        ///                      and must be newer than the timestamp to be loaded
        /// </param></remarks>        <return> true when pixmap was found and loaded from cache, false otherwise
        /// </return>
        ///         <short>    Tries to load pixmap with the specified key from cache.</short>
        protected bool FindInCache(string key, QImage image, uint lastModified) {
            return (bool) interceptor.Invoke("findInCache$#$", "findInCache(const QString&, QImage&, unsigned int)", typeof(bool), typeof(string), key, typeof(QImage), image, typeof(uint), lastModified);
        }
        protected bool FindInCache(string key, QImage image) {
            return (bool) interceptor.Invoke("findInCache$#", "findInCache(const QString&, QImage&)", typeof(bool), typeof(string), key, typeof(QImage), image);
        }
        /// <remarks>
        ///  Insert specified pixmap into the cache if usingRenderingCache.
        ///  If the cache already contains pixmap with the specified key then it is
        ///  overwritten.
        /// <param> name="key" the name use in the cache for this image; if the image is specific
        ///             to this wallpaper plugin, consider including the name() as part of
        ///             the cache key to avoid collisions with other plugins.
        /// </param><param> name="image" the image to store in the cache; passing in a null image will cause
        ///               the cached image to be removed from the cache
        /// </param></remarks>        <short>    Insert specified pixmap into the cache if usingRenderingCache.</short>
        protected void InsertIntoCache(string key, QImage image) {
            interceptor.Invoke("insertIntoCache$#", "insertIntoCache(const QString&, const QImage&)", typeof(void), typeof(string), key, typeof(QImage), image);
        }
        /// <remarks>
        ///  Sets the contextual actions for this wallpaper.
        /// <param> name="actions" A list of contextual actions for this wallpaper
        /// </param></remarks>        <short>    Sets the contextual actions for this wallpaper.</short>
        protected void SetContextualActions(List<QAction> actions) {
            interceptor.Invoke("setContextualActions?", "setContextualActions(const QList<QAction*>&)", typeof(void), typeof(List<QAction>), actions);
        }
        /// <remarks>
        ///  Returns a list of all known wallpapers.
        ///  @arg formFactor the format of the wallpaper being search for (e.g. desktop)
        /// </remarks>        <return> list of wallpapers
        /// </return>
        ///         <short>    Returns a list of all known wallpapers.</short>
        public static List<KPluginInfo> ListWallpaperInfo(string formFactor) {
            return (List<KPluginInfo>) staticInterceptor.Invoke("listWallpaperInfo$", "listWallpaperInfo(const QString&)", typeof(List<KPluginInfo>), typeof(string), formFactor);
        }
        public static List<KPluginInfo> ListWallpaperInfo() {
            return (List<KPluginInfo>) staticInterceptor.Invoke("listWallpaperInfo", "listWallpaperInfo()", typeof(List<KPluginInfo>));
        }
        /// <remarks>
        ///  Returns a list of all known wallpapers that can accept the given mimetype
        ///  @arg mimetype the mimetype to search for
        ///  @arg formFactor the format of the wallpaper being search for (e.g. desktop)
        /// </remarks>        <return> list of wallpapers
        ///          </return>
        ///         <short>    Returns a list of all known wallpapers that can accept the given mimetype  @arg mimetype the mimetype to search for  @arg formFactor the format of the wallpaper being search for (e.</short>
        public static List<KPluginInfo> ListWallpaperInfoForMimetype(string mimetype, string formFactor) {
            return (List<KPluginInfo>) staticInterceptor.Invoke("listWallpaperInfoForMimetype$$", "listWallpaperInfoForMimetype(const QString&, const QString&)", typeof(List<KPluginInfo>), typeof(string), mimetype, typeof(string), formFactor);
        }
        public static List<KPluginInfo> ListWallpaperInfoForMimetype(string mimetype) {
            return (List<KPluginInfo>) staticInterceptor.Invoke("listWallpaperInfoForMimetype$", "listWallpaperInfoForMimetype(const QString&)", typeof(List<KPluginInfo>), typeof(string), mimetype);
        }
        /// <remarks>
        ///  Attempts to load a wallpaper
        ///  Returns a pointer to the wallpaper if successful.
        ///  The caller takes responsibility for the wallpaper, including
        ///  deleting it when no longer needed.
        /// <param> name="name" the plugin name, as returned by KPluginInfo.PluginName()
        /// </param><param> name="args" to send the wallpaper extra arguments
        /// </param></remarks>        <return> a pointer to the loaded wallpaper, or 0 on load failure
        /// </return>
        ///         <short>    Attempts to load a wallpaper </short>
        public static Plasma.Wallpaper Load(string name, List<QVariant> args) {
            return (Plasma.Wallpaper) staticInterceptor.Invoke("load$?", "load(const QString&, const QList<QVariant>&)", typeof(Plasma.Wallpaper), typeof(string), name, typeof(List<QVariant>), args);
        }
        public static Plasma.Wallpaper Load(string name) {
            return (Plasma.Wallpaper) staticInterceptor.Invoke("load$", "load(const QString&)", typeof(Plasma.Wallpaper), typeof(string), name);
        }
        /// <remarks>
        ///  Attempts to load a wallpaper
        ///  Returns a pointer to the wallpaper if successful.
        ///  The caller takes responsibility for the wallpaper, including
        ///  deleting it when no longer needed.
        /// <param> name="info" KPluginInfo object for the desired wallpaper
        /// </param><param> name="args" to send the wallpaper extra arguments
        /// </param></remarks>        <return> a pointer to the loaded wallpaper, or 0 on load failure
        /// </return>
        ///         <short>    Attempts to load a wallpaper </short>
        public static Plasma.Wallpaper Load(KPluginInfo info, List<QVariant> args) {
            return (Plasma.Wallpaper) staticInterceptor.Invoke("load#?", "load(const KPluginInfo&, const QList<QVariant>&)", typeof(Plasma.Wallpaper), typeof(KPluginInfo), info, typeof(List<QVariant>), args);
        }
        public static Plasma.Wallpaper Load(KPluginInfo info) {
            return (Plasma.Wallpaper) staticInterceptor.Invoke("load#", "load(const KPluginInfo&)", typeof(Plasma.Wallpaper), typeof(KPluginInfo), info);
        }
        /// <remarks>
        ///  Returns the Package specialization for wallpapers. May be queried for 'preferred'
        ///  which will return the preferred wallpaper image path given the associated Wallpaper
        ///  object, if any.
        /// <param> name="paper" the Wallpaper object to associated the PackageStructure with,
        ///               which will then use the Wallpaper object to define things such as
        ///               default size and resize methods.
        ///          </param></remarks>        <short>    Returns the Package specialization for wallpapers.</short>
        public static Plasma.PackageStructure PackageStructure(Plasma.Wallpaper paper) {
            return (Plasma.PackageStructure) staticInterceptor.Invoke("packageStructure#", "packageStructure(Plasma::Wallpaper*)", typeof(Plasma.PackageStructure), typeof(Plasma.Wallpaper), paper);
        }
        public static Plasma.PackageStructure PackageStructure() {
            return (Plasma.PackageStructure) staticInterceptor.Invoke("packageStructure", "packageStructure()", typeof(Plasma.PackageStructure));
        }
        protected new IWallpaperSignals Emit {
            get { return (IWallpaperSignals) Q_EMIT; }
        }
    }

    public interface IWallpaperSignals : IQObjectSignals {
        /// <remarks>
        ///  This signal indicates that wallpaper needs to be repainted.
        ///          </remarks>        <short>    This signal indicates that wallpaper needs to be repainted.</short>
        [Q_SIGNAL("void update(QRectF)")]
        void Update(QRectF exposedArea);
        /// <remarks>
        ///  Emitted when the user wants to configure/change the wallpaper.
        /// </remarks>        <short>    Emitted when the user wants to configure/change the wallpaper.</short>
        [Q_SIGNAL("void configureRequested()")]
        void ConfigureRequested();
        /// <remarks>
        ///  Emitted when the state of the wallpaper requiring configuration
        ///  changes.
        /// </remarks>        <short>    Emitted when the state of the wallpaper requiring configuration  changes.</short>
        [Q_SIGNAL("void configurationRequired(bool)")]
        void ConfigurationRequired(bool needsConfig);
        /// <remarks>
        ///  Emitted when the configuration of the wallpaper needs to be saved
        ///  to disk.
        /// </remarks>        <short>    Emitted when the configuration of the wallpaper needs to be saved  to disk.</short>
        [Q_SIGNAL("void configNeedsSaving()")]
        void ConfigNeedsSaving();
        /// <remarks>
        ///  Emitted when a wallpaper image render is completed.
        /// </remarks>        <short>    Emitted when a wallpaper image render is completed.</short>
        [Q_SIGNAL("void renderCompleted(QImage)")]
        void RenderCompleted(QImage image);
        /// <remarks>
        ///  Emitted when a URL matching X-Plasma-DropMimeTypes is dropped on the wallpaper
        ///  @arg url the URL of the dropped file
        /// </remarks>        <short>    Emitted when a URL matching X-Plasma-DropMimeTypes is dropped on the wallpaper </short>
        [Q_SIGNAL("void urlDropped(KUrl)")]
        void UrlDropped(KUrl url);
        /// <remarks>
        ///          </remarks>        <short>   </short>
        [Q_SIGNAL("void renderHintsChanged()")]
        void RenderHintsChanged();
    }
}
