//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    using System.Runtime.InteropServices;
    using System.Text;
    /// <remarks>
    ///  @brief A generic implementation of the "replace" function.
    ///  <b></b>etail:
    ///  This class includes prompt handling etc. Also provides some
    ///  static functions which can be used to create custom behavior
    ///  instead of using the class directly.
    ///  <b></b>xample:
    ///  To use the class to implement a complete replace feature:
    ///  In the slot connect to the replace action, after using KReplaceDialog:
    ///  <pre>
    ///   // This creates a replace-on-prompt dialog if needed.
    ///   m_replace = new KReplace(pattern, replacement, options, this);
    ///   // Connect signals to code which handles highlighting
    ///   // of found text, and on-the-fly replacement.
    ///   connect( m_replace, SIGNAL("highlight( string, int, int )"),
    ///           this, SLOT("slotHighlight( string, int, int )") );
    ///   // Connect findNext signal - called when pressing the button in the dialog
    ///   connect( m_replace, SIGNAL("findNext()"),
    ///           this, SLOT("slotReplaceNext()") );
    ///   // Connect replace signal - called when doing a replacement
    ///   connect( m_replace, SIGNAL("replace(string, int, int, int)"),
    ///           this, SLOT("slotReplace(string, int, int, int)") );
    ///  </pre>
    ///   Then initialize the variables determining the "current position"
    ///   (to the cursor, if the option FromCursor is set,
    ///    to the beginning of the selection if the option SelectedText is set,
    ///    and to the beginning of the document otherwise).
    ///   Initialize the "end of search" variables as well (end of doc or end of selection).
    ///   Swap begin and end if FindBackwards.
    ///   Finally, call slotReplaceNext();
    ///  <pre>
    ///   void slotReplaceNext()
    ///   {
    ///       KFind.Result res = KFind.NoMatch;
    ///       while ( res == KFind.NoMatch && <position not at end> ) {
    ///           if ( m_replace.NeedData() )
    ///               m_replace.SetData( <current text fragment> );
    ///           // Let KReplace inspect the text fragment, and display a dialog if a match is found
    ///           res = m_replace.Replace();
    ///           if ( res == KFind.NoMatch ) {
    ///               <Move to the next text fragment, honoring the FindBackwards setting for the direction>
    ///           }
    ///       }
    ///       if ( res == KFind.NoMatch ) // i.e. at end
    ///           <Call either  m_replace.DisplayFinalDialog(); delete m_replace; m_replace = null;
    ///            or           if ( m_replace.ShouldRestart() ) { reinit (w/o FromCursor) and call slotReplaceNext(); }
    ///                         else { m_replace.CloseReplaceNextDialog(); }>
    ///   }
    ///  </pre>
    ///   Don't forget delete m_find in the destructor of your class,
    ///   unless you gave it a parent widget on construction.
    ///   See <see cref="IKReplaceSignals"></see> for signals emitted by KReplace
    /// </remarks>        <author> S.R.Haque <srhaque@iee.org>, David Faure <faure@kde.org>
    /// </author>
    ///         <short>    @brief A generic implementation of the "replace" function.</short>
    [SmokeClass("KReplace")]
    public class KReplace : KFind, IDisposable {
        protected KReplace(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KReplace), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static KReplace() {
            staticInterceptor = new SmokeInvocation(typeof(KReplace), null);
        }
        /// <remarks>
        ///  Only use this constructor if you don't use KFindDialog, or if
        ///  you use it as a modal dialog.
        ///      </remarks>        <short>    Only use this constructor if you don't use KFindDialog, or if  you use it as a modal dialog.</short>
        public KReplace(string pattern, string replacement, long options, QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KReplace$$$#", "KReplace(const QString&, const QString&, long, QWidget*)", typeof(void), typeof(string), pattern, typeof(string), replacement, typeof(long), options, typeof(QWidget), parent);
        }
        public KReplace(string pattern, string replacement, long options) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KReplace$$$", "KReplace(const QString&, const QString&, long)", typeof(void), typeof(string), pattern, typeof(string), replacement, typeof(long), options);
        }
        /// <remarks>
        ///  This is the recommended constructor if you also use KReplaceDialog (non-modal).
        ///  You should pass the pointer to it here, so that when a message box
        ///  appears it has the right parent. Don't worry about deletion, KReplace
        ///  will notice if the find dialog is closed.
        ///      </remarks>        <short>    This is the recommended constructor if you also use KReplaceDialog (non-modal).</short>
        public KReplace(string pattern, string replacement, long options, QWidget parent, QWidget replaceDialog) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KReplace$$$##", "KReplace(const QString&, const QString&, long, QWidget*, QWidget*)", typeof(void), typeof(string), pattern, typeof(string), replacement, typeof(long), options, typeof(QWidget), parent, typeof(QWidget), replaceDialog);
        }
        /// <remarks>
        ///  Return the number of replacements made (i.e. the number of times
        ///  the replace signal was emitted).
        ///  Can be used in a dialog box to tell the user how many replacements were made.
        ///  The final dialog does so already, unless you used setDisplayFinalDialog(false).
        ///      </remarks>        <short>    Return the number of replacements made (i.</short>
        public int NumReplacements() {
            return (int) interceptor.Invoke("numReplacements", "numReplacements() const", typeof(int));
        }
        /// <remarks>
        ///  Call this to reset the numMatches & numReplacements counts.
        ///  Can be useful if reusing the same KReplace for different operations,
        ///  or when restarting from the beginning of the document.
        ///      </remarks>        <short>    Call this to reset the numMatches & numReplacements counts.</short>
        [SmokeMethod("resetCounts()")]
        public override void ResetCounts() {
            interceptor.Invoke("resetCounts", "resetCounts()", typeof(void));
        }
        /// <remarks>
        ///  Walk the text fragment (e.g. kwrite line, kspread cell) looking for matches.
        ///  For each match, if prompt-on-replace is specified, emits the highlight() signal
        ///  and displays the prompt-for-replace dialog before doing the replace.
        ///      </remarks>        <short>    Walk the text fragment (e.</short>
        public KFind.Result Replace() {
            return (KFind.Result) interceptor.Invoke("replace", "replace()", typeof(KFind.Result));
        }
        /// <remarks>
        ///  Return (or create) the dialog that shows the "find next?" prompt.
        ///  Usually you don't need to call this.
        ///  One case where it can be useful, is when the user selects the "Find"
        ///  menu item while a find operation is under way. In that case, the
        ///  program may want to call setActiveWindow() on that dialog.
        ///      </remarks>        <short>    Return (or create) the dialog that shows the "find next?" prompt.</short>
        public KDialog ReplaceNextDialog(bool create) {
            return (KDialog) interceptor.Invoke("replaceNextDialog$", "replaceNextDialog(bool)", typeof(KDialog), typeof(bool), create);
        }
        public KDialog ReplaceNextDialog() {
            return (KDialog) interceptor.Invoke("replaceNextDialog", "replaceNextDialog()", typeof(KDialog));
        }
        /// <remarks>
        ///  Close the "replace next?" dialog. The application should do this when
        ///  the last match was hit. If the application deletes the KReplace, then
        ///  "find previous" won't be possible anymore.
        ///      </remarks>        <short>    Close the "replace next?" dialog.</short>
        public void CloseReplaceNextDialog() {
            interceptor.Invoke("closeReplaceNextDialog", "closeReplaceNextDialog()", typeof(void));
        }
        /// <remarks>
        ///  Returns true if we should restart the search from scratch.
        ///  Can ask the user, or return false (if we already searched/replaced the
        ///  whole document without the PromptOnReplace option).
        /// <param> name="forceAsking" set to true if the user modified the document during the
        ///  search. In that case it makes sense to restart the search again.
        /// </param><param> name="showNumMatches" set to true if the dialog should show the number of
        ///  matches. Set to false if the application provides a "find previous" action,
        ///  in which case the match count will be erroneous when hitting the end,
        ///  and we could even be hitting the beginning of the document (so not all
        ///  matches have even been seen).
        ///      </param></remarks>        <short>    Returns true if we should restart the search from scratch.</short>
        [SmokeMethod("shouldRestart(bool, bool) const")]
        public override bool ShouldRestart(bool forceAsking, bool showNumMatches) {
            return (bool) interceptor.Invoke("shouldRestart$$", "shouldRestart(bool, bool) const", typeof(bool), typeof(bool), forceAsking, typeof(bool), showNumMatches);
        }
        [SmokeMethod("shouldRestart(bool) const")]
        public override bool ShouldRestart(bool forceAsking) {
            return (bool) interceptor.Invoke("shouldRestart$", "shouldRestart(bool) const", typeof(bool), typeof(bool), forceAsking);
        }
        [SmokeMethod("shouldRestart() const")]
        public override bool ShouldRestart() {
            return (bool) interceptor.Invoke("shouldRestart", "shouldRestart() const", typeof(bool));
        }
        /// <remarks>
        ///  Displays the final dialog telling the user how many replacements were made.
        ///  Call either this or shouldRestart().
        ///      </remarks>        <short>    Displays the final dialog telling the user how many replacements were made.</short>
        [SmokeMethod("displayFinalDialog() const")]
        public override void DisplayFinalDialog() {
            interceptor.Invoke("displayFinalDialog", "displayFinalDialog() const", typeof(void));
        }
        ~KReplace() {
            interceptor.Invoke("~KReplace", "~KReplace()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~KReplace", "~KReplace()", typeof(void));
        }
        /// <remarks>
        ///  Search the given string, replaces with the given replacement string,
        ///  and returns whether a match was found. If one is,
        ///  the replacement string length is also returned.
        ///  A performance optimised version of the function is provided for use
        ///  with regular expressions.
        /// <param> name="text" The string to search.
        /// </param><param> name="pattern" The pattern to look for.
        /// </param><param> name="replacement" The replacement string to insert into the text.
        /// </param><param> name="index" The starting index into the string.
        /// </param><param> name="options" The options to use.
        /// </param><param> name="replacedLength" Output parameter, contains the length of the replaced string.
        ///  Not always the same as replacement.length(), when backreferences are used.
        /// </param></remarks>        <return> The index at which a match was found, or -1 if no match was found.
        ///      </return>
        ///         <short>    Search the given string, replaces with the given replacement string,  and returns whether a match was found.</short>
        public static int Replace(StringBuilder text, string pattern, string replacement, int index, long options, ref int replacedLength) {
            StackItem[] stack = new StackItem[7];
#if DEBUG
            stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(text);
#else
            stack[1].s_class = (IntPtr) GCHandle.Alloc(text);
#endif
#if DEBUG
            stack[2].s_class = (IntPtr) DebugGCHandle.Alloc(pattern);
#else
            stack[2].s_class = (IntPtr) GCHandle.Alloc(pattern);
#endif
#if DEBUG
            stack[3].s_class = (IntPtr) DebugGCHandle.Alloc(replacement);
#else
            stack[3].s_class = (IntPtr) GCHandle.Alloc(replacement);
#endif
            stack[4].s_int = index;
            stack[5].s_long = options;
            stack[6].s_int = replacedLength;
            staticInterceptor.Invoke("replace$$$$$$", "replace(QString&, const QString&, const QString&, int, long, int*)", stack);
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
            ((GCHandle) stack[1].s_class).Free();
#endif
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[2].s_class);
#else
            ((GCHandle) stack[2].s_class).Free();
#endif
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[3].s_class);
#else
            ((GCHandle) stack[3].s_class).Free();
#endif
            replacedLength = stack[6].s_int;
            return stack[0].s_int;
        }
        public static int Replace(StringBuilder text, QRegExp pattern, string replacement, int index, long options, ref int replacedLength) {
            StackItem[] stack = new StackItem[7];
#if DEBUG
            stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(text);
#else
            stack[1].s_class = (IntPtr) GCHandle.Alloc(text);
#endif
#if DEBUG
            stack[2].s_class = (IntPtr) DebugGCHandle.Alloc(pattern);
#else
            stack[2].s_class = (IntPtr) GCHandle.Alloc(pattern);
#endif
#if DEBUG
            stack[3].s_class = (IntPtr) DebugGCHandle.Alloc(replacement);
#else
            stack[3].s_class = (IntPtr) GCHandle.Alloc(replacement);
#endif
            stack[4].s_int = index;
            stack[5].s_long = options;
            stack[6].s_int = replacedLength;
            staticInterceptor.Invoke("replace$#$$$$", "replace(QString&, const QRegExp&, const QString&, int, long, int*)", stack);
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
            ((GCHandle) stack[1].s_class).Free();
#endif
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[2].s_class);
#else
            ((GCHandle) stack[2].s_class).Free();
#endif
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[3].s_class);
#else
            ((GCHandle) stack[3].s_class).Free();
#endif
            replacedLength = stack[6].s_int;
            return stack[0].s_int;
        }
        protected new IKReplaceSignals Emit {
            get { return (IKReplaceSignals) Q_EMIT; }
        }
    }

    public interface IKReplaceSignals : IKFindSignals {
        /// <remarks>
        ///  Connect to this slot to implement updating of replaced text during the replace
        ///  operation.
        ///  Extra care must be taken to properly implement the "no prompt-on-replace" case.
        ///  For instance highlight isn't emitted in that case (some code might rely on it),
        ///  and for performance reasons one should repaint after replace() ONLY if
        ///  prompt-on-replace was selected.
        /// <param> name="text" The text, in which the replacement has already been done.
        /// </param><param> name="replacementIndex" Starting index of the matched substring
        /// </param><param> name="replacedLength" Length of the replacement string
        /// </param><param> name="matchedLength" Length of the matched string
        ///      </param></remarks>        <short>    Connect to this slot to implement updating of replaced text during the replace  operation.</short>
        [Q_SIGNAL("void replace(QString, int, int, int)")]
        void Replace(string text, int replacementIndex, int replacedLength, int matchedLength);
    }
}
