# find opentts library and header if available
# Copyright (c) 2009, Jeremy Whiting <jeremy@scitools.com>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.

FIND_PATH(OPENTTS_INCLUDE_DIR opentts/libopentts.h /usr/include /usr/local/include)

FIND_LIBRARY(OPENTTS_LIBRARY NAMES opentts PATH /usr/lib /usr/local/lib)

IF (OPENTTS_INCLUDE_DIR AND OPENTTS_LIBRARY)
    SET(OPENTTS_FOUND TRUE)
ENDIF (OPENTTS_INCLUDE_DIR AND OPENTTS_LIBRARY)

IF (OPENTTS_FOUND)
  IF (NOT Opentts_FIND_QUIETLY)
    MESSAGE(STATUS "Found OpenTTS: ${OPENTTS_LIBRARY}")
  ENDIF (NOT Opentts_FIND_QUIETLY)
ELSE (OPENTTS_FOUND)
  IF (Opentts_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "Could not find Required package: Opentts")
  ENDIF (Opentts_FIND_REQUIRED)
ENDIF (OPENTTS_FOUND)

