/*
 * This file is part of LibKGAPI library
 *
 * Copyright (C) 2013  Daniel Vrátil <dvratil@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) version 3, or any
 * later version accepted by the membership of KDE e.V. (or its
 * successor approved by the membership of KDE e.V.), which shall
 * act as a proxy defined in Section 6 of version 3 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef KGAPI2_DRIVE_FILEFETCHCONTENTJOB_H
#define KGAPI2_DRIVE_FILEFETCHCONTENTJOB_H

#include "fetchjob.h"
#include "kgapidrive_export.h"

namespace KGAPI2
{
namespace Drive
{

class KGAPIDRIVE_EXPORT FileFetchContentJob : public KGAPI2::FetchJob
{
    Q_OBJECT

  public:
    explicit FileFetchContentJob(const FilePtr &file, const AccountPtr &account,
                                 QObject *parent = nullptr);
    explicit FileFetchContentJob(const QUrl &url, const AccountPtr &account,
                                 QObject *parent = nullptr);
    virtual ~FileFetchContentJob();

    QByteArray data() const;

  protected:
    void start() override;
    void handleReply(const QNetworkReply *reply, const QByteArray &rawData) override;
    void dispatchRequest(QNetworkAccessManager *accessManager,
                                 const QNetworkRequest &request,
                                 const QByteArray &data,
                                 const QString &contentType) override;

    KGAPI2::ObjectsList handleReplyWithItems(const QNetworkReply *reply,
                                                     const QByteArray &rawData) override;

  private:
    class Private;
    Private * const d;
    friend class Private;

    Q_PRIVATE_SLOT(d, void _k_downloadProgress(qint64 downloaded, qint64 total))
};

} // namespace Drive

} // namespace KGAPI2

#endif // KGAPI2_DRIVE_FILEFETCHCONTENTJOB_H
