/***************************************************************************
                          page4.cpp  -  KInstall's Wizard 4th Page
                             -------------------                                         
    begin                : Sat Apr 10 1999                                           
    copyright            : (C) 1999 by Hugo Santos                         
    email                : hugo_santos@bigfoot.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "page4.h"

Page4::Page4(_KInstall *parent, const char *name ) : _Page(parent,name) {
	ki->setTitle(TITL_4);
	ki->setTitleFont("Helvetica",24,QFont::Bold,true);
	if (ki->inst.type!=2){
	p_conf = new QLabel("Conf",this);
	p_conf->setAlignment( AlignCenter );}
	else p_conf=0;
	p_make = new QLabel("Make",this);
	p_make->setAlignment( AlignCenter );
	p_inst = new QLabel("Inst",this);
	p_inst->setAlignment( AlignCenter );
	p_plwa = new QLabel(MSG_11,this);	
	p_plwa->setAlignment( AlignCenter );
	p_out = new QLineEdit(this);
	//ki->setButtonNext(BTN_START); These two sometimes result in a segfault...
	//ki->setButtonBack(BTN_ABORT); So i replace them to these two:
	ki->getButtonNext()->setText(BTN_START);
	ki->getButtonBack()->setText(BTN_ABORT);
	ki->setButtonBackEnabled( false );
	editedMakefile=false;
	alreadyErrShown=false;
	foundErrOrNotFound=false;
	connect(ki,SIGNAL(nextclicked()),this,SLOT(slotBeginAll()));
	connect(ki,SIGNAL(backclicked()),this,SLOT(slotAbortAll()));
	connect(this,SIGNAL(finishedAll()),SLOT(slotFinished()));
}
Page4::~Page4(){
}

void Page4::slotFinished(){
	disconnect(ki, SIGNAL(nextclicked()), this, SLOT(slotBeginAll()));
	disconnect(ki, SIGNAL(backclicked()), this, SLOT(slotAbortAll()));
	emit finished();
}
void Page4::slotAbortAll(){
	mb->message(this,"KInstall",ERR_06,4,BTN_OK);
	if (q)
	q->kill();
	ki->slotClean();
	kapp->quit();
}

void Page4::slotBeginAll(){
	ki->setButtonBackEnabled( true );
	ki->setButtonNextEnabled( false);
	ki->setButtonCancelEnabled( false );
	if (ki->inst.type==1)
		slotBeginCVSDist();
	else if (ki->inst.type==3)
		slotBeginCVSDist();
	else if (ki->inst.type==4)
		slotBeginConf();
	else if (ki->inst.type==2)
		slotBeginMake();
}

void Page4::slotBeginCVSDist(){
	q = new KShellProcess;QDir d;QString a;
	d.cd("/tmp/ki_temp");
	d.cd(ki->inst.inside_tempdir);
	a.sprintf("cd %s&&make -f ",d.path());
	if (ki->inst.type==1)
			a.append("Makefile.cvs");
	else if(ki->inst.type==3)
			a.append("Makefile.dist");
	connect(q,SIGNAL(processExited(KProcess *)),this,SLOT(slotEndedCVSDist()));
	connect(q,SIGNAL(receivedStdout(KProcess *,char *, int)),this,SLOT(slotErrorFound(KProcess *,char *, int)));
	connect(q,SIGNAL(receivedStderr(KProcess *,char *, int)),this,SLOT(slotErrorFound(KProcess *,char *, int)));
	*q << a;
	if (q->start(KProcess::NotifyOnExit,KProcess::AllOutput))
		p_plwa->setText(MSG_26);
}

void Page4::slotBeginConf(){
	if (!foundErrOrNotFound){
	q = new KShellProcess;QDir d;QString a;
	QString t(kapp->kde_bindir());
	t.remove(strlen(t)-3,strlen(t));
	d.cd("/tmp/ki_temp");
	d.cd(ki->inst.inside_tempdir);
	a.sprintf("cd %s&&./configure",d.path());
	if (ki->inst.wheretoinstall!=0&&ki->inst.wheretoinstall!=t)
		a.append(" --prefix="+ki->inst.wheretoinstall);
	connect(q,SIGNAL(processExited(KProcess *)),this,SLOT(slotEndedConf()));
	connect(q,SIGNAL(receivedStdout(KProcess *,char *, int)),this,SLOT(slotErrorFound(KProcess *,char *, int)));
	connect(q,SIGNAL(receivedStderr(KProcess *,char *, int)),this,SLOT(slotErrorFound(KProcess *,char *, int)));
	*q << a;
	if (q->start(KProcess::NotifyOnExit,KProcess::AllOutput)){
		p_plwa->setText(MSG_12);editedMakefile=true;}}
}
void Page4::slotBeginMake(){
	if (!foundErrOrNotFound){
	if (ki->inst.type==2&&!editedMakefile)
		slotEditMakefile();
	q = new KShellProcess;
	QString wtw;
	wtw="cd /tmp/ki_temp;";
	if (ki->inst.inside_tempdir!=0)
		wtw.append("cd "+ki->inst.inside_tempdir+";");
	wtw.append("make all;");
	connect(q,SIGNAL(processExited(KProcess *)),this,SLOT(slotEndedMake()));
	connect(q,SIGNAL(receivedStdout(KProcess *,char *, int)),this,SLOT(slotErrorFound(KProcess *,char *, int)));
	connect(q,SIGNAL(receivedStderr(KProcess *,char *, int)),this,SLOT(slotErrorFound(KProcess *,char *, int)));
	*q << wtw;
	if (q->start(KProcess::NotifyOnExit,KProcess::AllOutput))
		p_plwa->setText(MSG_13);}
}

void Page4::slotEditMakefile()
{		
	KMsgBox *mb;
	if(mb->yesNo(this,"KInstall",MSG_28,8,BTN_YES,BTN_NO)==1)
	{
		QString t;
		t="/tmp/ki_temp";
		if (ki->inst.inside_tempdir!=0)
		t.append("/"+ki->inst.inside_tempdir);
		ed = new MEdit(ki);
		ed->setGeometry(100,100,400,300);
		ed->setCaption("KInstall: MEdit");
		ed->loadM(t+"/Makefile");
		ed->show();
	}
	else {editedMakefile=true;slotBeginMake();}
}
void Page4::slotBeginInst(){
	if (!foundErrOrNotFound){
	q = new KShellProcess;
	QString wtw;
	wtw="cd /tmp/ki_temp;";
	if (ki->inst.inside_tempdir!=0)
		wtw.append("cd "+ki->inst.inside_tempdir+";");
	wtw.append("make install;");
	connect(q,SIGNAL(processExited(KProcess *)),this,SLOT(slotEndedInst()));
	connect(q,SIGNAL(receivedStdout(KProcess *,char *, int)),this,SLOT(slotErrorFound(KProcess *,char *, int)));
	connect(q,SIGNAL(receivedStderr(KProcess *,char *, int)),this,SLOT(slotErrorFound(KProcess *,char *, int)));
	*q << wtw;
	if (q->start(KProcess::NotifyOnExit,KProcess::AllOutput))
		p_plwa->setText(MSG_14);}
}
void Page4::slotShowMeErrorReport(){
	if (!alreadyErrShown){
	q->kill();
	QString err;
	err.sprintf("%s\n%s",MSG_27,(const char *)lastError);
	mb->message(this,"KInstall",err,2,BTN_OK);
	kapp->quit();alreadyErrShown=true;}
}
void Page4::resizeEvent( QResizeEvent * ){
	if (p_conf!=0){
		p_conf->setGeometry(0,5,(int)width()*0.33,30);
		p_make->setGeometry((int)width()*0.33,5,(int)width()*0.33,30);
		p_inst->setGeometry((int)width()*0.66,5,(int)width()*0.33,30);}
	else {
		p_make->setGeometry(0,5,(int)width()*0.5,30);
		p_inst->setGeometry((int)width()*0.5,5,(int)width()*0.5,30);}
	p_plwa->setGeometry(0,50,width(),70);
	p_out->setGeometry(10,130,width()-10,30);
}

void Page4::slotEndedCVSDist(){
	if (foundErrOrNotFound)
		slotShowMeErrorReport();
	else slotBeginConf();
}

void Page4::slotEndedConf(){
	if (foundErrOrNotFound)
		slotShowMeErrorReport();
	else {
		p_conf->setText("Conf - Done");slotBeginMake();}
}
void Page4::slotEndedMake(){
	if (foundErrOrNotFound)
		slotShowMeErrorReport();
	else {
		p_make->setText("Make - Done");slotBeginInst();}
}
void Page4::slotEndedInst(){
	if (foundErrOrNotFound)
		slotShowMeErrorReport();
	else {
		p_inst->setText("Install - Done");emit finished();}
}

void Page4::slotErrorFound( KProcess *,char *buffer, int buflen ){
	QString s(buffer,buflen+1);
	if (s.find("error",0,false)!=-1||s.find("not found",0,false)!=-1){
		foundErrOrNotFound=true;
		lastError=s;}
	p_out->setText(s);
}
