/***************************************************************************
                          kh_gl5xx_profile.cpp  -  description                              
                             -------------------                                         
    begin                : Sat Oct 30 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


extern "C" {
#include <stdlib.h>
}
#include "kh_gl5xx_profile.h"


KH_GL5XX_Profile::KH_GL5XX_Profile( sensors_chip_name chipname ) : KHFeatureProfile( chipname ) {
}

KH_GL5XX_Profile::~KH_GL5XX_Profile(){
}

SensorId * KH_GL5XX_Profile::storeFeature( sensors_feature_data feature ){
  static SensorId sid;
	char *buffer = 0;
	ChipType chiptype;

	// if the entry is valid ( valid label exists ), do the job

	if ( !sensors_get_label( chipname, feature.number, &buffer ) ){
		debug( "%i\t%s", feature.number, buffer );
		if ( QString( buffer ) == "fan1" ) sid = Fan1; else
		if ( QString( buffer ) == "fan2" ) sid = Fan2; else
		if ( ( QString( buffer ) == "temp1" ) || ( QString( buffer ) == "temp" ) ) sid = Temp1; else
		if ( QString( buffer ) == "temp2" ) sid = Temp2;
		if ( QString( buffer ) == "VCore 1" ) sid = VCore; else
		if ( QString( buffer ) == "VCore 2" ) sid = VCore2; else
		if ( QString( buffer ) == "+3.3V" ) sid = V33; else
		if ( QString( buffer ) == "+5V" ) sid = V5;	else
		if ( QString( buffer ) == "-5V" ) sid = Vm5;	else	
		if ( QString( buffer ) == "+12V" ) sid = V12; else
		if ( QString( buffer ) == "-12V" ) sid = Vm12; else
		if ( QString( buffer ) == "beeps" ) sid = BeepControl; else
		if ( QString( buffer ) == "beep_enable" ) sid = GlobalBeep; else
		if ( QString( buffer ) == "vid" ) sid = VID;
    else {
			free( buffer );
			return 0;
		}
  	profile[sid].number = feature.number;
		profile[sid].enabled = true;
		if ( ( sid >= Fan1 ) && ( sid <= VID ) ) count++;

		// correlate the feature with its alarm binding

		if( ( QString( chipname.prefix ) == "gl518sm" ) ||
			 	( QString( chipname.prefix ) == "gl520sm" ) )
					chiptype = gl5xx;
		else {
			debug ( "Couldn't determine chip type, aborting !" );
			return 0;
		}
					
		if ( QString( feature.name ) == "vin1" ) profile[sid].alarm = alarmBindings[chiptype][in1]; else
		if ( QString( feature.name ) == "vin2" ) profile[sid].alarm = alarmBindings[chiptype][in2]; else
		if ( QString( feature.name ) == "vin3" ) profile[sid].alarm = alarmBindings[chiptype][in3]; else
		if ( QString( feature.name ) == "vin4" ) profile[sid].alarm = alarmBindings[chiptype][in4]; else
		if ( QString( feature.name ) == "fan1" ) profile[sid].alarm = alarmBindings[chiptype][fan1]; else
		if ( QString( feature.name ) == "fan2" ) profile[sid].alarm = alarmBindings[chiptype][fan2]; else
		if ( ( QString( feature.name ) == "temp" ) || ( QString( feature.name ) == "temp1" ) ) profile[sid].alarm = alarmBindings[chiptype][temp1]; else
		if ( QString( feature.name ) == "temp2" ) profile[sid].alarm = alarmBindings[chiptype][temp2]; else
		debug( "KHFeatureProfile: couldn't determine alarm binding %s, skipping", feature.name );
	
		debug( "alarm: %i", profile[sid].alarm );

		free( buffer );
		return &sid;
	}
	return 0;
}



