/***************************************************************************
                          khconfigdlg.cpp  -  description                              
                             -------------------                                         
    begin                : Sun Aug 8 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "khtab1.h"
#include "khtab2.h"
#include "khtab3.h"
#include "khglobals.h"
#include "khchip.h"
#include "khconfigdlg.h"

KHConfigDlg::KHConfigDlg( KHChip* ioObj, QWidget *parent, char *name ) : QTabDialog( parent, name, true ){

	config = kapp->getConfig();
	// save settings made by other widgets
	// e.g the display widget
	config->sync();
	setCancelButton();

	tab1 = new KHTab1( this );
	tab2 = new KHTab2( this );
	tab3 = new KHTab3( this );

	addTab( tab2, i18n( "General" ) );
	addTab( tab1, i18n( "Monitoring" ) );
	addTab( tab3, i18n( "Temp Sensors" ) );

	connect( this , SIGNAL( cancelButtonPressed() ),
					 this, SLOT  ( rollbackConfig() ) );

	connect( tab1, SIGNAL( beepSettingChanged( bool, SensorId ) ),
					 ioObj, SLOT ( switchAlarm( bool, SensorId ) ) );
	connect( tab1, SIGNAL( faultsSettingChanged( int, SensorId ) ),
					 ioObj, SLOT ( setFaultsCount( int, SensorId ) ) );

	// resize the widget to its minimum size
	resize( 0, 0 );

}

KHConfigDlg::~KHConfigDlg(){
	// discard canceled changes
	// or reread stored ones
	//debug( "destroying KHConfigDlg" );
	//debug( "syncing configuration" );
	config->sync();
	//debug( "reparsing" );
	config->reparseConfiguration();
}

void KHConfigDlg::rollbackConfig(){
	//debug( "rolling back config" );
	config->rollback( false );
}


















