/***************************************************************************
                          khconfigdlg.h  -  description                              
                             -------------------                                         
    begin                : Sun Aug 8 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KHCONFIGDLG_H
#define KHCONFIGDLG_H

#include <qtabdialog.h>

class KConfig;
class KHChip;
class KHConfigDlg;
class KHTab1;
class KHTab2;
class KHTab3;

/** this dialog contains tabbed panes for the configuration items:
	* monitoring settings, general settings
	* @author Ruediger Anlauf
	*	@short the container (tabbed dialog) for the configuration dialog
  */

class KHConfigDlg : public QTabDialog {

Q_OBJECT

public:
	/** constructor
		* constructs a QTabDialog and adds the tabs; connects the signals of the tabs
		* (user actions) to the according slots in the Winbond class
		*@see KHTab1
		*@see KHTab2
		*/
	KHConfigDlg( KHChip* ioObj, QWidget *parent = 0, char *name = 0 );

	/** destructor
		* syncs and reparses the configuration
		*/
	~KHConfigDlg();

protected:
	/** the first tab of the dialog */
	KHTab1  		*tab1;

	/** the second tab of the dialog */
	KHTab2			*tab2;

	/** */
	KHTab3 *tab3;

	/** a pointer to the application's config object */
	KConfig 		*config;

protected slots:
	/** undoes all changes made in the config dialog since the last saving */
	void rollbackConfig();

};

#endif


















