/***************************************************************************
                          khmainwidget.h  -  description
                             -------------------                                         
    begin                : Sun Jul 18 1999                                           
    copyright            : (C) 1999 by Ruediger.Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef MAINWIDGET_H
#define MAINWIDGET_H

#include "khdisplaybase.h"
#include <sensorid.h>

class KConfig;
class KHDisplayItem;
class KHCountingMessage;
class KHChip;
class KHFeatureProfile;

/**
	* This window displays all the LCDs for the monitored values and
	* a set of spin boxes to set the high and low limts for the alarms.
	*	A reference to the cooperating Winbond class is given to the constructor.
	* The signals newDataAcquired() and reportCondRed() are connected with the
	* appropriate LCD displays here. The user can set the limits for the alarms
	* as well as the options for beeping, monitoring and faults count in the
	* config dialog
	* @see ConfigDlg
	* @short The main window of the application
  * @author Ruediger Anlauf
  */
class KHDisplayWidget : public KHDisplayBase  {

Q_OBJECT

public:
	KHDisplayWidget( KHChip* ioObj, KHFeatureProfile *profile );
	~KHDisplayWidget();

protected:
	/** creates and positions the elements in the main widget */
	void initDialog();

	/** reads the configuration file and sets the spin boxes to the appropriate values; use only in constructor */
	void initAlarmSettings();

protected:
	KHDisplayItem *display[SensorIdSize + 1];
	KHChip    *ioObj;
	KConfig		 *config;
  /**  */
  KHCountingMessage *mbox[SensorIdSize];

protected slots:
	void showData( int value, SensorId sid );
	void showData( float value, SensorId sid );
	/** displays options dialog for the configuration settings
		*	@see ConfigDlg */
	void initOptionsDialog();
	void writeAlarm( int value );
	void writeLoLim( int value );	
	void writeHiLim( int value );	
	void showAlertMessage( SensorId sid );
	void cancelAlert( SensorId sid );
	void saveMyself();
	void processSensorCond( SensorId sid, SensorStatus status );

signals:
	void alarmSettingChanged( int value, SensorId sender );
	void loLimSettingChanged( int value, SensorId sender );
	void hiLimSettingChanged( int value, SensorId sender );
};

#endif



























































