/* -*- C -*-
 * This source file is part of the libinetd package.
 * 
 * Copyright (C) 1988 Jrgen Sigvardsson / jorgen@linux.nu
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 * $Id: service.c,v 1.6 1998/05/28 18:39:46 jorgen Exp $
 * $Log: service.c,v $
 * Revision 1.6  1998/05/28 18:39:46  jorgen
 * inetd_AddService semantics changed. inetd_Find, inetd_RemoveService semantics
 * also changed. Added support for comment-meta information in inetd.conf.
 *
 * Revision 1.5  1998/05/23 18:18:58  jorgen
 * Renamed structs xxx to xxx_ in order to keep g++ happy. (G++ did not like
 * the forward references)
 *
 * Revision 1.4  1998/05/23 14:13:05  jorgen
 * Added rcsid variable
 *
 * Revision 1.3  1998/05/23 13:26:49  jorgen
 * Bugfixes in inetd_AddService().
 *
 * Revision 1.2  1998/05/23 10:55:51  jorgen
 * Beta-ready
 *
 * Revision 1.1  1998/05/23 10:44:27  jorgen
 * Service implementation (datastructure)
 *
 */
#include <string.h>
#include <stdlib.h>
#include "inetd.h"
#include "inetd_private.h"

static const char rcsid[] = "$Id: service.c,v 1.6 1998/05/28 18:39:46 jorgen Exp $";

/* interface functions */

int serv_GetNumArgs(inetd_Service s) {
  /* Pre = s != NULL */
  return s->num_args;
}

const char* serv_GetArg(inetd_Service s, int n) {
  /* Pre = s != NULL && n < s->num_args */
  return s->args[n];
}

const char* serv_GetName(inetd_Service s) {
  /* Pre = s != NULL */
  return s->service_name;
}

const char* serv_GetPath(inetd_Service s) {
  /* Pre = s != NULL */
  return s->server_path;
}

const char* serv_GetUser(inetd_Service s) {
  /* Pre = s != NULL */
  return s->user;
}

int serv_GetSockType(inetd_Service s) {
  /* Pre = s != NULL */
  return s->sock_type;
}

int serv_GetProto(inetd_Service s) {
  /* Pre = s != NULL */
  return s->proto;
}

int serv_GetFlags(inetd_Service s) {
  /* Pre = s != NULL */
  return s->flags;
}

void serv_RemoveArgs(inetd_Service s) {
  /* Pre = s != NULL */
  
  int i;

  for(i = 0; i < s->num_args; i++) {
    free(s->args[i]);
    s->args[i] = NULL;
  }
  s->num_args = 0;
}

void serv_AddArg(inetd_Service s, const char* arg) {
  /* Pre = s != NULL && arg != NULL && s->num_args < MAX_ARGS - 1*/
  s->args[s->num_args++] = strdup(arg);
}

void serv_SetName(inetd_Service s, const char* name) {
  /* Pre = s != NULL && name != NULL */
  if(s->service_name)
    free(s->service_name);
  
  s->service_name = strdup(name);
}

void serv_SetPath(inetd_Service s, const char* path) {
  /* Pre = s != NULL && path != NULL */
  if(s->server_path)
    free(s->server_path);
  s->server_path = strdup(path);
}

void serv_SetUser(inetd_Service s, const char* user) {
  /* Pre = s != NULL && user != NULL */
  if(s->user)
    free(s->user);
  s->user = strdup(user);
}

void serv_SetSockType(inetd_Service s, int t) {
  /* Pre = s != NULL && isValidType(t) */
  s->sock_type = t;
}

void serv_SetProto(inetd_Service s, int t) {
  /* Pre = s != NULL && isValidType(t) */
  s->proto = t;
}

void serv_SetFlags(inetd_Service s, int t) {
  /* Pre = s != NULL && isValidType(t) */
  s->flags = t;
}

inetd_Service serv_Create(void) {
  return (inetd_Service)calloc(1, sizeof(struct inetd_Service_));
}

void serv_SetOnOff(inetd_Service s, int onoff) {
  /* Pre = s != NULL */
  s->off = onoff;
}

int serv_IsOff(inetd_Service s) {
  /* Pre = s != NULL */
  return s->off;
}

