/************************************************************************
 * createinst - part of kinst package - main.c                          *
 * Copyright (C) 1999  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "i18n.h"
#include "package.h"

#ifndef WITH_PACKAGE
#define WITH_PACKAGE
#endif

#ifndef KIF_MAGIC
#define KIF_MAGIC "[KDE Install Information]"
#endif

#ifndef EOL
#define EOL 10
#endif

int main(int argc, char* argv[])
{
  char String[1024];
  char String2[1024];

  char ProgramName[1024];
  char CheckPriorFile[1024];
  char CheckPriorRPM[1024];
  char SourceFileType[10];
  char SourceFile[1024];
  char ReadMeFile[1024];
  char GraphicsFile[1024];
  char IconFile[1024];
  char ExecBinary[1024];
  char KDELNKAdditions[1024];
  char DefaultInstallPath[1024];
  char RelocatablePackage[1024];
  char DefaultMenuEntry[1024];
  char PreInstallScript[1024];
  char DoneInstallScript[1024];
  char RecommendReboot[1024];

  char InstDir[1024];

  char filename[1024];
  char KIFrawfilename[1024];

  char PackYesNo[2];

  FILE* f;

  init_gettext();

  printf(_i18n("createinst - installation set creator for kinst\n"));
  printf(_i18n("Copyright (C) 1999  Steffen Sobiech\n"));
  printf(_i18n("\nThis program underlies the GPL.\n"));
  printf(_i18n("IT COMES WITH ABSOLUTELY NO WARRANTY.\n\n"));

  printf(_i18n("Hopefully this becomes replaced by a GUI tool soon... :-)\n\n"));

  printf(_i18n("Please specify a directory to put the installation set in\n"));
  printf(": ");
  scanf("%1024s", InstDir);
  printf("\n");

  printf(_i18n("Program Name\n"));
  printf(_i18n("The actual program name.\n"));
  printf(": ");
  scanf("%1024s", ProgramName);
  printf("\n");

  printf(_i18n("File Check\n"));
  printf(_i18n("kinst will check the existance of this file before the\n"));
  printf(_i18n("installation process takes place.\n"));
  printf(_i18n("This is used to check if a package is already installed.\n"));
  printf(_i18n("The file path is relative to the installation folder\n"));
  printf(_i18n("(the program's root dir).\n"));
  printf(_i18n("If you are going to use RPMs this option will be ignored.\n"));
  printf(_i18n("- for none\n"));
  printf(": ");
  scanf("%1024s", CheckPriorFile);
  printf("\n");
  if(CheckPriorFile[0] == '-') strcpy(CheckPriorFile, "");

  printf(_i18n("RPM Check\n"));
  printf(_i18n("kinst will check the existance of this RPM entry first.\n"));
  printf(_i18n("Used to detect an existing installation of that RPM.\n"));
  printf(_i18n("Ignored if using TGZ.\n"));
  printf(_i18n("- for none\n"));
  printf(": ");
  scanf("%1024s", CheckPriorRPM);
  printf("\n");
  if(CheckPriorRPM[0] == '-') strcpy(CheckPriorRPM, "");

  printf(_i18n("Source File Type\n"));
  printf(_i18n("File type of the main program package.\n"));
  printf(_i18n("Can be TGZ and RPM at the moment.\n"));
  printf(": ");
  scanf("%1024s", SourceFileType);
  printf("\n");

  printf(_i18n("Source File\n"));
  printf(_i18n("The program package. Don't actually specify any paths here,\n"));
  printf(_i18n("the location of the source file can be given later on.\n"));
  printf(": ");
  scanf("%1024s", SourceFile);
  printf("\n");

  printf(_i18n("ReadMe File\n"));
  printf(_i18n("The README file to be shown.\n"));
  printf(_i18n("Strongly recommended to override the \"standard\" output...\n"));
  printf(_i18n("Don't specify any paths here, just the filename.\n"));
  printf(_i18n("- for none\n"));
  printf(": ");
  scanf("%1024s", ReadMeFile);
  printf("\n");
  if(ReadMeFile[0] == '-') strcpy(ReadMeFile, "");

  printf(_i18n("Graphics File\n"));
  printf(_i18n("The main window contains an image on the left side. If you specify a new\n"));
  printf(_i18n("file here it will be used instead. Size should be 120x260.\n"));
  printf(_i18n("As above only the filename...\n"));
  printf(_i18n("- for none\n"));
  printf(": ");
  scanf("%1024s", GraphicsFile);
  printf("\n");
  if(GraphicsFile[0] == '-') strcpy(GraphicsFile, "");

  printf(_i18n("Program Icon\n"));
  printf(_i18n("This file will be the program's icon.\n"));
  printf(_i18n("Relative to the application's root dir.\n"));
  printf(_i18n("- for none\n"));
  printf(": ");
  scanf("%1024s", IconFile);
  printf("\n");
  if(IconFile[0] == '-') strcpy(IconFile, "");

  printf(_i18n("The Executable\n"));
  printf(_i18n("The application's executable.\n"));
  printf(_i18n("Relative to the application's root dir.\n"));
  printf(": ");
  scanf("%1024s", ExecBinary);
  printf("\n");

  printf(_i18n("KDELNK Additions\n"));
  printf(_i18n("Optional additions to the kdelnk generated by kinst.\n"));
  printf(_i18n("May contain locale additions, mime-types etc.\n"));
  printf(_i18n("Relative to the application's root dir.\n"));
  printf(_i18n("- for none\n"));
  printf(": ");
  scanf("%1024s", KDELNKAdditions);
  printf("\n");
  if(KDELNKAdditions[0] == '-') strcpy(KDELNKAdditions, "");

  printf(_i18n("Default Installation Path\n"));
  printf(_i18n("The default target dir to be proposed.\n"));
  printf(": ");
  scanf("%1024s", DefaultInstallPath);
  printf("\n");
    
  printf(_i18n("Relocatable Package\n"));
  printf(_i18n("Indicates if the package can be installed in another directory than\n"));
  printf(_i18n("specified in DEFAULTINSTALLPATH (and will work there).\n"));
  printf(_i18n("(e.g. Certain RPM packages cannot be installed in other dirs than those\n"));
  printf(_i18n("they were originally designed to.)\n"));
  printf(_i18n("Please specify YES or NO in capitals.\n"));
  printf(": ");
  scanf("%1024s", RelocatablePackage);
  printf("\n");

  printf(_i18n("Default Menu Folder\n"));
  printf(_i18n("kinst will create the kdelnk in this dir (relative to the usual KDE trees).\n"));
  printf(_i18n("It should now be possible to enter the menu name in the language of the\n"));
  printf(_i18n("set locale. (Here you should specify the Name in C locale)\n"));
  printf(_i18n("The actual menu entry itself is constructed by ProgramName+.kdelnk\n"));
  printf(": ");
  scanf("%1024s", DefaultMenuEntry);
  printf("\n");
    
  printf(_i18n("Pre Install Script\n"));
  printf(_i18n("The given script (or app) will be run before the installation.\n"));
  printf(_i18n("Just the filename, we'll collect it later.\n"));
  printf(_i18n("- for none\n"));
  printf(": ");
  scanf("%1024s", PreInstallScript);
  printf("\n");
  if(PreInstallScript[0] == '-') strcpy(PreInstallScript, "");

  printf(_i18n("After Install Script\n"));
  printf(_i18n("Script or app to be run after the installation.\n"));
  printf(_i18n("Relative to the application's root dir.\n"));
  printf(_i18n("- for none\n"));
  printf(": ");
  scanf("%1024s", DoneInstallScript);
  printf("\n");
  if(DoneInstallScript[0] == '-') strcpy(DoneInstallScript, "");

  printf(_i18n("Recommend Reboot\n"));
  printf(_i18n("Should our program propose to reboot the system? No, you never have to\n"));
  printf(_i18n("reboot Linux... :-) This entry is actually ignored but will be added in\n"));
  printf(_i18n("future versions.\n"));
  printf(": ");
  scanf("%1024s", RecommendReboot);
  printf("\n");

  strcpy(String2, "mkdir -p ");
  strcat(String2, InstDir);

  system(String2);

  printf(_i18n("Creating .kif file..."));

  strcpy(filename, InstDir);
  strcat(filename, "/");
  strcat(filename, ProgramName); /* or something else... */
  strcat(filename, ".kif");

  f = 0;
  f = fopen(filename,"w");
  if(f == 0) {
    fprintf(stderr, _i18n("I/O error while opening/creating %s\n"), filename);
    return(127);
  }

  /* get kif-file written */

  strcpy(String, KIF_MAGIC);
  fputs(String, f);
  fputc(EOL, f);

  strcpy(String, "PROGRAMNAME");
  strcat(String, "=");
  strcat(String, ProgramName);
  fputs(String, f);
  fputc(EOL, f);

  strcpy(String, "CHECKPRIORFILE");
  strcat(String, "=");
  strcat(String, CheckPriorFile);
  fputs(String, f);
  fputc(EOL, f);

  strcpy(String, "CHECKPRIORRPM");
  strcat(String, "=");
  strcat(String, CheckPriorRPM);
  fputs(String, f);
  fputc(EOL, f);

  strcpy(String, "SOURCEFILETYPE");
  strcat(String, "=");
  strcat(String, SourceFileType);
  fputs(String, f);
  fputc(EOL, f);

  strcpy(String, "SOURCEFILE");
  strcat(String, "=");
  strcat(String, SourceFile);
  fputs(String, f);
  fputc(EOL, f);

  strcpy(String, "READMEFILE");
  strcat(String, "=");
  strcat(String, ReadMeFile);
  fputs(String, f);
  fputc(EOL, f);

  strcpy(String, "GRAPHICSFILE");
  strcat(String, "=");
  strcat(String, GraphicsFile);
  fputs(String, f);
  fputc(EOL, f);

  strcpy(String, "ICONFILE");
  strcat(String, "=");
  strcat(String, IconFile);
  fputs(String, f);
  fputc(EOL, f);

  strcpy(String, "EXECBINARY");
  strcat(String, "=");
  strcat(String, ExecBinary);
  fputs(String, f);
  fputc(EOL, f);

  strcpy(String, "KDELNKADDITIONS");
  strcat(String, "=");
  strcat(String, KDELNKAdditions);
  fputs(String, f);
  fputc(EOL, f);

  strcpy(String, "DEFAULTINSTALLPATH");
  strcat(String, "=");
  strcat(String, DefaultInstallPath);
  fputs(String, f);
  fputc(EOL, f);

  strcpy(String, "RELOCATABLEPACKAGE");
  strcat(String, "=");
  strcat(String, RelocatablePackage);
  fputs(String, f);
  fputc(EOL, f);

  strcpy(String, "DEFAULTMENUENTRY");
  strcat(String, "=");
  strcat(String, DefaultMenuEntry);
  fputs(String, f);
  fputc(EOL, f);

  strcpy(String, "PREINSTALLSCRIPT");
  strcat(String, "=");
  strcat(String, PreInstallScript);
  fputs(String, f);
  fputc(EOL, f);

  strcpy(String, "DONEINSTALLSCRIPT");
  strcat(String, "=");
  strcat(String, DoneInstallScript);
  fputs(String, f);
  fputc(EOL, f);

  strcpy(String, "RECOMMENDREBOOT");
  strcat(String, "=");
  strcat(String, RecommendReboot);
  fputs(String, f);
  fputc(EOL, f);

  if(f != NULL) 
    if(fclose(f) != 0) printf("Warning: KIF file could not be closed!\n");

  printf(_i18n("done\n\n"));

  /* collect the files */

  printf(_i18n("Location of the package file\n"));
  printf(": ");
  scanf("%1024s", String);
  printf("\n");

  printf(_i18n("Collecting program package..."));

  strcpy(String2, "cp ");
  strcat(String2, String);
  strcat(String2, " ");
  strcat(String2, InstDir);

  if(system(String2) != 0) printf(_i18n("failed\n\n"));
  printf(_i18n("done\n\n"));

  if(strlen(ReadMeFile) != 0) {
    printf(_i18n("Location of the README file\n"));
    printf(": ");
    scanf("%1024s", String);
    printf("\n");

    printf(_i18n("Collecting README file..."));

    strcpy(String2, "cp ");
    strcat(String2, String);
    strcat(String2, " ");
    strcat(String2, InstDir);

    if(system(String2) != 0) printf(_i18n("failed\n\n"));
    printf(_i18n("done\n\n"));
  }

  if(strlen(GraphicsFile) != 0) {
    printf(_i18n("Location of the graphics file\n"));
    printf(": ");
    scanf("%1024s", String);
    printf("\n");

    printf(_i18n("Collecting graphics file..."));

    strcpy(String2, "cp ");
    strcat(String2, String);
    strcat(String2, " ");
    strcat(String2, InstDir);

    if(system(String2) != 0) printf(_i18n("failed\n\n"));
    printf(_i18n("done\n\n"));
  }

  /* Give control to package.c */

#ifdef WITH_PACKAGE
  printf(_i18n("Do you want to create a package [Y/N]? "));
  scanf("%1s", PackYesNo);
  PackYesNo[0] = toupper(PackYesNo[0]);
  if(PackYesNo[0] != 'Y') return(0);

  strcpy(KIFrawfilename, ProgramName);
  strcat(KIFrawfilename, ".kif");

  return(GetOverPacking(InstDir, ProgramName, KIFrawfilename,
			SourceFile, GraphicsFile, ReadMeFile,
			PreInstallScript));
#endif
}
