/***************************************************************************
    $Id: locationpage.cpp,v 1.4 1999/09/23 16:06:31 stephan Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: locationpage.cpp,v $
    Revision 1.4  1999/09/23 16:06:31  stephan
    Minor changes in kpcwizard

    Revision 1.3  1999/09/20 18:40:06  stephan
    Started with support for different networktypes in kpcwizard

    Revision 1.2  1999/08/27 16:42:57  wdl
    Standard Headers

 ***************************************************************************/
#include "locationpage.h"

LocationPage::LocationPage(QWidget *parent, const char *name ) : QWidget(parent,name) {
	 buttonGrp = new QButtonGroup(this);
	 buttonGrp->setGeometry(170,100,250,80);
	 buttonGrp->setFrameStyle(0);
	 local = new QRadioButton(i18n("Local printer"),buttonGrp);
	 local->setChecked(true);
	 local->setGeometry(0,0,250,20);
	 net = new QRadioButton(i18n("Network printer"),buttonGrp);
	 net->setGeometry(0,20,250,20);
	 buttonGrp->insert(local);
	 buttonGrp->insert(net);
	 netbuttonGrp = new QButtonGroup(this);
	 netbuttonGrp->setGeometry(200,142,220,80);
	 netbuttonGrp->setFrameStyle(0);
	 netbuttonGrp->hide();
   lpd = new QRadioButton(i18n("UNIX/LPD"),netbuttonGrp);
	 lpd->setFont( QFont(lpd->font().family(),10) );
	 lpd->setGeometry(0,0,220,20);
	 lpd->setChecked(true);
	 smb = new QRadioButton(i18n("Windows 9x/NT/SMB"),netbuttonGrp);
	 smb->setFont( QFont(smb->font().family(),10) );
	 smb->setGeometry(0,20,220,20);
   netbuttonGrp->insert(lpd);
	 netbuttonGrp->insert(smb);
	 Help = new HTMLHelp(this);
   Help->setGeometry(0,0,150,height()-20);
	 Help->showHelp("loc.html");

	 connect(net,SIGNAL(clicked()),SLOT(netClicked()) );
	 connect(local,SIGNAL(clicked()),SLOT(locClicked()) );
	 connect(smb,SIGNAL(clicked()),SLOT(netClicked()) );
	 connect(lpd,SIGNAL(clicked()),SLOT(netClicked()) );
}

LocationPage::~LocationPage(){
}

void LocationPage::netClicked(){
	if(smb->isChecked()) emit isNetPrinter(KpcPrinter::smb);
	if(lpd->isChecked()) emit isNetPrinter(KpcPrinter::lpd);
	netbuttonGrp->show();
}

void LocationPage::locClicked(){
	emit isNetPrinter(KpcPrinter::local);
	netbuttonGrp->hide();
}

void LocationPage::resizeEvent(QResizeEvent *){
	Help->setGeometry(0,10,150,height()-20);	
}













