/***************************************************************************
    $Id: portpage.cpp,v 1.3 1999/08/27 16:42:58 wdl Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: portpage.cpp,v $
    Revision 1.3  1999/08/27 16:42:58  wdl
    Standard Headers

 ***************************************************************************/
#include "portpage.h"

PortPage::PortPage(QWidget *parent, const char *name ) : QWidget(parent,name) {
	buttonGrp = new QButtonGroup(this);
	buttonGrp->setFrameStyle(0);
	buttonGrp->setGeometry(170,10,200,200);
	lp0 = new QRadioButton(i18n("/dev/lp0"),buttonGrp);
	lp0->setGeometry(0,50,180,25);
	lp1 = new QRadioButton(i18n("/dev/lp1"),buttonGrp);
	lp1->setGeometry(0,80,180,25);
	lp2 = new QRadioButton(i18n("/dev/lp2"),buttonGrp);
	lp2->setGeometry(0,110,180,25);
	buttonGrp->insert(lp0);
	buttonGrp->insert(lp1);
	buttonGrp->insert(lp2);	
	buttonGrp->setEnabled(true);

	detectPorts();
	Help = new HTMLHelp(this);
	Help->setGeometry(0,0,150,height());
	Help->showHelp("port.html");
}

PortPage::~PortPage(){
}

const char * PortPage::getPort(){
	if(lp0->isChecked()) return "/dev/lp0";
	if(lp1->isChecked()) return "/dev/lp1";
	if(lp2->isChecked()) return "/dev/lp2";
	return "/dev/null";
}

void PortPage::resizeEvent(QResizeEvent *){
	Help->setGeometry(0,10,150,height()-20);	
}

void PortPage::detectPorts(){
	QFile port_lp0("/dev/lp0");
	QFile port_lp1("/dev/lp1");
	QFile port_lp2("/dev/lp2");
	
	if( system("id -u") == 0 ) {
  	port_lp0_Exists = false;
  	port_lp1_Exists = false;
  	port_lp2_Exists = false;

  	/* Check for /dev/lp0 */
  	if( port_lp0.open(IO_WriteOnly) ) {
  		port_lp0.close();
  		port_lp0_Exists = true;
  		lp0->setEnabled(true);
  	}
  	else
  		lp0->setEnabled(false);

  	/* Check for /dev/lp1 */
  	if( port_lp1.open(IO_WriteOnly) ) {
  		port_lp1.close();
  		port_lp1_Exists = true;
  		lp1->setEnabled(true);
  	}
  	else
  		lp1->setEnabled(false);

  	/* Check for /dev/lp2 */
  	if( port_lp2.open(IO_WriteOnly) ) {
  		port_lp2.close();
  		port_lp2_Exists = true;
  		lp2->setEnabled(true);
  	}
  	else
  		lp2->setEnabled(false);
	}
	else {
  	port_lp0_Exists = true;
  	port_lp1_Exists = true;
  	port_lp2_Exists = true;
 		lp0->setEnabled(true);
 		lp1->setEnabled(true);
 		lp2->setEnabled(true);
	}

	/* only check and existing port */
	if( lp0->isEnabled() )
		lp0->setChecked(true);
	else
		if( lp1->isEnabled() )
			lp1->setChecked(true);
		else
			if( lp2->isEnabled() )
				lp2->setChecked(true);
}
























