/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <kapp.h>

#include "device.h"


Device::Device(baseclass bclass, const QString& name) : _devname(name),
				                        _baseclass(bclass)
{
  _reslist.setAutoDelete(true);
  _reslist.clear();
}


void  Device::addResource(Resource *res)
{
  _reslist.append(res);
}


void  Device::removeResource(Resource *res)
{
  _reslist.removeRef(res);
}


QString  Device::bigPixmapFile()
{
  switch (_baseclass)
  {
    case BaseClassPCIUnclassified       : return QString("system.xpm");
    case BaseClassPCIStorage	        : return QString("drivectrl.xpm");
    case BaseClassPCINetwork	        : return QString("network.xpm");
    case BaseClassPCIDisplay	        : return QString("display.xpm");
    case BaseClassPCIMultimedia	        : return QString("audio.xpm");
    case BaseClassPCIMemory	        : return QString("system.xpm");
    case BaseClassPCIBridge	        : return QString("system.xpm");
    case BaseClassPCICommunication      : return QString("network.xpm");
    case BaseClassPCISystem	        : return QString("system.xpm");
    case BaseClassPCIInput 	        : return QString("system.xpm");
    case BaseClassPCIDocking	        : return QString("system.xpm");
    case BaseClassPCIProcessor	        : return QString("system.xpm");
    case BaseClassPCISerial	        : return QString("usb.xpm");

    case BaseClassConnector             : return QString("connectors.xpm");
    case BaseClassMassStorageController : return QString("drivectrl.xpm");
    case BaseClassMassStorage           : return QString("storage.xpm");
    case BaseClassPrinter               : return QString("printer.xpm");
    case BaseClassCDROM                 : return QString("cdrom.xpm");
    case BaseClassSCSIController        : return QString("scsi.xpm");
    //case BaseClassScanner               : return QString("scanner.xpm");

    default			        : return QString("system.xpm");
  }
}


QString  Device::deviceBaseClassName()
{
  switch (_baseclass)
  {
    case BaseClassPCIUnclassified       : return QString(i18n("Unclassified devices"));
    case BaseClassPCIStorage	        : return QString(i18n("Mass storage controllers"));
    case BaseClassPCINetwork	        : return QString(i18n("Network controllers"));
    case BaseClassPCIDisplay	        : return QString(i18n("Display controllers"));
    case BaseClassPCIMultimedia	        : return QString(i18n("Audio, video and game controllers"));
    case BaseClassPCIMemory	        : return QString(i18n("System components"));
    case BaseClassPCIBridge	        : return QString(i18n("System components"));
    case BaseClassPCICommunication      : return QString(i18n("Communication controllers"));
    case BaseClassPCISystem	        : return QString(i18n("System components"));
    case BaseClassPCIInput 	        : return QString(i18n("Input device controllers"));
    case BaseClassPCIDocking	        : return QString(i18n("Docking stations"));
    case BaseClassPCIProcessor	        : return QString(i18n("System components"));
    case BaseClassPCISerial	        : return QString(i18n("Serial bus controllers"));

    case BaseClassConnector             : return QString(i18n("Connectors"));
    case BaseClassMassStorage           : return QString(i18n("Drives"));
    case BaseClassMassStorageController : return QString(i18n("Mass storage controllers"));
    case BaseClassPrinter               : return QString(i18n("Printer"));
    case BaseClassCDROM                 : return QString(i18n("CD-ROM"));
    case BaseClassSCSIController        : return QString(i18n("SCSI controllers"));
    case BaseClassScanner               : return QString(i18n("Scanners"));
 
    default			        : return QString(i18n("Unknown device class"));
  }
}


QString  Device::smallPixmapFile()
{
  switch (_baseclass)
  {
    case BaseClassPCIUnclassified       : return QString("mini-system.xpm");
    case BaseClassPCIStorage	        : return QString("mini-drivectrl.xpm");
    case BaseClassPCINetwork	        : return QString("mini-network.xpm");
    case BaseClassPCIDisplay	        : return QString("mini-display.xpm");
    case BaseClassPCIMultimedia	        : return QString("mini-audio.xpm");
    case BaseClassPCIMemory	        : return QString("mini-system.xpm");
    case BaseClassPCIBridge	        : return QString("mini-system.xpm");
    case BaseClassPCICommunication      : return QString("mini-network.xpm");
    case BaseClassPCISystem	        : return QString("mini-system.xpm");
    case BaseClassPCIInput 	        : return QString("mini-system.xpm");
    case BaseClassPCIDocking	        : return QString("mini-system.xpm");
    case BaseClassPCIProcessor	        : return QString("mini-system.xpm");
    case BaseClassPCISerial	        : return QString("mini-usb.xpm");

    case BaseClassConnector             : return QString("mini-connectors.xpm");
    case BaseClassMassStorage           : return QString("mini-storage.xpm");
    case BaseClassMassStorageController : return QString("mini-drivectrl.xpm");
    case BaseClassPrinter               : return QString("mini-printer.xpm");
    case BaseClassCDROM                 : return QString("mini-cdrom.xpm");
    case BaseClassSCSIController        : return QString("mini-scsi.xpm");
    //case BaseClassScanner               : return QString("mini-scanner.xpm");

    default			        : return QString("mini-system.xpm");
  }
}


