/***************************************************************************
                          dhlogview.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Jun 22 17:36:34 MEST 1999
                                           
    copyright            : (C) 1999 by Henning Folger                         
    email                : hf@holgu.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qprinter.h>
#include <qpainter.h>

// application specific includes
#include <dhlogview.h>
#include "dhlogdoc.h"
#include "dhlog.h"
#include "qso.h"

DHLogView::DHLogView(QWidget *parent, const char* name) : QWidget(parent, name){
	//setBackgroundMode( PaletteBase );	
	// Hauptfenster aufbauen
	lFrame1 = new QFrame(this);
   lFrame1->setGeometry(11,11,435,103);
	lFrame1->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	
	lFrame2 = new QFrame(this);
	lFrame2->setGeometry(11,119,155,105);
	lFrame2->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	
	lDate = new QLabel(this);
	lDate->setText(i18n("Date"));
 	lDate->setGeometry(15,15,65,12);
 	lDate->setAlignment(AlignCenter);

 	fDate = new LogLabel(this);
 	fDate->setGeometry(15,30,65,20);
 	
 	lUTC = new QLabel(this);
	lUTC->setText(i18n("UTC"));
 	lUTC->setGeometry(85,15,45,12);
 	lUTC->setAlignment(AlignCenter);
 	
 	fUTC = new LogLabel(this);
 	fUTC->setGeometry(85,30,45,20);
// 	fUTC->setReadOnly(true);
 	
 	lCall = new QLabel(this);
	lCall->setText(i18n("Call"));
 	lCall->setGeometry(135,15,105,12);
 	lCall->setAlignment(AlignCenter);
 	
 	fCall = new LogLabel(this);
 	fCall->setGeometry(135,30,105,20);
// 	fCall->setReadOnly(true); 	
 	lBand = new QLabel(this);
	lBand->setText(i18n("Band"));
 	lBand->setGeometry(245,15,45,12);
 	lBand->setAlignment(AlignCenter);
 	
 	fBand = new LogLabel(this);
 	fBand->setGeometry(245,30,45,20);
// 	fBand->setReadOnly(true);
 	
 	lMode = new QLabel(this);
	lMode->setText(i18n("Mode"));
 	lMode->setGeometry(295,15,45,12);
 	lMode->setAlignment(AlignCenter);
 	
 	fMode = new LogLabel(this);
 	fMode->setGeometry(295,30,45,20);
// 	fMode->setReadOnly(true);
 	
 	lRSTout = new QLabel(this);
	lRSTout->setText(i18n("RST out"));
 	lRSTout->setGeometry(345,15,45,12);
 	lRSTout->setAlignment(AlignCenter);
 	
 	fRSTout = new LogLabel(this);
 	fRSTout->setGeometry(345,30,45,20);
// 	fRSTout->setReadOnly(true);
 	
 	lRSTin = new QLabel(this);
	lRSTin->setText(i18n("RST in"));
 	lRSTin->setGeometry(395,15,45,12);
 	lRSTin->setAlignment(AlignCenter);
	
	fRSTin = new LogLabel(this);
	fRSTin->setGeometry(395,30,45,20);
	
	lName = new QLabel(this);
	lName->setText(i18n("Name"));
	lName->setGeometry(15,65,130,12);
	lName->setAlignment(AlignCenter);
	
	fName = new LogLabel(this);
	fName->setGeometry(15,80,130,20);
	
	lQth = new QLabel(this);
	lQth->setText(i18n("QTH"));
	lQth->setGeometry(150,65,130,12);
	lQth->setAlignment(AlignCenter);
	
	fQth = new LogLabel(this);
	fQth->setGeometry(150,80,130,20);
	
	lDok = new QLabel(this);
	lDok->setText(i18n("DOK"));
	lDok->setGeometry(285,65,70,12);
	lDok->setAlignment(AlignCenter);
	
	fDok = new LogLabel(this);
	fDok->setGeometry(285,80,70,20);	
	
	lLocator = new QLabel(this);
	lLocator->setText(i18n("Locator"));
	lLocator->setGeometry(360,65,80,12);
	lLocator->setAlignment(AlignCenter);
	
	fLocator = new LogLabel(this);
	fLocator->setGeometry(360,80,80,20);
	
	fScroller = new QScrollBar(this);
	fScroller->setGeometry(451,11,15,200);
	fScroller->setOrientation(QScrollBar::Vertical);
	fScroller->setSteps(10,100);
	connect(fScroller, SIGNAL(valueChanged(int)), this, SLOT(slotScroll(int)) );

	fQslIn = new QCheckBox(this);
	fQslIn->setText(i18n("QSL in"));
	fQslIn->setGeometry(15,120,65,20);
	connect(fQslIn, SIGNAL(clicked()), this, SLOT(slotQslClick()) );
	
	fQslOut = new QCheckBox(this);
	fQslOut->setText(i18n("QSL out"));
	fQslOut->setGeometry(85,120,70,20);
   connect(fQslOut, SIGNAL(clicked()), this, SLOT(slotQslClick()) );

	lQslVia = new QLabel(this);
	lQslVia->setText(i18n("QSL Via:"));
	lQslVia->setGeometry(15,145,50,20);
	lQslVia->setAlignment(AlignVCenter);
	
	fQslVia = new LogLabel(this);
	fQslVia->setGeometry(70,145,85,20);
	
	lQsoNr = new QLabel(this);
	lQsoNr->setText("QSO No.:");
	lQsoNr->setGeometry(15,172,120,12);
	
	lQsoAnz = new QLabel(this);
	lQsoAnz->setText("QSOs:");
	lQsoAnz->setGeometry(15,188,120,12);
	
	lCallAnz = new QLabel(this);
	lCallAnz->setText("Calls:");
	lCallAnz->setGeometry(15,204,120,12);

}

DHLogView::~DHLogView(){
}


DHLogDoc* DHLogView::getDocument() const
{
	DHLogApp* theApp=(DHLogApp*)parentWidget();
	return theApp->getDocument();
}

void DHLogView::print(QPrinter* m_pPrinter)
{
	QPainter printpainter;
	printpainter.begin(m_pPrinter);
	
	// TODO: add your printing code here
	
	printpainter.end();

}


void DHLogView::UpdateView(long nr)
{
	char help[100];
	CQso  *qso;
	CCall *call;
	LogBook *log;
	CBand band;
	CMode mode;
	
	logdoc = getDocument();
	log = logdoc->log;
	if(log != NULL)
	{
		if(nr == -1)
			nr = log->aktQso();
		
		//Update Statusfeld
		oldqsonr = nr;
		sprintf(help,"QSO No.: %d",(int)nr);
		lQsoNr->setText(help);
		sprintf(help,"QSOs:\t%d",(int)log->anzQso());
		lQsoAnz->setText(help);
		sprintf(help,"Calls:\t%d",(int)log->anzCall());
		lCallAnz->setText(help);
	
		//Update Scroller
		if(log->anzQso() > 0)
		{
			fScroller->setEnabled(true);
			fScroller->setRange(1,log->anzQso());
			fScroller->setValue(nr);
		}
		else
			fScroller->setEnabled(false);	

		//Update Qso-Felder
		qso = log->GetQso(nr);
		if(qso != NULL)
		{
			fDate->setText(qso->datum.get(DTAUS_SHORT));
			fUTC->setText(qso->utc.get());
			fCall->setText(qso->GetCall());
			fQslVia->setText(qso->GetViaCall());
			fBand->setText(band.band(qso->GetBand()));
			fMode->setText(mode.mode(qso->GetMode()));
			fRSTin->setText(qso->GetRstEin());
			fRSTout->setText(qso->GetRstAus());
			fQslIn->setChecked(qso->GetQslEin());
			fQslIn->setEnabled(qso->GetQslActivity());
			fQslOut->setChecked(qso->GetQslAus());
			fQslOut->setEnabled(qso->GetQslActivity());
		}
		else
		{
			fDate->setText("");
			fUTC->setText("");
			fCall->setText("");
			fQslVia->setText("");
			fBand->setText("");
			fMode->setText("");
			fRSTin->setText("");
			fRSTout->setText("");
			fQslIn->setChecked(false);
			fQslIn->setEnabled(false);
			fQslOut->setChecked(false);
			fQslOut->setEnabled(false);
		}
			
	
		//Update Call-Felder
		call = log->SearchCall(qso);
		if(call == NULL)
		{	
			fName->setText("-");
			fQth->setText("-");
			fDok->setText("-");
			fLocator->setText("-");
		}
		else
		{
			fName->setText(call->GetName());
			fQth->setText(call->GetQth());
			fDok->setText(call->GetDok());
			fLocator->setText(call->GetLocator());
		}
	}
	emit updEnableMenu();
}	

void DHLogView::slotScroll(int nr)
{
	getDocument()->log->setAktQso(nr);
	UpdateView(-1);
}

void DHLogView::slotQslClick()
{
	getDocument()->log->setAktQso(oldqsonr);
	UpdateView(oldqsonr);
}





















