/***************************************************************************
                          qso.cpp  -  description                              
                             -------------------                                         
    begin                : Fri Jun 4 1999                                           
    copyright            : (C) 1999 by Henning Folger                         
    email                : hf@holgu.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "qso.h"
#include "logfunc.h"
#include "dhlog.h"





/*char *Banddata[ANZ_BAND]={
       "160m","80m","40m","30m","20m","17m","15m","12m","10m","6m","2m","70cm","23cm",
       "13cm","9cm","6cm","3cm","SONST"
	};*/


CBand::CBand()
{
}

int CBand::anzBand()
{
	return ANZ_BAND;
}

char* CBand::band(int wert)
{
	char *Banddata[ANZ_BAND]={
       "1.8","3.5","7.0","10.1","14.0","18.0","21.0","24.8","28.0","50.0","144","430","23cm",
       "13cm","9cm","6cm","3cm","SONST" };

	if((wert >= 0) && (wert < anzBand()))
		return Banddata[wert];
	else
		return "***";
}

CMode::CMode()
{
}

int CMode::anzMode()
{
	return ANZ_MODE;
}

char* CMode::mode(int wert)
{
	char *Modedata[ANZ_MODE]={
       "FM","SSB","CW","AM","PR","RTTY","AMTOR","Pactor","SSTV","ATV","FAX","SAT",
       "Aurora","Es","MS","EME","TEP","TROPO","PSK","SONST"};
	if((wert >= 0) && (wert < anzMode()))
		return Modedata[wert];
	else
		return "***";
}

char* CMode::rst(int wert)
{
	char *ModeRstData[ANZ_MODE]={
		"59","59","599","59","599","599","599","599","599","599","599","59",
		"59","59","599","599","59","59","599","59"};

	if((wert >= 0) && (wert < anzMode()))
		return ModeRstData[wert];
	else
		return "***";
}




CQso::CQso(){
	call[0] = '\0';
	viacall[0] = '\0';
	band = 0;
	mode = 0;
	rstein[0] = '\0';
	rstaus[0] = '\0';
	info = 0;
	dxcc = 0;
	bemerkung = 0;
}

CQso::CQso(FILE *fh)
{
	LoadQso(fh);
}

CQso::~CQso(){
}

bool CQso::LoadQso(FILE *fh)
{
	int ic;
	int qrg;	// fuer spter...

	ic =  fread(call,sizeof(call),1,fh);
	ic += fread(viacall,sizeof(viacall),1,fh);
	if(datum.Load(fh)) ic++;
	if(utc.Load(fh)) ic++;
	if(endutc.Load(fh)) ic++;
	ic += fread(&band,sizeof(band),1,fh);
	ic += fread(&mode,sizeof(mode),1,fh);
	ic += fread(&qrg,sizeof(qrg),1,fh);
	ic += fread(rstein,sizeof(rstein),1,fh);
	ic += fread(rstaus,sizeof(rstaus),1,fh);
	ic += fread(&info,sizeof(info),1,fh);
	ic += fread(&dxcc,sizeof(dxcc),1,fh);
	ic += fread(&bemerkung,sizeof(bemerkung),1,fh);

	if(ic == 13)				// konnten alle Eintraege gelesen werden ?
		return true;
	else
		return false;
}

bool CQso::SaveQso(FILE *fh)
{
	int ic;
	int qrg;

	qrg = 0;
	ic =  fwrite(call,sizeof(call),1,fh);
	ic += fwrite(viacall,sizeof(viacall),1,fh);
	if(datum.Save(fh)) ic++;
	if(utc.Save(fh)) ic++;
	if(endutc.Save(fh)) ic++;
	ic += fwrite(&band,sizeof(band),1,fh);
	ic += fwrite(&mode,sizeof(mode),1,fh);
	ic += fwrite(&qrg,sizeof(qrg),1,fh);
	ic += fwrite(rstein,sizeof(rstein),1,fh);
	ic += fwrite(rstaus,sizeof(rstaus),1,fh);
	ic += fwrite(&info,sizeof(info),1,fh);
	ic += fwrite(&dxcc,sizeof(dxcc),1,fh);
	ic += fwrite(&bemerkung,sizeof(bemerkung),1,fh);

	if(ic == 13)				// konnten alle Eintraege gespeichert werden ?
		return true;
	else
		return false;
}

void CQso::CallKuerzen(char *ziel,const char *call)
{
   char help[3][15];
   int x,y,z,len[3];
   x = 0;
   z = 0;
   y = strlen(call);
   strcpy(help[0],"");
   strcpy(help[1],"");
   strcpy(help[2],"");
   while(y >= 0)
   {
      if(*call != '/') help[z][x++] = *call;
      else
      {
         help[z++][x] = '\0';
         x = 0;
         call++;
         y--;
         if(z < 3)
            help[z][x++] = *call;
         if(z >= 3 ) y = -1; //sofortiger Abbruch<<<<<<<
      }
      y--;
      call++;
   }
   x = 2;
   y = 0;
   while( x-- >= 0)
   {
      len[y] = strlen(help[y]);
      y++;
   }
   y = 0;
   if( (len[1] >= len[0]) && (len[1] >= len[2])) y = 1;
   if( (len[0] >= len[1]) && (len[0] >= len[2])) y = 0;

   strcpy(ziel,help[y]);
}


char *CQso::GetCall(bool normal,char *out)	// ACHTUNG: Bei false wird das Call gekrtzt, d.h. aus OZ/DL6DH/P wird
{															// nur DL6DH. Dabei wird ein neuer String mit new angelegt, freigeben
	if(normal)											// muss selbst erledigt werden !!!! MEMORY_LEAK !!!!
		return call;
	else
	{
		char hcall[16];
		strcpy(hcall,call);
		CallKuerzen(out,hcall);		
		return out;
	}
}

char *CQso::GetViaCall(void)
{
	return viacall;
}

char *CQso::GetRstEin(void)
{
	return rstein;
}

char *CQso::GetRstAus(void)
{
	return rstaus;
}

bool CQso::GetQslEin(void)
{
	if(info & INFO_QSLEIN)
		return true;
	else
		return false;
}

bool CQso::GetQslAus(void)
{
	if(info & INFO_QSLAUS)
		return true;
	else
		return false;
}

bool CQso::GetQslActivity(void)
{
	if(info & INFO_QSLNOACTIVITY)
		return false;
	else
		return true;
}

bool CQso::GetQslDirekt(void)
{
	if(info & INFO_QSLDIREKT)
		return true;
	else
		return false;
}

int CQso::GetMode(void)
{
	return mode;
}

int CQso::GetBand(void)
{
	return band;
}

bool CQso::SetCall(const char* str)
{
	QString help = QString(str).upper();
	if( (help.length() <= 14) && (help.length() >= 3) )
		strcpy(call,help);
	else
		return false;
	return true;
}

bool CQso::SetViaCall(const char* str)
{
	QString help = QString(str).upper();
	if( ( (help.length() <= 14) && (help.length() >= 3) )  || (help.length() == 0) )
		strcpy(viacall,help);
	else
		return false;
	return true;
}

bool CQso::SetRstEin(const char* str)
{
	QString help = QString(str).upper();
	if( (help.length() >= 2) && (help.length() <= 7) )
		strcpy(rstein,help);
	else
		return false;
	return true;
}

bool CQso::SetRstAus(const char* str)
{
	QString help = QString(str).upper();
	if( (help.length() >= 2) && (help.length() <= 7) )
		strcpy(rstaus,help);
	else
		return false;
	return true;
}

bool CQso::SetMode(const int nr)
{
	CMode help;
	
	if( (nr >= 0) && (nr < help.anzMode()) )
		mode = nr;
	else
		return false;
	return true;
}

bool CQso::SetBand(const int nr)
{
	CBand help;
	
	if( (nr >= 0) && (nr < help.anzBand()) )
		band = nr;
	else return false;
	return true;
}

void CQso::SetQslEin(bool ic)
{
	if(ic)
		info |= INFO_QSLEIN;
	else
		info &= INFO_MAX - INFO_QSLEIN;
}

void CQso::SetQslAus(bool ic)
{
	if(ic)
		info |= INFO_QSLAUS;
	else
		info &= INFO_MAX - INFO_QSLAUS;
}

void CQso::SetQslActivity(bool ic)
{
	if(ic)
		info &= INFO_MAX - INFO_QSLNOACTIVITY;
	else
		info |= INFO_QSLNOACTIVITY;
}

void CQso::SetQslDirekt(bool ic)
{
	if(ic)
		info |= INFO_QSLDIREKT;
	else
		info &= INFO_MAX - INFO_QSLDIREKT;
}

bool CQso::IsVia(void)
{
	if(strlen(viacall) != 0) return true;
	else return false;
}
//
// Methoden der Klasse CCall
/////////////////////////////

CCall::CCall()
{
	call[0] = '\0';
	name[0] = '\0';
	qth[0] = '\0';
	dok[0] = '\0';
	locator[0] = '\0';
	datum = 0;
	valid = 0;
}

CCall::CCall(FILE *fh)
{
	LoadCall(fh);
}


bool CCall::LoadCall(FILE *fh)
{
	int ic;
	
	ic = fread(call,sizeof(call),1,fh);
	ic+= fread(name,sizeof(name),1,fh);
	ic+= fread(qth, sizeof(qth), 1,fh);
	ic+= fread(dok, sizeof(dok), 1,fh);
	ic+= fread(locator,sizeof(locator),1,fh);
	ic+= fread(&datum,sizeof(datum),1,fh);
	ic+= fread(&valid,sizeof(valid),1,fh);
	if(ic == 7)
		return true;
	else
		return false;
}

bool CCall::SaveCall(FILE *fh)
{
	int ic;
	
	ic = fwrite(call,sizeof(call),1,fh);
	ic+= fwrite(name,sizeof(name),1,fh);
	ic+= fwrite(qth, sizeof(qth), 1,fh);
	ic+= fwrite(dok, sizeof(dok), 1,fh);
	ic+= fwrite(locator,sizeof(locator),1,fh);
	ic+= fwrite(&datum,sizeof(datum),1,fh);
	ic+= fwrite(&valid,sizeof(valid),1,fh);
	if(ic == 7)
		return true;
	else
		return false;
}

void CCall::GetCall(char *str)
{
	strcpy(str,call);
	reverse(str);	
}

char *CCall::GetRawCall(void)
{
	return call;
}


char *CCall::GetName(void)
{
	return name;
}

char *CCall::GetQth(void)
{
	return qth;
}

char *CCall::GetDok(void)
{
	return dok;
}

char *CCall::GetLocator(void)
{
	return locator;
}

void CCall::SetCall(const char *str)
{
	char help[15];
	if(strlen(str) <= 14)
		{
			strcpy(help,str);
			reverse(help);
			strcpy(call,help);
		}
	else
		KMsgBox::message(NULL,"CCall::SetCall","Call > 14");
}

void CCall::SetRawCall(const char *str)
{
	if(strlen(str) <= 14)
		strcpy(call,str);
	else
		KMsgBox::message(NULL,"CCall::SetRawCall","Call > 14");
}

void CCall::SetName(const char *str)
{
	if(strlen(str) <= 20)
		strcpy(name,str);
	else
		KMsgBox::message(NULL,"CCall::SetName","Name > 20");
}

void CCall::SetQth(const char *str)
{
	if(strlen(str) <= 20)
		strcpy(qth,str);
	else
		KMsgBox::message(NULL,"CCall::SetQth","Qth > 20");
}

void CCall::SetDok(const char *str)
{
	if(strlen(str) <= 6)
		strcpy(dok,str);
	else
		KMsgBox::message(NULL,"CCall::SetDok","Dok > 6");
}

void CCall::SetLocator(const char *str)
{
	if(strlen(str) <= 6)
		strcpy(locator,str);
	else
		KMsgBox::message(NULL,"CCall::SetLocator","Locator > 6");
}
	

void CCall::reverse(char *s)
{
	int c,i,j;
	
	for(i = 0,j = strlen(s)-1; i < j; i++, j--)
	{
		c = s[i];
		s[i] = s[j];
		s[j] = c;
	}
}

int CCall::dataComplete(KConfig *config)
{
	char help[15];
	bool dlQso;
		
   GetCall(help);
   if(help[0]=='D')
   	dlQso = true;
   else
   	dlQso = false;
   config->setGroup("CALLCHECK");
   if(config->readBoolEntry("CHECK_DOK_EVER",false)) dlQso = true;
   if(config->readBoolEntry("CHECK_NAME",true) && (strlen(name) == 0)) return CALLCHECK_NAME;
   if(config->readBoolEntry("CHECK_QSO",true) && (strlen(qth) == 0)) return CALLCHECK_QTH;
   if(config->readBoolEntry("CHECK_DOK",true) && (strlen(dok) == 0) && dlQso) return CALLCHECK_DOK;
   if(config->readBoolEntry("CHECK_LOC",false) && (strlen(locator) == 0)) return CALLCHECK_LOC;
   return CALLCHECK_OK;
}

	
	
	
//
// Datum und UTC Klassen
// ////////////////////////////////////////
//

CDatum::CDatum()
{
	datum = 0;
	help[0] = '\0';
}

CDatum::CDatum(CDatum& old)
{
	datum = old.getRaw();
	help[0] = '\0';
}

bool CDatum::insert(const char *wert)
{
   int tag,monat,jahr;

   bool ic;
   ic = false;
   if(strlen(wert)==6) // Datum hat Format ddmmjj
   {
      if(strchr(wert,'.') != 0) ic=false;
      tag  = ((wert[0]-'0') *10) + (wert[1]-'0');
      monat= ((wert[2]-'0') *10) + (wert[3]-'0');
      jahr = ((wert[4]-'0') *10) + (wert[5]-'0');
      if(jahr <= 50) jahr += 100;
      jahr += 1900;
      datum = (jahr * 10000) + (monat * 100) + tag;
      ic = true;
      if(strchr(wert,'.') != 0) ic=false;
   }
   if(ic == false)
   {
      if(kuerzen(wert,&tag,&monat,&jahr) == false)
         return false;
      if(jahr < 100)
      {
         if(jahr <= 50) jahr += 100;
         jahr += 1900;
      }

      datum = (jahr * 10000) + (monat * 100) +tag;
      ic =  true;
   }
   if((tag<0) || (tag>=32)) ic = false;
   if(monat==2)  if(tag>29) ic = false;
   if((monat<0) || (monat>=13)) ic = false;
   if(jahr < 1900) ic = false;
   return ic;
}

void CDatum::create(int d,int m,int y)
{
	datum = (y * 10000) + (m * 100) +d;
}

char* CDatum::get(int datumformat)
{
   int jahr,monat,tag;
   char *dat;

   dat = help;
   jahr = (datum / 10000);
   monat= (datum % 10000) / 100;
   tag  = (datum % 100);

   *dat++=(tag / 10)+'0';
   *dat++=(tag % 10)+'0';
   if(datumformat > DTAUS_NON) *dat++='.';

   *dat++=(monat / 10)+'0';
   *dat++=(monat % 10)+'0';
   if(datumformat > DTAUS_NON) *dat++='.';

   if(datumformat != DTAUS_LONG) jahr = jahr % 100;
 	 sprintf(dat,"%d",jahr);
   return help;
}

int CDatum::getRaw()
{
	return datum;
}

bool CDatum::Load(FILE *fh)
{
	if( fread(&datum,sizeof(datum),1,fh) == 1)
		return true;
	else
		return false;
}

bool CDatum::Save(FILE *fh)
{
	if( fwrite(&datum,sizeof(datum),1,fh) == 1)
		return true;
	else
		return false;
}

bool CDatum::kuerzen(const char *dat,int *tag,int *mon, int *year)
{
   char help[3][15];
   int x,y,z;
   x = 0;
   z = 0;
   y = strlen(dat);
   strcpy(help[0],"");
   strcpy(help[1],"");
   strcpy(help[2],"");
   while(y >= 0)
   {
      if(*dat != '.') help[z][x++] = *dat;
      else
      {
         help[z++][x] = '\0';
         x = 0;
         dat++;
         y--;
         if(z < 3)
            help[z][x++] = *dat;
         if(z >= 3 ) y = -1; //sofortiger Abbruch<<<<<<<
      }
      y--;
      dat++;
   }
   if(z != 2) return false;
   *tag = atoi(help[0]);
   *mon = atoi(help[1]);
   *year= atoi(help[2]);
   return true;
}

//
// //////////////////////////////////////
//

CUtc::CUtc()
{
	utc = 0;
	help[0] = '\0';
}

CUtc::CUtc(CUtc& old)
{
	utc = old.getRaw();
	help[0] = '\0';
}

bool CUtc::insert(const char *wert)
{
   int stunde,minute;
   bool ic;

   stunde = 0;
   minute = 0;
   ic=false;
   if(strlen(wert)==4) // Uhrzeit hat Format hhmm
   {
      stunde = ((wert[0]-'0') *10) + (wert[1]-'0');
      minute = ((wert[2]-'0') *10) + (wert[3]-'0');
      utc = (stunde * 100) + minute;
      ic =  true;
   }
   if(strlen(wert)==5) // Uhrzeit hat Format hh:mm
   {
      stunde = ((wert[0]-'0') *10) + (wert[1]-'0');
      minute = ((wert[3]-'0') *10) + (wert[4]-'0');
      utc = (stunde * 100) + minute;
      ic =  true;
   }
   if((stunde<0) || (stunde >23)) ic = false;
   if((minute<0) || (stunde >59)) ic = false;
   return ic;
}

void CUtc::create(int h,int m)
{
	utc = (h * 100) + m;
}


char* CUtc::get(bool trennzeichen)
{
   int minute,stunde;
   char *dat;

   dat = help;
   stunde = (utc % 10000) / 100;
   minute = utc % 100;
   *dat++=(stunde / 10)+'0';
   *dat++=(stunde % 10)+'0';

   if(trennzeichen) *dat++=':';

   *dat++=(minute / 10)+'0';
   *dat++=(minute % 10)+'0';
   *dat='\0';
   return help;
}


	
int CUtc::getRaw()
{
	return utc;
}

bool CUtc::Load(FILE *fh)
{
	if( fread(&utc,sizeof(utc),1,fh) == 1)
		return true;
	else
		return false;
}

bool CUtc::Save(FILE *fh)
{
	if( fwrite(&utc,sizeof(utc),1,fh) == 1)
		return true;
	else
		return false;
}




























































