/**********************************************************************

	--- Qt Architect generated file ---

	File: SearchScopeDialog.cpp
	Last generated: Sun Jun 27 19:28:30 1999

 *********************************************************************/

#include "bibletime.h"
#include "SearchScopeDialog.h"

#define Inherited SearchScopeDialogData

SearchScopeDialog::SearchScopeDialog(QWidget* parent,	const char* name) :
										Inherited( parent, name )
{
	connect(scopeType,SIGNAL(clicked(int)), this, SLOT(slotSearchType(int)));
	this->slotSearchType(0);
	setI18n();
}


SearchScopeDialog::~SearchScopeDialog()
{
}

BibleTimeApp::SearchScope SearchScopeDialog::getSearchScope()
{
	switch (_scopeType)
	{
		case 0: return BibleTimeApp::NoScope;
		case 1: return BibleTimeApp::LastSearch;
		case 2: return BibleTimeApp::Bounds;
	}
	return BibleTimeApp::NoScope;
}

QString SearchScopeDialog::getLowerBound()
{
	_lowerBound.setStr(lowerBound->text());
	return _lowerBound;
}

QString SearchScopeDialog::getUpperBound()
{
	_upperBound.setStr(upperBound->text());
	return _upperBound;
}

void SearchScopeDialog::slotSearchType(int s)
{
	bool enable=false;
	
	if (s == 2)
		enable=true;
	else
		enable=false;
	
	upperBound->setEnabled(enable);
	lowerBound->setEnabled(enable);
	
	_scopeType = s;
}

void SearchScopeDialog::setI18n()
{
	lowerBound_Label->setText( i18n("lower bound:") );		
	upperBound_Label->setText( i18n("upper bound:") );	
	noScope_Button->setText( i18n("no scope") );	
	lastSearch_Button->setText( i18n("last search") );	
	setBounds_Button->setText( i18n("set bounds") );	
}

void SearchScopeDialog::resizeEvent(QResizeEvent* event)
{
	if (this->width()!=0)
	{
		lowerBound->setGeometry(105,70,this->width()-110, 30);	
		upperBound->setGeometry(105,105,this->width()-110, 30);	
		scopeType->setGeometry(5,5,this->width()-10,60 );
		setBounds_Button->setGeometry(15,40,this->width()-25,20 );
	
		noScope_Button->setGeometry(10,10,(scopeType->width()/2)-5 ,20);
		lastSearch_Button->setGeometry(10+(scopeType->width()/2)-5,10, (scopeType->width()/2)-5, 20);
		setBounds_Button->setGeometry(10,40,scopeType->width()-10,20);
	};
}