/***************************************************************************
                          kmhistory.cpp  -  description
                             -------------------
    begin                : Sat Jan 8 2000
    copyright            : (C) 2000 by Ian Zepp
    email                : icszepp@islc.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmhistory.h"
#include "kmconfig.h"

KmHistory::KmHistory(QWidget *parent, const char *name ) : QTabDialog(parent,name) {
	kmhist = new KmHistoryWidget(this);

	connect(kmhist, SIGNAL(sigReloadHostname()),
		SIGNAL(sigReloadHostname()) );
	connect(kmhist, SIGNAL(sigReloadArguments()),
		SIGNAL(sigReloadArguments()) );
	connect(kmhist, SIGNAL(sigAccept()),
		SLOT(accept()) );

	this->addTab(kmhist, i18n("History List"));

	LoadDefaults();
	Load();
}
KmHistory::~KmHistory(){
}

void KmHistory::Load()
{
	kmhist->Load();
}
void KmHistory::LoadDefaults()
{
	kmhist->LoadDefaults();
}

/*
 *
 *
 *
 *
 *
 *
 */

KmHistoryWidget::KmHistoryWidget(QWidget *parent, const char *name ) : QWidget(parent,name) {
	histList = new QListView(this);
	histList->setAllColumnsShowFocus(true);
	histList->setFrameStyle(QFrame::WinPanel | QFrame::Sunken);

	histList->addColumn(i18n("Host"));
	histList->addColumn(i18n("Options"));

	connect(histList, SIGNAL(selectionChanged(QListViewItem *)),
		SLOT(slotSelection(QListViewItem *)) );
	connect(histList, SIGNAL(doubleClicked(QListViewItem *)),
		SLOT(slotDoubleClicked(QListViewItem *)) );

	Load();
	LoadDefaults();
}
KmHistoryWidget::~KmHistoryWidget(){
}

void KmHistoryWidget::slotSelection(QListViewItem *item)
{

}

void KmHistoryWidget::slotDoubleClicked(QListViewItem *item)
{
	KmConfig kmconf;
	kmconf.setHostname(item->text(0));
	kmconf.setArguments(item->text(1));

	emit sigReloadHostname();
	emit sigReloadArguments();
	emit sigAccept();
}

void KmHistoryWidget::Load()
{
	KmConfig kmconf;
	QStrList list = kmconf.getHistoryList();

        QString text;
	QString host;
	QString args;

	int pos;
	
	for (uint i = 0; i < list.count(); i++)
	{
		text = list.at(i);
		pos  = text.find(" ");

		if (pos != -1)
		{
			host = text.left(pos);
			args = text.remove(0, pos + 1);

			(void) new QListViewItem(histList, host, args);
		}
	}
}
void KmHistoryWidget::LoadDefaults()
{
	histList->clear();
}

void KmHistoryWidget::paintEvent( QPaintEvent *event )
{
	this->QWidget::paintEvent(event);
	histList->setGeometry(10, 10, width() - 20, height() - 20);

	int w_avg = (histList->width() - 20) / 3;

	histList->setColumnWidth(0, w_avg);
	histList->setColumnWidth(1, w_avg * 2);

}
