#include <qstring.h>
#include <qlist.h>
#include <kmsgbox.h>
#include <kapp.h>
#include <qmessagebox.h>

#include "CreateTable.h"
#include "tabledescr.h"
#include "mysqlw.h"
#include "globals.h"
#include "compoundkeydlg.h"

#ifndef rcsid
static const char rcsid[]="$Id: CreateTable.cpp,v 2.8 1999/08/07 19:33:11 ral Exp $";
const char*createtable_rcs(){return rcsid;}
#endif

#define Inherited CModifyTable

CCreateTable::CCreateTable( QWidget* parent, const char* name )
    :Inherited( parent, name )
{
    TableNameEdit = new QLineEdit(this);
    TableNameEdit->setGeometry( 280, 5, 210, 25 );
    TableNameEdit->setMinimumSize( 0, 0 );
    TableNameEdit->setMaximumSize( 32767, 32767 );
    TableNameEdit->setText( "" );
    TableNameEdit->setMaxLength( 32767 );
    TableNameEdit->setFrame( TRUE );
    TableNameEdit->setFocus();
    connect(TableNameEdit,SIGNAL(textChanged(const char*)),SLOT(TableTextChanged(const char*)));
    connect( CreateTableButton, SIGNAL(clicked()), SLOT(CreateTable()) );
    TopMostLayout->addWidget(TableNameEdit);
}


CCreateTable::~CCreateTable()
{

}

void CCreateTable::TableTextChanged(const char*text)
{
    bool how =  (text &&
		 strlen(text) &&
		 (CurrentTables.find(text) == 0) );
    ColumnNameEdit->setEnabled(how);
    AddButton->setEnabled( how && strlen(ColumnNameEdit->text()) );
}

void CCreateTable::TableTextActivate()
{
}

void CCreateTable::SetDBString(const char*text)
{
    CurrentTables.resize(0);
    stringlist * list = sql_server->get_table_list("%",DBList->currentText());
    if (list)
	CurrentTables = *list;
    TableTextChanged(TableNameEdit->text());
}

void CCreateTable::AddColumn()
{
    CKeyDescriptor Key;
    QString text;

    CColumnDescriptor Desc;
    Desc.set_name(ColumnNameEdit->text());
    if (desc_list.find(Desc)!=0) {
	QMessageBox::critical(this,i18n("Error inserting column"),
			      i18n("Enter another name for column!"));
	return;
    }
    if (Primary_Key->isEnabled() && Primary_Key->isChecked()) {
	Key.set_name("PRIMARY");
	if (key_list.find(Key)) {
	    QMessageBox::critical(this,i18n("Error inserting column"),
				  i18n("There is already a primary key"));
	    return;
	}
    }
    if (!ReadDescriptor(&Desc,&text,&Key))
	return;

    ColumnsList->clearSelection();
    ColumnsList->insertItem(text,-1);
    DeleteButton->setEnabled(FALSE);
    ModifyButton->setEnabled(FALSE);
    desc_list.push_back(Desc);
    CreateTableButton->setEnabled(TRUE);
    if (desc_list.size() > 1) {
	CompoundKeyButton->setEnabled(TRUE);
    }
    if (!Key_None->isChecked()) {
	key_list.push_back(Key);
    }
}

void CCreateTable::ColumnSelected(int Item)
{
    const char* ItemText = ColumnsList->text(Item);
    if (!ItemText)
	return;
    DeleteButton->setEnabled(TRUE);
    ModifyButton->setEnabled(TRUE);
    if (desc_list.size() <= (unsigned int)Item)
	return;
    ColumnNameEdit->setText(desc_list[Item].get_name());
    EnumList->clear();
    enums.clear();
    stringIlist e_list = desc_list[Item].enum_list();
    stringIlist::iterator iter = e_list.begin();
    enums = e_list;
    for (;iter!=e_list.end();++iter) {
	EnumList->insertItem(iter->c_str());
	if (iter == e_list.begin()) 
	    EnumList->setCurrentItem(0);
    }
    TypeComboList->setCurrentItem(desc_list[Item].get_FieldType());
    if (desc_list[Item].is_KeyField()) {
	
    }
}

void CCreateTable::Delete_Column()
{
    int Index = ColumnsList->currentItem();
    int counter = 0;
    if (Index == -1) {
	debug("index -1");
	return;
    }
    CColumnDescriptor desc;
    desc = desc_list[Index];
    RemoveFromKey(desc.get_name());
    ColumnsList->removeItem(Index);
    counter = 0;
    for (ColumnList_iterator col_iter = desc_list.begin();col_iter != desc_list.end();++col_iter) {
	if (counter == Index) {
	    desc_list.erase(col_iter);
	    break;
	}
	++counter;
    }
    if (desc_list.size() < 2) {
	CompoundKeyButton->setEnabled(FALSE);
    }
    if (ColumnsList->count() == 0) {
	CreateTableButton->setEnabled(FALSE);
    }
    if (ColumnsList->currentItem() == -1 || ColumnsList->count() == 0) {
	DeleteButton->setEnabled(FALSE);
	ModifyButton->setEnabled(FALSE);
    }
}

void CCreateTable::CreateTable()
{
    if (sql_server->create_table(DBList->currentText(),TableNameEdit->text(),&desc_list,&key_list) == -1) {
	QMessageBox::critical(this,"Error creating table",
			      i18n("Please look in the logwindow, whats going wrong"));
	return;
    }
    close();
}
