#include "MainApp.h"
#include <qkeycode.h>
#include <kmenubar.h>
#include <kapp.h>
#include <kiconloader.h>
#include <kwm.h>
#include <kfiledialog.h>
#include <qtstream.h>
#include <qmenudta.h>
#include <qpopmenu.h>
#include <qlayout.h>

#ifndef version_id
static char version_id[]="Version 0.32";
#endif

#ifndef rcsid
static const char rcsid[]="$Id: MainApp.cpp,v 2.6 1999/08/07 19:58:25 ral Exp $";
const char*mainapp_rcs(){return rcsid;}
#endif

#define Inherited KTopLevelWidget

CMainApp::CMainApp(const char* name)
	:Inherited( name )
{
    setCaption( "KMySqlAdmin" );
    int id;
    MenuBar = new KMenuBar(this);
    MainWidget = new CMainWindow( this, "MainWidget" );
    file = new QPopupMenu;
    file->insertItem(i18n("&Disconnect"),MainWidget,SLOT(disconnectSql()),CTRL+Key_D);
    file->insertItem(i18n("&Clear Output"),MainWidget,SLOT(clearOutput()));
    file->setCheckable(TRUE);
    logf = file->insertItem(i18n("&Log output to file"),this,SLOT(set_LogFileName()));
    file->insertSeparator();
    file->insertItem("&Quit",kapp,SLOT(quit()),CTRL+Key_Q);
    MenuBar->insertItem(i18n("&File"),file);
    db_menu = new QPopupMenu;
    id = db_menu->insertItem(i18n("Drop &Database..."));
    db_menu->connectItem(id,MainWidget,SLOT(drop_db()));
    id = db_menu->insertItem(i18n("Drop &Table..."));
    db_menu->connectItem(id,MainWidget,SLOT(drop_table()));
    db_menu->insertSeparator();
    id = db_menu->insertItem(i18n("&Flush host cache"));
    db_menu->connectItem(id,MainWidget,SLOT(flush_cache()));
    id = db_menu->insertItem(i18n("&Close open tables"));
    db_menu->connectItem(id,MainWidget,SLOT(close_tables()));
    id = db_menu->insertItem(i18n("&Begin new server log"));
    db_menu->connectItem(id,MainWidget,SLOT(new_log()));
    db_menu->insertSeparator();
    id = db_menu->insertItem(i18n("&Reload permissions"));
    db_menu->connectItem(id,MainWidget,SLOT(reload_grants()));
    id = db_menu->insertItem(i18n("&Shutdown server"));
    db_menu->connectItem(id,MainWidget,SLOT(shutdown()));
    MenuBar->insertItem(i18n("&Database"),db_menu);
    MenuBar->insertSeparator();
    QString about_string = i18n("MySQL Administrationtool\n");
#ifdef VersionID
    about_string+=VersionID;
#else
    about_string+=version_id;
#endif
    about_string+="\n\n";
    about_string+=i18n("written by Rajko Albrecht\n");
    about_string+=i18n("Aachen (FRG) 08.99");
    about_string+="\n\n";
    about_string+="Email: rajko.albrecht@informatik.tu-chemnitz.de\n";
    about_string+="WWW:   http://www.webeifer.de/alwin/Programs/KMySQLAdmin/index.html";
    QPopupMenu * m = kapp->getHelpMenu(true,
				       about_string);
    MenuBar->insertItem(i18n("&Help"),m);
    setMenu(MenuBar);
    KIconLoader iconload;
    QPixmap icon = iconload.loadIcon("kmysqladmin.xpm");
    setIcon(icon);
    connect(MainWidget,SIGNAL(connected()),this,SLOT(connected_to_server()));
    connect(MainWidget,SIGNAL(disconnected()),this,SLOT(disconnected_from_server()));
    KWM::setIcon(winId(),kapp->getIcon());
    KWM::setMiniIcon(winId(),kapp->getMiniIcon());

    MainWidget->setGeometry( 2, 2, 366, 186 );
    MainWidget->setMinimumSize( 370, 190 );
    MainWidget->setMaximumSize( 32767, 32767 );

    setView(MainWidget,FALSE);
    disconnected_from_server();
    setMinimumSize( 370, 190 );
    setMaximumSize( 32767, 32767 );
}


CMainApp::~CMainApp()
{
    filepointer.close();
}
  
void CMainApp::append_message(const char*text)
{
    if (text && strlen(text) != 0 ) {
	MainWidget->append_message(text);
	if (filepointer.isOpen()) {
	    QTextStream t( &filepointer );
	    t << text << "\n";
	    filepointer.flush();
	}
    }
}

void CMainApp::set_LogFileName()
{
    QString s;
    if (logfile.isEmpty()) {
	s = KFileDialog::getOpenFileName(0,"*.log");
	if (!s.isEmpty()) {
	    logfile = s;
	    filepointer.setName(s);
	    if (!filepointer.open(IO_WriteOnly | IO_Append))
		logfile = "";
	}
    }
    else {
	logfile = "";
	filepointer.close();
    }
    file->setItemChecked( logf,(logfile.isEmpty()?0:1) );
}

void CMainApp::disconnected_from_server()
{
    unsigned int i;
    int j;

    for (i = 0; i <= db_menu->count();i++) {
	j = db_menu->idAt(i);
	if (j > -1) {
	    db_menu->setItemEnabled(j,FALSE);
	}
    }
}

void CMainApp::connected_to_server()
{
    unsigned int i;
    int j;

    for (i = 0; i <= db_menu->count();i++) {
	j = db_menu->idAt(i);
	if (j > -1) {
	    db_menu->setItemEnabled(j,TRUE);
	}
    }
}
