//-*-Mode: C++;-*-
/***************************************************************************
                          stringlist.h  -  description                              
                             -------------------                                         
    begin                : Fri Jul 30 1999                                           
    copyright            : (C) 1999 by Rajko Albrecht                         
    email                : Rajko.Albrecht@informatik.tu-chemnitz.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

// $Id: stringlist.h,v 2.2 1999/08/03 20:52:42 ral Exp $


#ifndef STRINGLIST_H
#define STRINGLIST_H

#include "liste.h"
#include <string>

/**Implementation of a string-list
	with search functions
  *@author Rajko Albrecht
  */

// there is a problem with the operators += = etc. in the string classes of stl
// if the new string is NULL, it get a segfault, cause the straits.h did not 
// recover a NULL - pointer as a empty string :(((((

typedef my_vector<std::string> base_stringlist;

class stringlist:public base_stringlist
{
protected:
    iterator _search_pos;
public:
    iterator find(const std::string&,iterator start_pos = 0);
};

inline vector<std::string>::iterator stringlist::find(const std::string&what,iterator start_pos = 0)
{
    _search_pos = start_pos?start_pos:begin();
    for (;_search_pos<end();++_search_pos) {
	if (_search_pos->compare(what) == 0) {
	    return _search_pos;
	}
    }
    return 0;
}

class stringIlist : public stringlist {
public:
    iterator find(const std::string&,iterator start_pos = 0);
};

inline vector<std::string>::iterator stringIlist::find(const std::string&what,iterator start_pos = 0)
{
    _search_pos = start_pos?start_pos:begin();
    for (;_search_pos<end();++_search_pos) {
	if (strcasecmp(_search_pos->c_str(),what.c_str()) == 0) {
	    return _search_pos;
	}
    }
    return 0;
}

#endif
