/***************************************************************************
                                 KSqlLogon.cpp
                             -------------------
    begin                : 01.06.1999
    copyright            : (C) 1999 by Ullrich Wagner
    email                : Ullrich.Wagner@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kpixmap.h>
#include <qlayout.h>
#include <qstring.h>
#include <kmsgbox.h>
#include "ksqllogon.h"
#include "ksqlmain.h"
#include "ksqlmain.h"
#include "serverwork.h"
#include "korapic.xpm"

#include <qlabel.h>

KSqlLogon::KSqlLogon(QWidget* parent, const char* name) :
		KDialog( parent, name, TRUE, 1036288 )
{
	QPixmap picture((const char**) kora_xpm);
	setIcon(picture);

	QLabel* logonWLabel;
	logonWLabel = new QLabel( this, "logonWLabel" );
	logonWLabel->setGeometry( 10, 15, 540, 30 );
	logonWLabel->setMinimumSize( 540, 30 );
	logonWLabel->setMaximumSize( 32767, 30 );
	{
		QFont font( "Helvetica", 18, 75, 1 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		logonWLabel->setFont( font );
	}
	logonWLabel->setFocusPolicy( QWidget::NoFocus );
	logonWLabel->setBackgroundMode( QWidget::PaletteBackground );
	logonWLabel->setFontPropagation( QWidget::NoChildren );
	logonWLabel->setPalettePropagation( QWidget::NoChildren );
	logonWLabel->setFrameStyle( 0 );
	logonWLabel->setLineWidth( 1 );
	logonWLabel->setMidLineWidth( 0 );
	logonWLabel->QFrame::setMargin( 0 );
	logonWLabel->setText( i18n("Logon to ORACLE") );
	logonWLabel->setAlignment( 292 );
	logonWLabel->setMargin( -1 );

	QLabel* useridWLabel;
	useridWLabel = new QLabel( this, "useridWLabel" );
	useridWLabel->setGeometry( 10, 55, 60, 30 );
	useridWLabel->setMinimumSize( 60, 30 );
	useridWLabel->setMaximumSize( 32767, 30 );
	useridWLabel->setFocusPolicy( QWidget::NoFocus );
	useridWLabel->setBackgroundMode( QWidget::PaletteBackground );
	useridWLabel->setFontPropagation( QWidget::NoChildren );
	useridWLabel->setPalettePropagation( QWidget::NoChildren );
	useridWLabel->setFrameStyle( 0 );
	useridWLabel->setLineWidth( 1 );
	useridWLabel->setMidLineWidth( 0 );
	useridWLabel->QFrame::setMargin( 0 );
	useridWLabel->setText( i18n("User ID:") );
	useridWLabel->setAlignment( 289 );
	useridWLabel->setMargin( -1 );

	useridText = new QLineEdit( this, "useridWText" );
	useridText->setGeometry( 80, 55, 470, 30 );
	useridText->setMinimumSize( 440, 30 );
	useridText->setMaximumSize( 32767, 30 );
	useridText->setFocusPolicy( QWidget::StrongFocus );
	useridText->setBackgroundMode( QWidget::PaletteBase );
	useridText->setFontPropagation( QWidget::NoChildren );
	useridText->setPalettePropagation( QWidget::NoChildren );
	useridText->setText( "" );
	useridText->setMaxLength( 30 );
	useridText->setFrame( QLineEdit::Normal );
	useridText->setFrame( TRUE );

	QLabel* passwordWLabel;
	passwordWLabel = new QLabel( this, "passwordWLabel" );
	passwordWLabel->setGeometry( 10, 95, 60, 30 );
	passwordWLabel->setMinimumSize( 60, 30 );
	passwordWLabel->setMaximumSize( 32767, 30 );
	passwordWLabel->setFocusPolicy( QWidget::NoFocus );
	passwordWLabel->setBackgroundMode( QWidget::PaletteBackground );
	passwordWLabel->setFontPropagation( QWidget::NoChildren );
	passwordWLabel->setPalettePropagation( QWidget::NoChildren );
	passwordWLabel->setFrameStyle( 0 );
	passwordWLabel->setLineWidth( 1 );
	passwordWLabel->setMidLineWidth( 0 );
	passwordWLabel->QFrame::setMargin( 0 );
	passwordWLabel->setText( i18n("Password:") );
	passwordWLabel->setAlignment( 289 );
	passwordWLabel->setMargin( -1 );

	passwordText = new QLineEdit( this, "passwordWText" );
	passwordText->setGeometry( 80, 95, 470, 30 );
	passwordText->setMinimumSize( 440, 30 );
	passwordText->setMaximumSize( 32767, 30 );
	passwordText->setFocusPolicy( QWidget::StrongFocus );
	passwordText->setBackgroundMode( QWidget::PaletteBase );
	passwordText->setFontPropagation( QWidget::NoChildren );
	passwordText->setPalettePropagation( QWidget::NoChildren );
	passwordText->setText( "" );
	passwordText->setMaxLength( 30 );
	passwordText->setFrame( QLineEdit::Password );
	passwordText->setEchoMode(QLineEdit::Password);
	passwordText->setFrame( TRUE );

	QLabel* connectWLabel;
	connectWLabel = new QLabel( this, "connectWLabel" );
	connectWLabel->setGeometry( 10, 135, 60, 30 );
	connectWLabel->setMinimumSize( 60, 30 );
	connectWLabel->setMaximumSize( 32767, 30 );
	connectWLabel->setFocusPolicy( QWidget::NoFocus );
	connectWLabel->setBackgroundMode( QWidget::PaletteBackground );
	connectWLabel->setFontPropagation( QWidget::NoChildren );
	connectWLabel->setPalettePropagation( QWidget::NoChildren );
	connectWLabel->setFrameStyle( 0 );
	connectWLabel->setLineWidth( 1 );
	connectWLabel->setMidLineWidth( 0 );
	connectWLabel->QFrame::setMargin( 0 );
	connectWLabel->setText( i18n("Connect:") );
	connectWLabel->setAlignment( 289 );
	connectWLabel->setMargin( -1 );

	connectText = new QLineEdit( this, "connectWText" );
	connectText->setGeometry( 80, 135, 470, 30 );
	connectText->setMinimumSize( 440, 30 );
	connectText->setMaximumSize( 32767, 30 );
	connectText->setFocusPolicy( QWidget::StrongFocus );
	connectText->setBackgroundMode( QWidget::PaletteBase );
	connectText->setFontPropagation( QWidget::NoChildren );
	connectText->setPalettePropagation( QWidget::NoChildren );
	connectText->setText( "" );
	connectText->setMaxLength( 30 );
	connectText->setFrame( QLineEdit::Normal );
	connectText->setFrame( TRUE );

	logonButton = new QPushButton( this, "logonWButton" );
	logonButton->setGeometry( 10, 180, 100, 30 );
	logonButton->setMinimumSize( 100, 30 );
	logonButton->setMaximumSize( 100, 30 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		logonButton->setFont( font );
	}
	connect( logonButton, SIGNAL(clicked()), SLOT(logonButtonClickedCB()) );
	logonButton->setFocusPolicy( QWidget::TabFocus );
	logonButton->setBackgroundMode( QWidget::PaletteBackground );
	logonButton->setFontPropagation( QWidget::NoChildren );
	logonButton->setPalettePropagation( QWidget::NoChildren );
	logonButton->setText( i18n("Logon") );
	logonButton->setAutoRepeat( FALSE );
	logonButton->setAutoResize( FALSE );
	logonButton->setToggleButton( FALSE );
	logonButton->setDefault( TRUE );
	logonButton->setAutoDefault( FALSE );
	logonButton->setIsMenuButton( FALSE );

	exitButton = new QPushButton( this, "exitWButton" );
	exitButton->setGeometry( 450, 180, 100, 30 );
	exitButton->setMinimumSize( 100, 30 );
	exitButton->setMaximumSize( 100, 30 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		exitButton->setFont( font );
	}
	connect( exitButton, SIGNAL(clicked()), SLOT(exitButtonClickedCB()) );
	exitButton->setFocusPolicy( QWidget::TabFocus );
	exitButton->setBackgroundMode( QWidget::PaletteBackground );
	exitButton->setFontPropagation( QWidget::NoChildren );
	exitButton->setPalettePropagation( QWidget::NoChildren );
	exitButton->setText( i18n("Cancel") );
	exitButton->setAutoRepeat( FALSE );
	exitButton->setAutoResize( FALSE );
	exitButton->setToggleButton( FALSE );
	exitButton->setDefault( FALSE );
	exitButton->setAutoDefault( FALSE );
	exitButton->setIsMenuButton( FALSE );

	QBoxLayout* layout1 = new QBoxLayout( this, QBoxLayout::TopToBottom, 5, 5, "top" );
	layout1->addStrut( 0 );
	layout1->addSpacing( 10 );
	QBoxLayout* layout1_2 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "title" );
	layout1->addLayout( layout1_2, 1 );
	layout1_2->addStrut( 0 );
	layout1_2->addSpacing( 5 );
	layout1_2->addWidget( logonWLabel, 1, 36 );
	layout1_2->addSpacing( 5 );
	layout1->addSpacing( 5 );
	QBoxLayout* layout1_4 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "user" );
	layout1->addLayout( layout1_4, 1 );
	layout1_4->addStrut( 0 );
	layout1_4->addSpacing( 5 );
	layout1_4->addWidget( useridWLabel, 1, 36 );
	layout1_4->addSpacing( 5 );
	layout1_4->addWidget( useridText, 1, 36 );
	layout1_4->addSpacing( 5 );
	layout1->addSpacing( 5 );
	QBoxLayout* layout1_6 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "password" );
	layout1->addLayout( layout1_6, 1 );
	layout1_6->addStrut( 0 );
	layout1_6->addSpacing( 5 );
	layout1_6->addWidget( passwordWLabel, 1, 36 );
	layout1_6->addSpacing( 5 );
	layout1_6->addWidget( passwordText, 1, 36 );
	layout1_6->addSpacing( 5 );
	layout1->addSpacing( 5 );
	QBoxLayout* layout1_8 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "connect" );
	layout1->addLayout( layout1_8, 1 );
	layout1_8->addStrut( 0 );
	layout1_8->addSpacing( 5 );
	layout1_8->addWidget( connectWLabel, 1, 36 );
	layout1_8->addSpacing( 5 );
	layout1_8->addWidget( connectText, 1, 36 );
	layout1_8->addSpacing( 5 );
	layout1->addSpacing( 10 );
	QBoxLayout* layout1_10 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "buttons" );
	layout1->addLayout( layout1_10, 1 );
	layout1_10->addStrut( 0 );
	layout1_10->addSpacing( 5 );
	layout1_10->addWidget( logonButton, 1, 36 );
	layout1_10->addStretch( 10 );
	layout1_10->addWidget( exitButton, 1, 36 );
	layout1_10->addSpacing( 5 );
	layout1->addSpacing( 10 );
	resize( 560,225 );
	setMinimumSize( 560, 225 );
	setMaximumSize( 32767, 32767 );

	setCaption( i18n("ORACLE Logon") );
	useridText->setFocus();
}


KSqlLogon::~KSqlLogon()
{
}

void KSqlLogon::logonButtonClickedCB()
{
	QString	userId;
	QString	password;
	QString	connect;
	QString	oraMessage;
	QString	activeConnection;

	// get the data from the fields
	userId = useridText->text();
	password = passwordText->text();
	connect = connectText->text();

	// is userid or password empty ?
	if (userId.isEmpty() || password.isEmpty())
	{
		// one of the important fields for Logon are empty. So tell it
		KMsgBox::message(this, i18n("ORACLE Logon"), i18n("You have to provide UserId and Password. The Connect-String is optional."), KMsgBox::STOP);
	}
	else
	{
		// ok, the needed data is given.
		// logon to database
		if (ServerWork::connectToOracle(userId, password, connect, oraMessage))
		{
			// Der Logon zu Oracle konnte nicht vollzogen werden
			KMsgBox::message(this, i18n("Logon Error"), oraMessage, KMsgBox::STOP);
		}
		else
		{
			if (connect.isEmpty())
			{
				activeConnection = userId;
			}
			else
			{
				activeConnection = userId;
				activeConnection += "@";
				activeConnection += connect;
			}

			activeDb = activeConnection;

			// we are logged on. So we can exit the logon window
			this->close();
		}
	}
}
void KSqlLogon::exitButtonClickedCB()
{
	activeDb = "---";
	this->close();
}
