/***************************************************************************
                                 KSynonymViewer.cpp
                             -------------------
    begin                : 01.06.1999
    copyright            : (C) 1999 by Ullrich Wagner
    email                : Ullrich.Wagner@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpixmap.h>
#include <qlayout.h>
#include <kmsgbox.h>
#include "ksynonymviewer.h"
#include "serverwork.h"
#include "korapic.xpm"

KSynonymViewer::KSynonymViewer(QWidget* parent, const char* name) :
		KDialog( parent, name, TRUE, 1036288 )
{
	QString	oraMessage;

	QPixmap picture((const char**) kora_xpm);
	setIcon(picture);

	synonymListLabel = new QLabel( this, "synonymListWLabel" );
	synonymListLabel->setGeometry( 15, 10, 110, 20 );
	synonymListLabel->setMinimumSize( 110, 20 );
	synonymListLabel->setMaximumSize( 32767, 20 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		synonymListLabel->setFont( font );
	}
	synonymListLabel->setFocusPolicy( QWidget::NoFocus );
	synonymListLabel->setBackgroundMode( QWidget::PaletteBackground );
	synonymListLabel->setFontPropagation( QWidget::NoChildren );
	synonymListLabel->setPalettePropagation( QWidget::NoChildren );
	synonymListLabel->setFrameStyle( 0 );
	synonymListLabel->setLineWidth( 1 );
	synonymListLabel->setMidLineWidth( 0 );
	synonymListLabel->QFrame::setMargin( 0 );
	synonymListLabel->setText( i18n("List of Synonyms:") );
	synonymListLabel->setAlignment( 289 );
	synonymListLabel->setMargin( -1 );

	synonymList = new QListBox( this, "synonymWList" );
	synonymList->setGeometry( 15, 35, 440, 215 );
	synonymList->setMinimumSize( 440, 215 );
	synonymList->setMaximumSize( 32767, 32767 );
	connect( synonymList, SIGNAL(highlighted(int)), SLOT(synonymListClickedCB(int)) );
	synonymList->setFocusPolicy( QWidget::StrongFocus );
	synonymList->setBackgroundMode( QWidget::PaletteBase );
	synonymList->setFontPropagation( QWidget::SameFont );
	synonymList->setPalettePropagation( QWidget::SameFont );
	synonymList->setFrameStyle( 51 );
	synonymList->setLineWidth( 2 );
	synonymList->setMidLineWidth( 0 );
	synonymList->QFrame::setMargin( 0 );
	synonymList->setDragSelect( TRUE );
	synonymList->setAutoScroll( TRUE );
	synonymList->setScrollBar( FALSE );
	synonymList->setAutoScrollBar( TRUE );
	synonymList->setBottomScrollBar( FALSE );
	synonymList->setAutoBottomScrollBar( TRUE );
	synonymList->setSmoothScrolling( TRUE );
	synonymList->setMultiSelection( FALSE );
	synonymList->setAutoUpdate( TRUE );

	baseFrame = new QFrame( this, "baseWFrame" );
	baseFrame->setGeometry( 15, 260, 440, 70 );
	baseFrame->setMinimumSize( 410, 70 );
	baseFrame->setMaximumSize( 32767, 32767 );
	baseFrame->setFocusPolicy( QWidget::NoFocus );
	baseFrame->setBackgroundMode( QWidget::PaletteBackground );
	baseFrame->setFontPropagation( QWidget::NoChildren );
	baseFrame->setPalettePropagation( QWidget::NoChildren );
	baseFrame->setFrameStyle( 50 );
	baseFrame->setLineWidth( 2 );
	baseFrame->setMidLineWidth( 0 );
	baseFrame->QFrame::setMargin( 0 );

	tableOwnerLabel = new QLabel( baseFrame, "tableOwnerWLabel" );
	tableOwnerLabel->setGeometry( 15, 10, 85, 20 );
	tableOwnerLabel->setMinimumSize( 85, 20 );
	tableOwnerLabel->setMaximumSize( 32767, 20 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		tableOwnerLabel->setFont( font );
	}
	tableOwnerLabel->setFocusPolicy( QWidget::NoFocus );
	tableOwnerLabel->setBackgroundMode( QWidget::PaletteBackground );
	tableOwnerLabel->setFontPropagation( QWidget::NoChildren );
	tableOwnerLabel->setPalettePropagation( QWidget::NoChildren );
	tableOwnerLabel->setFrameStyle( 0 );
	tableOwnerLabel->setLineWidth( 1 );
	tableOwnerLabel->setMidLineWidth( 0 );
	tableOwnerLabel->QFrame::setMargin( 0 );
	tableOwnerLabel->setText( i18n("Table Owner:") );
	tableOwnerLabel->setAlignment( 289 );
	tableOwnerLabel->setMargin( -1 );

	tableOwnerText = new QLineEdit( baseFrame, "tableOwnerWText" );
	tableOwnerText->setGeometry( 105, 10, 100, 20 );
	tableOwnerText->setMinimumSize( 100, 20 );
	tableOwnerText->setMaximumSize( 100, 20 );
	tableOwnerText->setFocusPolicy( QWidget::StrongFocus );
	tableOwnerText->setBackgroundMode( QWidget::PaletteBase );
	tableOwnerText->setFontPropagation( QWidget::NoChildren );
	tableOwnerText->setPalettePropagation( QWidget::NoChildren );
	tableOwnerText->setText( "" );
	tableOwnerText->setMaxLength( 32767 );
	tableOwnerText->setFrame( QLineEdit::Normal );
	tableOwnerText->setFrame( TRUE );

	tableNameLabel = new QLabel( baseFrame, "tableNameWLabel" );
	tableNameLabel->setGeometry( 240, 10, 80, 20 );
	tableNameLabel->setMinimumSize( 80, 20 );
	tableNameLabel->setMaximumSize( 32767, 20 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		tableNameLabel->setFont( font );
	}
	tableNameLabel->setFocusPolicy( QWidget::NoFocus );
	tableNameLabel->setBackgroundMode( QWidget::PaletteBackground );
	tableNameLabel->setFontPropagation( QWidget::NoChildren );
	tableNameLabel->setPalettePropagation( QWidget::NoChildren );
	tableNameLabel->setFrameStyle( 0 );
	tableNameLabel->setLineWidth( 1 );
	tableNameLabel->setMidLineWidth( 0 );
	tableNameLabel->QFrame::setMargin( 0 );
	tableNameLabel->setText( i18n("Table Name:") );
	tableNameLabel->setAlignment( 289 );
	tableNameLabel->setMargin( -1 );

	tableNameText = new QLineEdit( baseFrame, "tableNameWText" );
	tableNameText->setGeometry( 325, 10, 100, 20 );
	tableNameText->setMinimumSize( 100, 20 );
	tableNameText->setMaximumSize( 100, 20 );
	tableNameText->setFocusPolicy( QWidget::StrongFocus );
	tableNameText->setBackgroundMode( QWidget::PaletteBase );
	tableNameText->setFontPropagation( QWidget::NoChildren );
	tableNameText->setPalettePropagation( QWidget::NoChildren );
	tableNameText->setText( "" );
	tableNameText->setMaxLength( 32767 );
	tableNameText->setFrame( QLineEdit::Normal );
	tableNameText->setFrame( TRUE );

	dbLinkLabel = new QLabel( baseFrame, "dbLinkWLabel" );
	dbLinkLabel->setGeometry( 15, 40, 85, 20 );
	dbLinkLabel->setMinimumSize( 85, 20 );
	dbLinkLabel->setMaximumSize( 32767, 20 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		dbLinkLabel->setFont( font );
	}
	dbLinkLabel->setFocusPolicy( QWidget::NoFocus );
	dbLinkLabel->setBackgroundMode( QWidget::PaletteBackground );
	dbLinkLabel->setFontPropagation( QWidget::NoChildren );
	dbLinkLabel->setPalettePropagation( QWidget::NoChildren );
	dbLinkLabel->setFrameStyle( 0 );
	dbLinkLabel->setLineWidth( 1 );
	dbLinkLabel->setMidLineWidth( 0 );
	dbLinkLabel->QFrame::setMargin( 0 );
	dbLinkLabel->setText( i18n("Database Link:") );
	dbLinkLabel->setAlignment( 289 );
	dbLinkLabel->setMargin( -1 );

	dbLinkText = new QLineEdit( baseFrame, "dbLinkWText" );
	dbLinkText->setGeometry( 105, 40, 320, 20 );
	dbLinkText->setMinimumSize( 300, 20 );
	dbLinkText->setMaximumSize( 32767, 20 );
	dbLinkText->setFocusPolicy( QWidget::StrongFocus );
	dbLinkText->setBackgroundMode( QWidget::PaletteBase );
	dbLinkText->setFontPropagation( QWidget::NoChildren );
	dbLinkText->setPalettePropagation( QWidget::NoChildren );
	dbLinkText->setText( "" );
	dbLinkText->setMaxLength( 32767 );
	dbLinkText->setFrame( QLineEdit::Normal );
	dbLinkText->setFrame( TRUE );

	closeButton = new QPushButton( this, "closeWButton" );
	closeButton->setGeometry( 355, 340, 100, 30 );
	closeButton->setMinimumSize( 100, 30 );
	closeButton->setMaximumSize( 100, 30 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		closeButton->setFont( font );
	}
	connect( closeButton, SIGNAL(clicked()), SLOT(closeButtonClickedCB()) );
	closeButton->setFocusPolicy( QWidget::TabFocus );
	closeButton->setBackgroundMode( QWidget::PaletteBackground );
	closeButton->setFontPropagation( QWidget::NoChildren );
	closeButton->setPalettePropagation( QWidget::NoChildren );
	closeButton->setText( i18n("Close") );
	closeButton->setAutoRepeat( FALSE );
	closeButton->setAutoResize( FALSE );
	closeButton->setToggleButton( FALSE );
	closeButton->setDefault( FALSE );
	closeButton->setAutoDefault( TRUE );
	closeButton->setIsMenuButton( FALSE );

	QBoxLayout* layout1 = new QBoxLayout( this, QBoxLayout::TopToBottom, 5, 5, "base" );
	layout1->addStrut( 0 );
	layout1->addSpacing( 5 );
	QBoxLayout* layout1_2 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "listbase" );
	layout1->addLayout( layout1_2, 1 );
	layout1_2->addStrut( 0 );
	layout1_2->addSpacing( 10 );
	layout1_2->addWidget( synonymListLabel, 1, 36 );
	layout1_2->addStretch( 10 );
	QBoxLayout* layout1_3 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "list" );
	layout1->addLayout( layout1_3, 10 );
	layout1_3->addStrut( 0 );
	layout1_3->addSpacing( 10 );
	layout1_3->addWidget( synonymList, 1, 36 );
	layout1_3->addSpacing( 10 );
	layout1->addSpacing( 5 );
	QBoxLayout* layout1_5 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "frame" );
	layout1->addLayout( layout1_5, 1 );
	layout1_5->addStrut( 0 );
	layout1_5->addSpacing( 10 );
	layout1_5->addWidget( baseFrame, 1, 36 );
	QBoxLayout* layout1_5_2 = new QBoxLayout( baseFrame, QBoxLayout::TopToBottom, 5, 5, "frameBase" );
	layout1_5_2->addStrut( 0 );
	layout1_5_2->addSpacing( 5 );
	QBoxLayout* layout1_5_2_2 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "row1" );
	layout1_5_2->addLayout( layout1_5_2_2, 1 );
	layout1_5_2_2->addStrut( 0 );
	layout1_5_2_2->addSpacing( 10 );
	layout1_5_2_2->addWidget( tableOwnerLabel, 1, 36 );
	layout1_5_2_2->addWidget( tableOwnerText, 1, 36 );
	layout1_5_2_2->addStretch( 10 );
	layout1_5_2_2->addWidget( tableNameLabel, 1, 36 );
	layout1_5_2_2->addWidget( tableNameText, 1, 36 );
	layout1_5_2_2->addSpacing( 10 );
	layout1_5_2->addSpacing( 5 );
	QBoxLayout* layout1_5_2_4 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "row2" );
	layout1_5_2->addLayout( layout1_5_2_4, 1 );
	layout1_5_2_4->addStrut( 0 );
	layout1_5_2_4->addSpacing( 10 );
	layout1_5_2_4->addWidget( dbLinkLabel, 1, 36 );
	layout1_5_2_4->addWidget( dbLinkText, 10, 36 );
	layout1_5_2_4->addSpacing( 10 );
	layout1_5_2->addSpacing( 5 );
	layout1_5->addSpacing( 10 );
	layout1->addSpacing( 5 );
	QBoxLayout* layout1_7 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "button" );
	layout1->addLayout( layout1_7, 1 );
	layout1_7->addStrut( 0 );
	layout1_7->addStretch( 10 );
	layout1_7->addWidget( closeButton, 1, 36 );
	layout1_7->addSpacing( 10 );
	layout1->addSpacing( 5 );
	resize( 470,380 );
	setMinimumSize( 450, 460 );
	setMaximumSize( 32767, 32767 );

	setCaption( i18n("View Synonyms") );

	KApplication::setOverrideCursor(waitCursor);
	// fill the Listbox of the synonyms and get the additional data
	if (ServerWork::fillSynonymList(synonymList, oraMessage))
	{
		// an error occured
		KApplication::restoreOverrideCursor();
		KMsgBox::message(this, i18n("Oracle Error"), oraMessage, KMsgBox::STOP);
	}

	KApplication::restoreOverrideCursor();
}


KSynonymViewer::~KSynonymViewer()
{
}

void KSynonymViewer::synonymListClickedCB(int item)
{
	QString	tableOwner;
	QString	tableName;
	QString	dbLink;

	if (!ServerWork::getSynonymData(item, tableOwner, tableName, dbLink))
	{
		KMsgBox::message(this, i18n("Synonym Error"), i18n("Unable to find data for the specified synonym"), KMsgBox::STOP);
		return;
	}

	// ok, we have the data fill them into the fields
	tableOwnerText->setText(tableOwner);
	tableNameText->setText(tableName);
	dbLinkText->setText(dbLink);
}

void KSynonymViewer::closeButtonClickedCB()
{
	this->close();
}
