#ifndef K_STRLIST_H
#define K_STR_LIST_H

#include "kstring.h"
#include "klist.h"

//typedef KList<KString> KStrList;

class KStrList : public KList<KString>
{
	public:
	KStrList(): KList() {};
	KStrList(const KStrList& l): KList(l) {};
	KStrList(const KString& e): KList(e) {};

	void setAutoDelete(bool enable)
	{
		if (!enable)
		{
			// we cannot use virtual delete. But that doesn't matter
		}
		else
		{
			// nothing to do. STL always uses real delete
		}
	}

	void append(const KString& item)
	{
		this->push_back(item);
	}

	int count() const
	{
		return this->size();
	}

	KString* at(int index)
	{
		static KString	result;
		KStrList	locList;
		int	count = 0;
		KStrList::iterator iter;

		locList = *this;

		forIterator(iter, locList)
		{
			if (count == index)
			{
				result = *iter;
				return &result;
			}
			else
			{
				count++;
			}
		}

		// we are still here. So the item couldn't be found.
		return NULL;
	}
};


#endif // K_STRLIST_H
