/***************************************************************************
                          dokvokfigure.h  -  description
                             -------------------
    begin                : Tue Feb 8 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DOKVOKFIGURE_H
#define DOKVOKFIGURE_H

#include <qlabel.h> 
#include <qtimer.h>

#include <kpixmap.h>

/**
  *@author Friedrich W. H. Kossebau
  */

class DokVokFigure : public QLabel  {
   Q_OBJECT

  public: 
  	DokVokFigure(QWidget *parent=0, const char *name=0);
  	~DokVokFigure() {}
    void lookRight() { setPixmap( *DokVokRight ); Timer->start( 2 * 1000, true ); }
    void lookWrong() { setPixmap( *DokVokWrong ); Timer->start( 2 * 1000, true ); }
    
  public slots:
    void lookNormal() { setPixmap( *DokVokSmiling ); emit looksNormalAgain(); }

  signals:
     void looksNormalAgain();      	  	
  private:
    KPixmap *DokVokSmiling;
    KPixmap *DokVokRight;
    KPixmap *DokVokWrong;
    
    // timer to end reporting
    QTimer *Timer;
        
};


#endif
