/***************************************************************************
                          vlanguage.cpp  -  description
                             -------------------
    begin                : Thu Mar 23 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qdir.h>
 
#include <kapp.h> 
 
#include "vlanguage.h"
#include "File/vlangfile.h"


VLanguageList::VLanguageList( bool NoLanguage = true )
{
  setAutoDelete( true );
  reset(NoLanguage);
}


VLanguageList::~VLanguageList()
{
}


void VLanguageList::write()
{
  VLanguage *Language;
  VLanguageFile *LanguageFile;
  
  for( Language=first(); Language; Language=next() )
  {
    LanguageFile = new VLanguageFile( Language->Short, false );
    
    LanguageFile->writeFont( Language->Font );
    LanguageFile->writeName( Language->Name );
    LanguageFile->writeTypInfoList( Language->TypInfoList );
    LanguageFile->writeFile();
    
    delete LanguageFile;
  }
}


void VLanguageList::reset( bool NoLanguage = true )
{
  clear();
  
  QFont Font;
  VTypInfoList TypInfoList;
  if( NoLanguage )
  {
    VLanguage Language = { i18n("No language"), "", Font, TypInfoList };
    append( new VLanguage(Language) );
  }
  
  // get all language files
  QDir Directory( KApplication::localkdedir().copy() + "/share/apps/dokvok/languages" );
  Directory.setNameFilter( "*.dvlc" );
  Directory.setSorting( QDir::Name );
  
  // prepare all needed variables
  VLanguageFile *LanguageFile;
  QString Name;
  const QFileInfoList *FileList = Directory.entryInfoList();
  QFileInfoListIterator Iterator( *FileList );      
  QFileInfo *FileInfo;                          
  
  // read all language names
  while ( (FileInfo=Iterator.current()) ) 
  {                                    
    LanguageFile = new VLanguageFile( FileInfo->baseName() );
    
    // is it a language?
    if( (Name = LanguageFile->name()) )
    { 
      Font = LanguageFile->font();
      TypInfoList = LanguageFile->typInfoList();
      VLanguage Language = { Name, FileInfo->baseName(), Font, TypInfoList };
      append( new VLanguage(Language) );
    }
    
    delete LanguageFile;
    
    ++Iterator;
  }
}

VLanguage *VLanguageList::appendNew( QString Short )
{
  QFont Font;
  VTypInfoList TypInfoList;
  VLanguage Language = { i18n("New language"), Short , Font, TypInfoList };
  VLanguage *NewLanguage = new VLanguage(Language);
  
  if( NewLanguage )
  {
    append( NewLanguage );
    return NewLanguage;
  }
  
  return 0L;
}

