#ifndef __EAGROUPBOX__H__
#define __EAGROUPBOX__H__

/////////////////////////////////////////////////////////////////////////////
//
// A QGroupBox like box with title, optional a checkbox and a peer window 
// inside
//
/////////////////////////////////////////////////////////////////////////////

// taken from kppp

#include <qframe.h>
#include <qcheckbox.h>
#include <qradiobutton.h>

#define VIRTUAL virtual

//#include "widget/DlgWidget.h"

class EAGroupBoxBase : public QFrame {
  Q_OBJECT
public:
  EAGroupBoxBase(QWidget *parent = 0, const char *name = 0);

  inline QWidget *peer() const { return _peer; }

  void setTitleWidget(QWidget *title);

  VIRTUAL void  resizeEvent(QResizeEvent *);
  VIRTUAL QSize minimumSize() const;
  VIRTUAL QSize maximumSize() const;
  VIRTUAL QSize sizeHint()    const;

protected:
  void initBox();

  QRect frect;
  QWidget *_title;
  QWidget *_peer;
};

class EAGroupBox : public EAGroupBoxBase {
  Q_OBJECT
public:
  EAGroupBox(const char *title, QWidget *parent = 0, const char *name = 0);

  void setTitle(EA_QTSTR title);
};


class EACheckGroupBox : public EAGroupBoxBase {
  Q_OBJECT
public:
  EACheckGroupBox(const char *title, QWidget *parent = 0, const char *name = 0);

  void setTitle(EA_QTSTR  title);
  bool isChecked();
  void setChecked(bool);

  QCheckBox *getCheckBox() { return cbox; }

private slots:
  void slot_toggled(bool);

signals:
  void toggled(bool);

private:
  QCheckBox *cbox;
};


class EARadioGroupBox : public EAGroupBoxBase {
  Q_OBJECT
public:
  EARadioGroupBox(const char *title, QWidget *parent = 0, const char *name = 0);

  void setTitle(EA_QTSTR  title);
  bool isChecked();

private slots:
  void slot_toggled(bool);

signals:
  void toggled(bool);

private:
  QRadioButton *rb;
};

#endif
