/***************************************************************************
           PasteOptPage.cpp  -  clipboard options dialog page
                         -------------------
    begin                : Sun Jun 27 11:07:24 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#define Inherited PasteOptPageData

#include <qkeycode.h>

#include <iostream.h>

#include <kapp.h>

#include "langset.h"
#include "kvoctraindoc.h"
#include "PasteOptPage.h"
#include "GeneralOptionsDlg.h"

static const char *separator_name[] = {
  ";",              // 0
  "#",              // 1
  "!",              // 2
  "|",              // 3
  ",",              // 4
  "TAB",            // 5
  ">= 2 SPACES",    // 6
  " : ",            // 7
  " :: ",           // 8
  0
};


static const char *separator_id[] = {
  ";",              // 0
  "#",              // 1
  "!",              // 2
  "|",              // 3
  ",",              // 4
  "\t",             // 5
  "  ",             // 6
  " : ",            // 7
  " :: ",           // 8
  0
};


PasteOptPage::PasteOptPage
(
        QString       _sep,
        LangSet      &_langset,
        QStrList     &paste_list,
        kvoctrainDoc *_doc,
	QWidget      *parent,
	const char   *name
)
	:
	Inherited( parent, name ),
        langset(_langset),
        doc(_doc)
{
  setCaption(i18n("Options" ));
  sep = _sep;

  separator_name[5] = i18n("TAB");
  separator_name[6] = i18n(">= 2 SPACES");

  int sel = 0;
  const char **seps = separator_name;
  const char **sepid = separator_id;
  while (*seps) {
    if (*sepid == sep)
      sel = seps - separator_name;
    d_sep->insertItem (*seps);
    seps++;
    sepid++;
  }
  d_sep->setSizeLimit( seps - separator_name );
  d_sep->setCurrentItem(sel);
  label_sep->setBuddy(d_sep);

  order_list->clear();
  for (int i = 0; i < (int) paste_list.count(); i++)
    order_list->insertItem (langset.findLongId(paste_list.at(i)));

  // any new languages to add to order-list ?
  for (int i = 0; i < (int) langset.size(); i++) {
    bool found = false;
    for (int j = 0; j < (int) order_list->count(); j++)
      if (order_list->text(j) == langset.longId(i))
        found = true;

    if (!found)
      order_list->insertItem(langset.longId(i));
  }

  order_list->setCurrentItem (0);
  label_order->setBuddy(order_list);
}


void PasteOptPage::initFocus() const
{
  d_sep->setFocus();
}


void PasteOptPage::slotSyncLangSet(EA_QTSTR dlg_name)
{
  // skip "skip" elements at tail
  if (strcmp (dlg_name, _OptDlg_CLIPBOARD) == 0) {
    // order_list contains elements unknown in language set? remove them
    for (int i = (int) order_list->count()-1; i >=0; i--) {
      if (!QString (order_list->text(i)).isEmpty())
        if (langset.indexLongId(order_list->text(i)) < 0) {
          order_list->removeItem(i);
        }
    }
    // language set contains new elements? append them
    for (int i = 0; i < (int) langset.size(); i++) {
      bool found = false;
      for (int j = 0; j < (int) order_list->count(); j++)
        if (langset.longId(i) == order_list->text(j))
          found = true;

      if (!found) {
        order_list->insertItem (langset.longId(i));
      }
    }
  }

  int i;
  for (i = (int) order_list->count()-1;
       i >= 0 && QString(order_list->text(i)).isEmpty();
       i--)
   order_list->removeItem(i);
}


void PasteOptPage::slotSelectSep(int idx)
{
  sep = separator_id[idx];
}


QStrList PasteOptPage::getPasteOrder()
{
  slotSyncLangSet(_OptDlg_CLIPBOARD);
  QStrList sl;
  // skip "skip" elements at tail
  int i;
  for (i = (int) order_list->count()-1;
       i >= 0 && QString(order_list->text(i)).isEmpty();
       i--);

  // insert language codes and "skips" between them
  for ( /**/; i >= 0; i--) {
    if (QString(order_list->text(i)).isEmpty())
     sl.insert (0, "");
    else
     sl.insert (0, langset.findShortId(order_list->text(i)));

  }
  return sl;
}


void PasteOptPage::slotItemSkip()
{
  int pos = order_list->currentItem();
  order_list->insertItem("", order_list->currentItem());
  order_list->setCurrentItem(pos);
  slotSyncLangSet(_OptDlg_CLIPBOARD);
}


void PasteOptPage::slotItemUp()
{
  if (order_list->currentItem() > 0
      && (int) order_list->count() > 1) {
    int pos = order_list->currentItem();
    QString item = order_list->text(pos);
    order_list->removeItem(pos);
    order_list->insertItem(item, pos-1);
    order_list->setCurrentItem(pos-1);
    slotSyncLangSet(_OptDlg_CLIPBOARD);
  }
}


void PasteOptPage::slotItemDown()
{
  if ((int)order_list->currentItem() < (int)order_list->count()-1
      && (int) order_list->count() >  1) {
    int pos = order_list->currentItem();
    QString item = order_list->text(pos);
    order_list->removeItem(pos);
    order_list->insertItem(item, pos+1);
    order_list->setCurrentItem(pos+1);
    slotSyncLangSet(_OptDlg_CLIPBOARD);
  }
}


void PasteOptPage::slotCurrentDoc()
{
  order_list->clear();
  order_list->insertItem (langset.findLongId(doc->getOriginalIdent()));
  for (int i = 1; i < (int) doc->numLangs(); i++)
    order_list->insertItem (langset.findLongId(doc->getIdent(i)));

  // any other languages to append besides those from doc?
  for (int i = 0; i < (int) langset.size(); i++) {
    bool found = false;
    for (int j = 0; j < (int) order_list->count(); j++)
      if (order_list->text(j) == langset.longId(i))
        found = true;

    if (!found)
      order_list->insertItem(langset.longId(i));
  }

  order_list->setCurrentItem (0);
}


PasteOptPage::~PasteOptPage()
{
}


void PasteOptPage::keyPressEvent( QKeyEvent *e )
{
   if (e->state() & AltButton & ControlButton & ShiftButton == 0) {
     if (  e->key() == Key_Escape )
       emit reject();
     else if (  e->key() == Key_Enter
              ||e->key() == Key_Return)
       emit accept();
     else
       e->ignore();
   }
   else
     e->ignore();
}
