/***************************************************************************
                       ViewOptPage.h  - viewing options
                             -------------------
    begin                : Fri Sep 10 16:42:01 1999

    copyright            : (C) 1999,2000 by Ewald Arnold
    email                : ewald@ewald-arnold.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef ViewOptPage_included
#define ViewOptPage_included

#include "ViewOptPageData.h"

#include "kvoctrainexpr.h"
#include <kfontdialog.h>

class QueryManager;

class ViewOptPage : public ViewOptPageData
{
    Q_OBJECT

public:

    ViewOptPage
    (
        QFont        &_font,
        GradeCols    &cols,
        QueryManager *manager,
        QWidget      *parent = NULL,
        const char   *name = NULL
    );

    virtual ~ViewOptPage();

    QFont     getFont()       const { return font; }
    GradeCols getGradeCols()  const { return gc; }

protected:
    void keyPressEvent( QKeyEvent * );

public slots:
    virtual void initFocus() const;

protected slots:
    virtual void slotChooseFont();
    virtual void slotCol0(const QColor&);
    virtual void slotCol1(const QColor&);
    virtual void slotCol2(const QColor&);
    virtual void slotCol3(const QColor&);
    virtual void slotCol4(const QColor&);
    virtual void slotCol5(const QColor&);
    virtual void slotCol6(const QColor&);
    virtual void slotCol7(const QColor&);
    virtual void slotColUsed(bool used);


protected:
    GradeCols     gc;
    QFont         font;
};
#endif // ViewOptPage_included
