/***************************************************************************
                      StatistikPage.cpp  -  statistics dialog page
                             -------------------                                         
    begin                : Thu Sep 21 20:50:53 MET 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "StatistikPage.h"

#define Inherited StatistikPageData

#include <qpainter.h>

#include <kpopmenu.h>
#include <kapp.h>

#include "kvoctraindoc.h"

#define PIX_SHIFT          2
#define SIZE_GRADE         100+PIX_SHIFT
#define SIZE_COUNT         70
#define SIZE_LESSON        300

#define TB_FGRADE          0
#define TB_TGRADE          1
#define TB_COUNT           2
#define TB_LESSON          3


int StatistikPage::calc_width (struct StatistikPage::stat_counter *gc,
                               int grade, int max_width)
{
  long int n = 0;
  for (int i = 0; i <= KV_MAX_GRADE; i++) {
    n += gc->grade[i];
  }

  if (n != 0) {
    return gc->grade[grade] * max_width / n;
  }
  else {
    return 0;
  }
}


StatistikPage::StatistikPage
(
        int            col,
        kvoctrainDoc  *_doc,
        GradeCols     *_gcol,
	QWidget       *parent,
	const char    *name
)
	:
	Inherited( parent, name ),
        doc(_doc),
        gcol(_gcol)
{

   lessonbox->setNumCols(4);
   lessonbox->setColumn(TB_FGRADE, i18n("Grade FROM"), SIZE_GRADE+10, KTabListBox::PixmapColumn);
   lessonbox->setColumn(TB_TGRADE, i18n("Grade TO"), SIZE_GRADE+10, KTabListBox::PixmapColumn);
   lessonbox->setColumn(TB_COUNT,  i18n("Entries"), SIZE_COUNT, KTabListBox::PixmapColumn);
   lessonbox->setColumn(TB_LESSON, i18n("Lesson"), SIZE_LESSON);

/*
   lessonbox->readConfig();
   if ( lessonbox->columnWidth(0) == 60 ) {
     lessonbox->setColumnWidth( TB_FGRADE, SIZE_GRADE );
     lessonbox->setColumnWidth( TB_TGRADE, SIZE_GRADE );
     lessonbox->setColumnWidth( TB_COUNT,  SIZE_COUNT );
     lessonbox->setColumnWidth( TB_LESSON, lessonbox->width()-SIZE_GRADE-SIZE_GRADE );
   }
*/
   vector<QString> lesson = doc->getLessonDescr();

   fsc.resize(lesson.size()+1);
   tsc.resize(lesson.size()+1);

   // accumulate numbers of grades per lesson
   for (int i = 0; i < (int) doc->numEntries(); i++) {
     kvoctrainExpr *expr = doc->getEntry(i);
     int fg = QMIN(KV_MAX_GRADE, expr->getGrade(col, false));
     int tg = QMIN(KV_MAX_GRADE, expr->getGrade(col, true));
     int l = expr->getLesson();
     if (l >= 0 && l <= (int) lesson.size() ) {
       fsc[l].grade[fg]++;
       fsc[l].num++;
       tsc[l].grade[tg]++;
       tsc[l].num++;
     }
   }
   setupPixmaps();
   connect (lessonbox, SIGNAL(popupMenu(int, int)), this, SLOT(slotPopupMenu(int,int)));
}


void StatistikPage::setupPixmaps()
{
   // create pixmaps with bar charts of numbers of grades
   int height = lessonbox->cellHeight(0);
   for (int entry = 0; entry < (int) fsc.size(); entry++) {
     QPainter p;
     QColor color;
     QPixmap fpix (SIZE_GRADE, height);
     p.begin( &fpix);
     p.eraseRect (0, 0, fpix.width(), fpix.height());
     p.setPen( black );
     int x = 0;
     int x2 = 0;
     if (fsc[entry].num != 0) {
       for (int j = 0; j <= KV_MAX_GRADE; j++) {
         switch (j) {
           case KV_NORM_GRADE: color = gcol->col0;    break;
           case KV_LEV1_GRADE: color = gcol->col1;    break;
           case KV_LEV2_GRADE: color = gcol->col2;    break;
           case KV_LEV3_GRADE: color = gcol->col3;    break;
           case KV_LEV4_GRADE: color = gcol->col4;    break;
           case KV_LEV5_GRADE: color = gcol->col5;    break;
           case KV_LEV6_GRADE: color = gcol->col6;    break;
           case KV_LEV7_GRADE: color = gcol->col7;    break;
           default           : color = gcol->col1;
         }
         x2 += calc_width (&fsc[entry], j, fpix.width()-PIX_SHIFT);
         if (j == KV_MAX_GRADE) {
           p.fillRect(x+PIX_SHIFT, 1, (fpix.width()-PIX_SHIFT)-x, height-1, color);
           p.drawRect(x+PIX_SHIFT, 1, (fpix.width()-PIX_SHIFT)-x, height-1);
         }
         else {
           p.fillRect(x+PIX_SHIFT, 1, x2-x, height-1, color);
           p.drawRect(x+PIX_SHIFT, 1, x2-x, height-1);
         }
         x = x2;
       }
     }
     else {
       p.fillRect(PIX_SHIFT, 1, fpix.width()-1-PIX_SHIFT, height-1, gcol->col0);
       p.drawRect(PIX_SHIFT, 1, fpix.width()-1-PIX_SHIFT, height-1);
     }
     p.end();
     from_pix.push_back(fpix);

     QPixmap tpix (SIZE_GRADE, height);
     p.begin( &tpix );
     p.eraseRect (0, 0, tpix.width(), tpix.height());
     p.setPen( black );
     x = 0;
     x2 = 0;
     if (tsc[entry].num != 0) {
       for (int j = 0; j <= KV_MAX_GRADE; j++) {
         switch (j) {
           case KV_NORM_GRADE: color = gcol->col0;    break;
           case KV_LEV1_GRADE: color = gcol->col1;    break;
           case KV_LEV2_GRADE: color = gcol->col2;    break;
           case KV_LEV3_GRADE: color = gcol->col3;    break;
           case KV_LEV4_GRADE: color = gcol->col4;    break;
           case KV_LEV5_GRADE: color = gcol->col5;    break;
           case KV_LEV6_GRADE: color = gcol->col6;    break;
           case KV_LEV7_GRADE: color = gcol->col7;    break;
           default           : color = gcol->col1;
         }
         x2 += calc_width (&tsc[entry], j, tpix.width()-PIX_SHIFT);
         if (j == KV_MAX_GRADE) {
           p.fillRect(x+PIX_SHIFT, 1, (tpix.width()-PIX_SHIFT)-x, height-1, color);
           p.drawRect(x+PIX_SHIFT, 1, (tpix.width()-PIX_SHIFT)-x, height-1);
         }
         else {
           p.fillRect(x+PIX_SHIFT, 1, x2-x, height-1, color);
           p.drawRect(x+PIX_SHIFT, 1, x2-x, height-1);
         }
         x = x2-1;
       }
     }
     else {
       p.fillRect(PIX_SHIFT, 1, tpix.width()-1-PIX_SHIFT, height-1, gcol->col0);
       p.drawRect(PIX_SHIFT, 1, tpix.width()-1-PIX_SHIFT, height-1);
     }
     p.end();
     to_pix.push_back(tpix);
   }

   // setup rows with pixmap names and strings
   vector<QString> lesson = doc->getLessonDescr();

   QString data, s;
   s.setNum (0);
   s.insert(0, "fgrade");
   data = s + "\n";
   lessonbox->dict().insert(s, &from_pix[0]);

   s.setNum (0);
   s.insert(0, "tgrade");
   data += s + "\n";
   lessonbox->dict().insert(s, &to_pix[0]);

   s.setNum (tsc[0].num);
   data += s + "\n";

   data += i18n("<no lesson>");
   data += "\n";

   lessonbox->appendItem (data);
   for (int i = 0; i < (int) lesson.size(); i++) {
     s.setNum (i+1);
     s.insert(0, "fgrade");
     data = s + "\n";
     lessonbox->dict().insert(s, &from_pix[i+1]);

     s.setNum (i+1);
     s.insert(0, "tgrade");
     data += s + "\n";
     lessonbox->dict().insert(s, &to_pix[i+1]);

     s.setNum (tsc[i+1].num);
     data += s + "\n";

     data += lesson[i];
     data += "\n";
     lessonbox->appendItem (data);
   }
}


void StatistikPage::slotPopupMenu(int row, int col)
{
  struct stat_counter *sc;

  if (col == TB_FGRADE) {
    if (row >= (int) fsc.size() ) {
      cerr << "row >= fsc.size()" << endl;
      return;
    }
    else
      sc = &fsc[row];
  }
  else if (col == TB_TGRADE) {
    if (row >= (int) tsc.size() ) {
      cerr << "row >= tsc.size()" << endl;
      return;
    }
    else
      sc = &tsc[row];
  }
  else
    return;

  KPopupMenu *header_m = new KPopupMenu(i18n("Number of entries per grade"));
  header_m->insertSeparator();
  QString s;

  s.setNum (sc->grade[KV_NORM_GRADE]);
  s.insert(0, "\t");
  s.insert(0, KV_NORM_TEXT);
  header_m->insertItem (s);

  s.setNum (sc->grade[KV_LEV1_GRADE]);
  s.insert(0, "\t");
  s.insert(0, KV_LEV1_TEXT);
  header_m->insertItem (s);

  s.setNum (sc->grade[KV_LEV2_GRADE]);
  s.insert(0, "\t");
  s.insert(0, KV_LEV2_TEXT);
  header_m->insertItem (s);

  s.setNum (sc->grade[KV_LEV3_GRADE]);
  s.insert(0, "\t");
  s.insert(0, KV_LEV3_TEXT);
  header_m->insertItem (s);

  s.setNum (sc->grade[KV_LEV4_GRADE]);
  s.insert(0, "\t");
  s.insert(0, KV_LEV4_TEXT);
  header_m->insertItem (s);

  s.setNum (sc->grade[KV_LEV5_GRADE]);
  s.insert(0, "\t");
  s.insert(0, KV_LEV5_TEXT);
  header_m->insertItem (s);

  s.setNum (sc->grade[KV_LEV6_GRADE]);
  s.insert(0, "\t");
  s.insert(0, KV_LEV6_TEXT);
  header_m->insertItem (s);

  s.setNum (sc->grade[KV_LEV7_GRADE]);
  s.insert(0, "\t");
  s.insert(0, KV_LEV7_TEXT);
  header_m->insertItem (s);

  header_m->exec(QCursor::pos()+QPoint(10, 0));
}


StatistikPage::~StatistikPage()
{
  lessonbox->writeConfig();
}
