/***************************************************************************
                          kship.h  -  description                              
                             -------------------                                         
    begin                : Tue Aug 3 1999                                           
    copyright            : (C) 1999 by pradu                         
    email                : pradu@geocities.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KSHIP_H
#define KSHIP_H

#include <qobject.h>
#include <qpoint.h>

/**this class is used to represent a ship
on the battle field
  *@author pradu
  */

class KShip : public QObject  {
	Q_OBJECT
	
public:
	enum direction {NS,WE};

	KShip(int size, int _dir, const QPoint &p);
  /**  */
  bool outOfBounds();
	~KShip();

  /** returns true if the point belongs to the ship (to test for 'sea' or 'hit' */
  bool hitTest(QPoint &P);
  /**  */
  void paint(QPainter *p);
  /**  */
  bool intersects(const KShip *) const;
  /**  */
  bool destroyed();

protected:
	int dir;
	int size;
	int hits;
	QRect base;

};

#endif

















