/***************************************************************************
                          ccharacterprofile.cpp
                           -------------------
    description          : Character Profile Class
    begin                : Sun Oct 17 1999
    copyright            : (C) 1999 by Stephan Uhlmann
    email                : suhlmann@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ccharacterprofile.h"


CCharacterProfile::CCharacterProfile(){
	filename="";
	loggingEnabled=false;
	logFilename="";
}

CCharacterProfile::~CCharacterProfile(){
}

QString CCharacterProfile::getFileName()
{
	return filename;
}

void CCharacterProfile::setFileName(QString f)
{
	filename=f;
}

void CCharacterProfile::readData()
{
	KSimpleConfig mudconf(QDir::homeDirPath()+"/.kde/share/apps/kmud/profiles/"+filename);

	mudconf.setGroup("Logging");
	loggingEnabled = mudconf.readBoolEntry("LoggingEnabled",false);
	logANSIEnabled = mudconf.readBoolEntry("LogANSIEnabled",false);
	logFilename = mudconf.readEntry("LogFilename","");
	
	mudconf.setGroup("Mapper");
	map_start_x = mudconf.readNumEntry("StartX",-2);
	map_start_y = mudconf.readNumEntry("StartY",-2);
	map_start_level = mudconf.readNumEntry("StartLevel",0);

	readAliases();
	readTriggers();
}

void CCharacterProfile::readAliases()
{
	AliasEntry* alias;
	QString groupname, n, d, m, tmp;
	QString mod;
	KSimpleConfig aliasdb(QDir::homeDirPath()+"/.kde/share/apps/kmud/profiles/"+filename);
	KGroupIterator *gi;
	uint i = 0;

	aliases.setAutoDelete(true);
	aliases.clear();

	gi = aliasdb.groupIterator();
	gi->toFirst();

	while (gi->current())
	{
		groupname = gi->currentKey();

		if (groupname == "Aliases")
		{
			QString name = "";
			aliasdb.setGroup("Aliases");

			while (name != NULL) {
				n.setNum(i).append("Name");
				d.setNum(i).append("Def");
				m.setNum(i).append("Macro");
				mod.setNum(i).append("Modifiers");

				tmp = aliasdb.readEntry(n, "");
				if (tmp == "")
					break;
				alias = new AliasEntry;
				alias->name = tmp;
				alias->definition = aliasdb.readEntry(d, "");
				alias->macro = aliasdb.readNumEntry(m, 0);
				alias->modifiers = (ButtonState) aliasdb.readUnsignedNumEntry(mod, 0);
				aliases.append(alias);
				i++;
			}
		}
		++(*gi);
	}
	delete gi;
}

void CCharacterProfile::readTriggers()
{
	KSimpleConfig triggerdb(QDir::homeDirPath()+"/.kde/share/apps/kmud/profiles/"+filename);
	QString groupname, n, d, name;
	TriggerEntry* trigger;
	KGroupIterator *gi;
	uint i = 0;

	triggers.setAutoDelete(true);
	triggers.clear();

	gi = triggerdb.groupIterator();
	gi->toFirst();

	while (gi->current())
	{
		groupname=gi->currentKey();
		if (groupname == "Triggers")
		{
			name = "";
			triggerdb.setGroup("Triggers");

			while (name != NULL) {
				n.setNum(i).append("Name");
				d.setNum(i).append("Def");
				name = triggerdb.readEntry(n, NULL);
				if (name == NULL)
					break;
				trigger = new TriggerEntry;
				trigger->name = name;
				trigger->definition = triggerdb.readEntry(d, "");
				triggers.append(trigger);
				i++;
			}
		}
		++(*gi);
	}
	delete gi;
}

void CCharacterProfile::writeData()
{
	KSimpleConfig mudconf(QDir::homeDirPath()+"/.kde/share/apps/kmud/profiles/"+filename);

	mudconf.setGroup("Logging");
	mudconf.writeEntry("LoggingEnabled",loggingEnabled);
	mudconf.writeEntry("LogANSIEnabled",logANSIEnabled);
	mudconf.writeEntry("LogFilename",logFilename);
	mudconf.setGroup("Mapper");
	mudconf.writeEntry("StartX",map_start_x);
	mudconf.writeEntry("StartY",map_start_y);
	mudconf.writeEntry("StartLevel",map_start_level);	

	writeAliases();
	writeTriggers();
}

void CCharacterProfile::writeAliases()
{
	KSimpleConfig aliasdb(QDir::homeDirPath()+"/.kde/share/apps/kmud/profiles/"+filename);
	QString n, d, m;
	QString mod;
	uint i;


	aliasdb.deleteGroup("Aliases");
	aliasdb.sync();

	// Write the aliases
	aliasdb.setGroup("Aliases");
	for (i = 0; i < aliases.count(); i++) {
		n.setNum(i).append("Name");
		d.setNum(i).append("Def");
		m.setNum(i).append("Macro");
		mod.setNum(i).append("Modifiers");
		aliasdb.writeEntry(n, aliases.at(i)->name);
		aliasdb.writeEntry(d, aliases.at(i)->definition);
		aliasdb.writeEntry(m, aliases.at(i)->macro);
		aliasdb.writeEntry(mod, (uint) aliases.at(i)->modifiers);		
	}
	aliasdb.sync();
}

void CCharacterProfile::writeTriggers()
{

	KSimpleConfig triggerdb(QDir::homeDirPath()+"/.kde/share/apps/kmud/profiles/"+filename);
	QString groupname, n, d;
	uint i;

	triggerdb.deleteGroup("Triggers");
	triggerdb.sync();


	// Write the triggers
	triggerdb.setGroup("Triggers");
	for (i = 0; i < triggers.count(); i++) {
		n.setNum(i).append("Name");
		d.setNum(i).append("Def");
		triggerdb.writeEntry(n, triggers.at(i)->name);
		triggerdb.writeEntry(d, triggers.at(i)->definition);
	}
	triggerdb.sync();
}

void CCharacterProfile::insertAlias(QString name, QString def, int mac, ButtonState modifiers) {
	AliasEntry* alias;

	alias = new AliasEntry;
	alias->name = name;
	alias->definition = def;
	alias->macro = mac;
	alias->modifiers = modifiers;

	aliases.append(alias);
}

void CCharacterProfile::insertTrigger(QString name, QString def) {
	TriggerEntry* trigger;

	trigger = new TriggerEntry;
	trigger->name = name;
	trigger->definition = def;

	triggers.append(trigger);
}

void CCharacterProfile::removeAlias(QString name) {
	AliasEntry* alias;

	alias = aliases.first();
	while (alias != NULL)
	{
		if (alias->name == name)
			aliases.remove(alias);
		alias = aliases.next();
	}
}

void CCharacterProfile::removeTrigger(QString name) {
	TriggerEntry* trigger;

	trigger = triggers.first();
	while (trigger != NULL)
	{
		if (trigger->name == name)
			triggers.remove(trigger);
		trigger = triggers.next();
	}
}

AliasEntry* CCharacterProfile::getAlias(QString name)
{
	AliasEntry* alias;

	alias = firstAlias();
	while ((alias != NULL)&&(alias->name!=name))
		alias = nextAlias();
	return alias;
}

TriggerEntry* CCharacterProfile::getTrigger(QString name)
{
	TriggerEntry* trigger;

	trigger = firstTrigger();
	while ((trigger != NULL)&&(trigger->name!=name))
		trigger = nextTrigger();
	return trigger;
}

AliasEntry* CCharacterProfile::firstAlias() {
	currentAliasIndex = 0;
	if (aliases.count() > 0)
		return aliases.at(0);
	return NULL;
}

AliasEntry* CCharacterProfile::nextAlias() {
	currentAliasIndex++;
	if (aliases.count() > (unsigned int)currentAliasIndex) 
		return aliases.at(currentAliasIndex);
	return NULL;
}

AliasEntry* CCharacterProfile::currentAlias() {
	if (aliases.count() > (unsigned int)currentAliasIndex) 
		return aliases.at(currentAliasIndex);
	return NULL;
}

TriggerEntry* CCharacterProfile::firstTrigger() {
	currentTriggerIndex = 0;
	if (triggers.count() > 0)
		return triggers.at(0);
	return NULL;
}

TriggerEntry* CCharacterProfile::nextTrigger() {
	currentTriggerIndex++;
	if (triggers.count() > (unsigned int)currentTriggerIndex) 
		return triggers.at(currentTriggerIndex);
	return NULL;
}

TriggerEntry* CCharacterProfile::currentTrigger() {
	if (triggers.count() > (unsigned int)currentTriggerIndex) 
	   	return triggers.at(currentTriggerIndex);
	return NULL;
}

bool CCharacterProfile::getLoggingEnabled()
{
	return loggingEnabled;
}

void CCharacterProfile::setLoggingEnabled(bool b)
{
	loggingEnabled=b;
}


bool CCharacterProfile::getLogANSIEnabled()
{
	return logANSIEnabled;
}

void CCharacterProfile::setLogANSIEnabled(bool b)
{
	logANSIEnabled=b;
}


QString CCharacterProfile::getLogFilename()
{
	return logFilename;
}

void CCharacterProfile::setLogFilename(QString filename)
{
	logFilename=filename;
}




void CCharacterProfile::setMapStartX(signed int startx)
{ map_start_x = startx; }

void CCharacterProfile::setMapStartY(signed int starty)
{ map_start_y = starty;  }

void CCharacterProfile::setMapStartLevel(signed int start_level)
{ map_start_level = start_level; }
	
signed int CCharacterProfile::getMapStartX(void)
{ return map_start_x; }

signed int CCharacterProfile::getMapStartY(void)
{ return map_start_y; }

signed int CCharacterProfile::getMapStartLevel(void)
{ return map_start_level; }
