/***************************************************************************
                          dlgconnectionwizard.h
                           -------------------
    description          : Connection Wizard Dialog Class
    begin                : Sun Oct 17 1999                                           
    copyright            : (C) 1999 by Stephan Uhlmann                         
    email                : suhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef DLGCONNECTIONWIZARD_H
#define DLGCONNECTIONWIZARD_H

//Generated area. DO NOT EDIT!!!(begin)
#include <qwidget.h>
#include <qlistview.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
//Generated area. DO NOT EDIT!!!(end)

#include <qdialog.h>
#include <qregexp.h>
//#include <qfiledialog.h>
#include <qfileinfo.h>

#include <kapp.h>
#include "../kmuddoc.h"
#include "dlgselectmud.h"
#include "dlgselectprofile.h"
#include "dlgconnectionwizardinput.h"
#include "../kmudping.h"

/**
	* Connection Wizard Dialog Class
	* returns: 1 - Connect, Reject - Cancel
  *@author Stephan Uhlmann
  */

class DlgConnectionWizard : public QDialog  {
   Q_OBJECT
public:
  /** constructor */
	DlgConnectionWizard( KmudDoc* document, QWidget *parent=0, const char *name=0);
  /** destructor */
	~DlgConnectionWizard();

  /** returns the entered login name */
	QString getLogin();
  /** returns the entered mud title */
	QString getMudTitle();
  /** returns the entered mud host */
	QString getMudHost();
  /** returns the entered mud port */
	QString getMudPort();

  /** returns Character ID (filename) of currently selected item */
	QString getSelectedCharacterID();
  /** returns Mud ID (filename) of currently selected item */
	QString getSelectedMudID();
  /** returns the password */
  QString getPassword();


public slots:
	void slotConnectPressed();
	void slotApplyPressed();
	void slotCancelPressed();
	void slotNewPressed();
	void slotEditPressed();
	void slotDeletePressed();

	void slotShowItem(QListViewItem*);

  void slotPingButtonClicked();

protected:
	void initDialog();
	//Generated area. DO NOT EDIT!!!(begin)
	QListView *charDB_ListView;
	QGroupBox *character_GroupBox;
	QLabel *login_Label;
	QLabel *loginShow_Label;
	QLabel *charProfile_Label;
	QLabel *charProfileShow_Label;
	QGroupBox *mud_GroupBox;
	QLabel *mudTitle_Label;
	QLabel *mudTitleShow_Label;
	QLabel *mudHost_Label;
	QLabel *mudHostShow_Label;
	QLabel *mudPort_Label;
	QLabel *mudPortShow_Label;
	QPushButton *new_Button;
	QPushButton *edit_Button;
	QPushButton *delete_Button;
	QPushButton *connect_Button;
	QPushButton *apply_Button;
	QPushButton *cancel_Button;
	QPushButton *ping_Button;
	//Generated area. DO NOT EDIT!!!(end)

private:

	void updateListView();
  void setDialogState();

	KmudDoc* doc;

	KmudPing* kmudPing;
};

#endif
