/***************************************************************************
                          dlgreconnect.cpp
                      -------------------
    description          :
    begin                : Sun Oct 24 1999
    copyright            : (C) 1999 by John-Paul Stanford
    email                : john-paul.stanford@virgin.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "dlgreconnect.h"
#include <kapp.h>

DlgReconnect::DlgReconnect(QWidget *parent, const char *name) : QDialog(parent,name,true)
{

	setCaption(i18n("Reconnect"));

	initDialog();
	connect( cmdReconnect, SIGNAL(clicked()), SLOT(slotReconnectPressed()) );
	connect( cmdCancel, SIGNAL(clicked()), SLOT(reject()) );
	connect( cmdClose, SIGNAL(clicked()), SLOT(slotClosePressed()) );
	connect( cmdWizard, SIGNAL(clicked()), SLOT(slotWizardPressed()) );
	connect( cmdQuick, SIGNAL(clicked()), SLOT(slotQuickPressed()) );

	QTimer *timer = new QTimer( this );
	connect( timer, SIGNAL(timeout()),this, SLOT(slotTimerDone()) );
	seconds = 10;
	timer->start( 1000, false );
}

DlgReconnect::~DlgReconnect()
{
}

/** This is used to start the start time of the timer */
void DlgReconnect::setAutoTime(unsigned int t)
{
	QString time_string;

	seconds = t;
	time_string.sprintf("Auto reconnect in %d seconds",seconds);
	lblTime->setText(time_string);	
}

/** This slot is called when the reconnect button is pressed */
void DlgReconnect::slotReconnectPressed()
{
 	done(1);
}

/** This slot is called when the cancel button is pressed */
void DlgReconnect::slotClosePressed()
{
	done(2);
}

/** This slot is called when the quick connect button is pressed */
void DlgReconnect::slotQuickPressed()
{
	done(3);
}

/** This slot is called when the wizard button is pressed */
void DlgReconnect::slotWizardPressed()
{
	done(4);
}

/** This slot is called to up date the seconds count on the dialog */
void DlgReconnect::slotTimerDone()
{
	QString time_string;
	seconds--;

	if (seconds == 0)
	{
		timer->stop();
		done(1);
	}
	else
	{
		time_string.sprintf("Auto reconnect in %d seconds",seconds);
		lblTime->setText(time_string);	
	}
}
