#ifndef _KMSGBAR_H_
#define _KMSGBAR_H_

#include <qpushbutton.h>
#include <ktoolbar.h>

class KConfig;

class KMoreButton:public QPushButton
{
  Q_OBJECT
public:
  KMoreButton(const char *text, QWidget *parent=0, const char *name=0);
  void keyPressEvent(QKeyEvent *);
};

class KMsgBar:public KToolBar
{
  Q_OBJECT
public:
  KMsgBar(QWidget *parent=NULL, char *name=NULL);
  void message(const char *c);
  void setMessage(const char *msg);
  void removeMore(void);
  void invMsg();
  bool more();
  void saveProperties(KConfig *);
  void readProperties(KConfig *);
  const char *getMessage(int i=0);
  int msgCount();
  QFont *normal, *bold;
  int willQuit;
protected:
  QComboBox *combo;
  KMoreButton *p;
  int pbid, fmore, loop;
  bool inv;  
public slots:
  void activ(int i);
  void moreClick(void);
signals:
  void moreShown();
};

extern KMsgBar *msg;
#endif