/*
 * inventory.c
 *
 * This source herein may be modified and/or distributed by anybody who
 * so desires, with the following restrictions:
 *    1.)  No portion of this notice shall be removed.
 *    2.)  Credit shall not be taken for the creation of this source.
 *    3.)  This code is not to be traded, sold, or used for personal
 *         gain or profit.
 *
 */

#include "rogue.h"
#include "dun.h"

#define swap_string(x,y) {t = x; x = y; y = t;}

boolean is_wood[WANDS];

char *wand_materials[WAND_MATERIALS] = {
	"steel",
	"bronze",
	"gold",
	"silver",
	"copper",
	"nickel",
	"cobalt",
	"tin",
	"iron",
	"magnesium",
	"chrome",
	"carbon",
	"platinum",
	"silicon",
	"titanium",

	"teak",
	"oak",
	"cherry",
	"birch",
	"pine",
	"cedar",
	"redwood",
	"balsa",
	"ivory",
	"walnut",
	"maple",
	"mahogany",
	"elm",
	"palm",
	"wooden"
};

char *gems[GEMS] = {
	"diamond",
	"stibotantalite",
	"lapi-lazuli",
	"ruby",
	"emerald",
	"sapphire",
	"amethyst",
	"quartz",
	"tiger-eye",
	"opal",
	"agate",
	"turquoise",
	"pearl",
	"garnet"
};

char *syllables[MAXSYLLABLES] = {
	"blech ",
	"foo ",
	"barf ",
	"rech ",
	"bar ",
	"blech ",
	"quo ",
	"bloto ",
	"woh ",
	"caca ",
	"blorp ",
	"erp ",
	"festr ",
	"rot ",
	"slie ",
	"snorf ",
	"iky ",
	"yuky ",
	"ooze ",
	"ah ",
	"bahl ",
	"zep ",
	"druhl ",
	"flem ",
	"behil ",
	"arek ",
	"mep ",
	"zihr ",
	"grit ",
	"kona ",
	"kini ",
	"ichi ",
	"niah ",
	"ogr ",
	"ooh ",
	"ighr ",
	"coph ",
	"swerr ",
	"mihln ",
	"poxi "
};

extern boolean wizard;

set_idtab(struct id *idtab, int idelem, char **ttab, int telem, short *out)
{
        int i, j;
	for (i = 0; i < idelem; i++) {
	    out[i] = 0;
	    if (idtab[i].id_status == UNIDENTIFIED)
		for (j = 0; j < telem; j++)
		    if (strcmp(idtab[i].title, ttab[j]) == 0) {
			out[i] = j;
			break;
		    }
	}
}

set_ids()
{
  set_idtab(id_potions, POTIONS, color_names, POTIONS, colorid);
  set_idtab(id_wands, WANDS, wand_materials, WAND_MATERIALS, wandid);
  set_idtab(id_rings, RINGS, gems, GEMS, gemid);
}

mix_colors()
{
	short i, j, k, ti;
	char t[128];

	for (i = 0; i <= 32; i++) {
		j = get_rand(0, (POTIONS - 1));
		k = get_rand(0, (POTIONS - 1));
		strcpy(t,id_potions[j].title);
		strcpy(id_potions[j].title,id_potions[k].title);
		strcpy(id_potions[k].title,t);
	}
}

make_scroll_titles()
{
	short i, j, n;
	short sylls, s;

	for (i = 0; i < SCROLLS; i++) {
		sylls = get_rand(2, 5);
		(void) strcpy(id_scrolls[i].title, "'");

		for (j = 0; j < sylls; j++) {
			s = get_rand(1, (MAXSYLLABLES-1));
			(void) strcat(id_scrolls[i].title, syllables[s]);
		}
		n = strlen(id_scrolls[i].title);
		(void) strcpy(id_scrolls[i].title+(n-1), "' ");
	}
}

#define DESCITEM(idfmt, idplfmt, idname, idtype, callfmt, callplfmt, \
callname, unidfmt, unidplfmt, unidname, unidtype, unidval)              \
	    {				                                \
		if (id == IDENTIFIED)                                   \
		{                                                       \
			if (!pl) fmt=(idfmt);			        \
			    else fmt=(idplfmt);			        \
			format_str(desc, fmt, (idname), (pl ? 2 : 1), (idtype),   \
			    obj->which_kind, id_table[obj->which_kind].real, \
			    SNUMBER, 0, &obj->quantity);                \
		} else                                                  \
		if (id == CALLED)                                       \
		{						        \
			if (!pl) fmt=(callfmt);			        \
			    else fmt=(callplfmt);		        \
			format_str(desc, fmt, (callname), (pl ? 2 : 1), STRING,   \
			    0, id_table[obj->which_kind].title, SNUMBER,          \
			    0, &obj->quantity);			        \
		} else						        \
		{						        \
			if (!pl) fmt=(unidfmt);			        \
			    else fmt=(unidplfmt);	 	        \
			format_str(desc, fmt, (unidname), (pl ? 2 : 1), (unidtype), \
			    (unidval), id_table[obj->which_kind].title, \
			    SNUMBER, 0, &obj->quantity);	        \
		}						        \
	}


get_desc(obj, desc)
object *obj;
char *desc;
{
	char *item_name;
	struct id *id_table;
	char more_info[32], *fmt;
	short i, id;
	int item_id;
	boolean pl, objid;

	strcpy(desc, "???");
	if (obj->what_is == AMULET) {
		(void) strcpy(desc, transl("the amulet of Yendor"));
		goto END;
	}
	item_name = name_of(obj, &item_id);

	if (obj->what_is == GOLD) {
		format_str(desc, "${0} pieces of gold", "gold", 1, 
			SNUMBER, 0, &obj->quantity);
		return;
	}

	if (obj->what_is == FOOD) {
		if (obj->which_kind == RATION) {
			if (obj->quantity > 1) {
				format_str(desc, "${0} rations of food", "ifood",
				    1, SNUMBER, 0, &obj->quantity);
			} else {
				strcpy(desc, transl("some food"));
			}
		} else {
			(void) strcpy(desc, transl("a slime-mold"));
		}
		goto END;
	}
	
	id_table = get_id_table(obj);
	pl = obj->quantity > 1;
	id = (wizard ? IDENTIFIED : id_table[obj->which_kind].id_status);
	objid = (wizard || obj->identified);

	if (obj->what_is == POTION) {
	    DESCITEM("a potion of ${0}", "${1} potions of ${0}", "potid", POTREAL,
		"a potion called ${0}", "${1} potions called ${0}", "potcall",
		"a ${0} potion", "${1} ${0} potions", "potunin", 
		COLOR, colorid[obj->which_kind]);
	}

	if (obj->what_is == SCROLL) {
	    DESCITEM("a scroll of ${0}", "${1} scrolls of ${0}", "scrid", SCRREAL,
		"a scroll called ${0}", "${1} scrolls called ${0}", "scrcall",
		"a scroll entitled: ${0}", "${1} scrolls entitled: ${0}", "scrunin", STRING, 0);
	}
	
	if (obj->what_is == WAND) {
	    if (is_wood[obj->which_kind])
		DESCITEM("a staff of ${0}", "", "staffid", WANDREAL,
		    "a staff called ${0}", "", "staffcall",
		    "a ${0} staff", "", "staffunin", 
		    MATERIAL, wandid[obj->which_kind])
		else DESCITEM("a wand of ${0}", "", "wandid", WANDREAL,
		    "a wand called ${0}", "", "wandcall",
		    "a ${0} wand", "", "wandunin", 
		    MATERIAL, wandid[obj->which_kind]);
	    if (wizard || obj->identified) {
		sprintf(more_info, " [%d]", obj->o_class);
		APPEND(desc, more_info, MSGLEN);
	    }
	}
	
	if (obj->what_is == WEAPON) {
	    if (objid) sprintf(more_info, " %s%d,%s%d",
		    ((obj->hit_enchant >= 0) ? "+" : ""),
		    obj->hit_enchant,
		    ((obj->d_enchant >= 0) ? "+" : ""),
		    obj->d_enchant);
		else more_info[0]=0;
	    if (!pl) 
		format_str(desc, "a${1} ${0}", "iweapon", 2, OBJECT, 
		    item_id, item_name, STRING, 0, more_info);
		else format_str(desc, "${2}${1} ${0}", "iweapon", 3, OBJECT, 
		    item_id, item_name, STRING, 0, more_info, SNUMBER, 0,
		    &obj->quantity);
	}

	if (obj->what_is == RING) {
	    if (id == IDENTIFIED && objid && ((obj->which_kind == DEXTERITY) ||
		    (obj->which_kind == ADD_STRENGTH))) {
		sprintf(more_info, "%s%d", ((obj->o_class > 0) ? "+" : ""),
		    obj->o_class);
		format_str(desc, "a ${1} ring of ${0}", "ringid", 2,
		    RINGREAL, obj->which_kind, id_table[obj->which_kind].real,
		    STRING, 0, more_info);
	    } else DESCITEM("a ring of ${0}", "", "ringid", RINGREAL,
		"a ring called ${0}", "", "ringcall",
		"a ${0} ring", "", "ringunin", RINGGEM, gemid[obj->which_kind]);
	}
	
	if (obj->what_is == ARMOR) {
	    if (!objid) strcpy(desc, _i18n(id_table[obj->which_kind].title));
	    else {
		if (objid) sprintf(more_info, "%s%d",  
		    ((obj->d_enchant >= 0) ? "+" : ""), obj->d_enchant);
		    else more_info[0]=0; 
		format_str(desc, "${1} ${0}", "iarmor", 2, ARMORREAL,
		    (int)obj->which_kind, id_table[obj->which_kind].title, 
		    STRING, 0, more_info);
		sprintf(more_info, " [%d]", get_armor_class(obj));
		APPEND(desc, more_info, MSGLEN);
	    }
	}

END:
	if (obj->in_use_flags & BEING_WIELDED) {
		APPEND(desc, transl(" in hand"), MSGLEN);
	} else if (obj->in_use_flags & BEING_WORN) {
		APPEND(desc, transl(" being worn"), MSGLEN);
	} else if (obj->in_use_flags & ON_LEFT_HAND) {
		APPEND(desc, transl(" on left hand"), MSGLEN);
	} else if (obj->in_use_flags & ON_RIGHT_HAND) {
		APPEND(desc, transl(" on right hand"), MSGLEN);
	}
	APPEND(desc, " ", MSGLEN);
}

get_wand_and_ring_materials()
{
	short i, j;
	boolean used[WAND_MATERIALS];

	for (i = 0; i < WAND_MATERIALS; i++) {
		used[i] = 0;
	}
	for (i = 0; i < WANDS; i++) {
		do {
			j = get_rand(0, WAND_MATERIALS-1);
		} while (used[j]);
		used[j] = 1;
		(void) strcpy(id_wands[i].title, wand_materials[j]);
		is_wood[i] = (j > MAX_METAL);
	}
	for (i = 0; i < GEMS; i++) {
		used[i] = 0;
	}
	for (i = 0; i < RINGS; i++) {
		do {
			j = get_rand(0, GEMS-1);
		} while (used[j]);
		used[j] = 1;
		(void) strcpy(id_rings[i].title, gems[j]);
	}
}

single_inv(ichar)
short ichar;
{
	char desc[MSGLEN+3];
	object *obj;
	if (!ichar) {
		obj=item_o;
		ichar=item;
	} else obj=get_letter_object(ichar);
	desc[0] = ichar;
	desc[1] = ((obj->what_is & ARMOR) && obj->is_protected) ? '}' : ')';
	desc[2] = ' ';
	desc[3] = 0;
	get_desc(obj, desc+3);
	message(desc, 0);
}

struct id *
get_id_table(obj)
object *obj;
{
	switch(obj->what_is) {
	case SCROLL:
		return(id_scrolls);
	case POTION:
		return(id_potions);
	case WAND:
		return(id_wands);
	case RING:
		return(id_rings);
	case WEAPON:
		return(id_weapons);
	case ARMOR:
		return(id_armors);
	}
	return((struct id *) 0);
}

inv_armor_weapon(is_weapon)
boolean is_weapon;
{
	if (is_weapon) {
		if (rogue.weapon) {
			single_inv(rogue.weapon->ichar);
		} else {
			message(_i18n("not wielding anything"), 0);
		}
	} else {
		if (rogue.armor) {
			single_inv(rogue.armor->ichar);
		} else {
			message(_i18n("not wearing anything"), 0);
		}
	}
}
