/***************************************************************************
    kontroll1.cpp  fr KWA - Kanadische Waldbrandaustreter
	  Kontrollfeld fr einzelne Feuerwehren - Implementation
                             -------------------
    begin                : Sat Sep 30 2000
    copyright            : (C) 2000 by Ulrich Bochert
    email                : schroeder_bochert@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <stdio.h>
#include <qlabel.h>
#include <qwidget.h>
#include <qcheckbox.h>
#include <qpainter.h>

#include "kontroll1.h"
#include "kwa.h"
#include "feuerwehr.h"

Kontroll::Kontroll(QWidget *parent, const char *name, int Tp, double
                   Richtg, double Sp, int B, int W, bool L)
         :QWidget(parent, name)
{
//       printf("Kontroll konstruktor\n");
        InstanzExists=true;

        FeuerWehr=Tp;
        Richtung=Richtg;
        Speed=Sp;
        Benzin=B;
        Wasser=W;
        Loeschen=L;
        setMinimumSize(140,48);
        setMaximumSize(140,48);
		    QFont f("Helvetica", 10, QFont::Normal);

//Richtung-Kontrollelemente:
        //printf("K Richtung Konstr.");
        KRichtungBminus=new QPushButton("<", this, "KRichtungBminus");
        KRichtungBminus->setGeometry(3, 12, 15, 15);
        KRichtungL =new QLabel(this, "KRichtungL");
        KRichtungL->setGeometry(18,12,20,15);
        KRichtungL->setAlignment(AlignCenter);
				KRichtungL->setFont( f );
        KRichtungBminus->setAutoRepeat(true);
        KRichtungBplus=new QPushButton(">", this, "KRichtungBplus");
        KRichtungBplus->setGeometry(20+15+3, 12, 15, 15);
        KRichtungBplus->setAutoRepeat(true);
        connect(KRichtungBplus, SIGNAL(clicked()), this,SLOT(
                setRichtungP()));
        connect(KRichtungBminus, SIGNAL(clicked()), this,SLOT(
                setRichtungM()));

//Geschwindigkeits-Kontrollelemente:
        //printf("K Speed Konstr.");
        KSpeedBminus=new QPushButton("<", this, "KRichtungBminus");
        KSpeedBminus->setGeometry(3, 30, 15, 15);
        KSpeedL =new QLabel(this, "KRichtungL");
        KSpeedL->setGeometry(18,30,15,15);
        KSpeedL->setAlignment(AlignCenter);
				KSpeedL->setFont( f );
        KSpeedBminus->setAutoRepeat(true);
        KSpeedBplus=new QPushButton(">", this, "KRichtungBplus");
        KSpeedBplus->setGeometry(15+15+3, 30, 15, 15);
        KSpeedBplus->setAutoRepeat(true);
        connect(KSpeedBplus, SIGNAL(clicked()), this,SLOT(
                setSpeedP()));
        connect(KSpeedBminus, SIGNAL(clicked()), this,SLOT(
                setSpeedM()));

//Benzin-Anzeige:
        //printf("K Benzin Konstr. %3d", Benzin);
        BenzinBalken=new QWidget(this,"");
        BenzinBalken->setGeometry(57, 14, 80, 11);
        BenzinBalken->setBackgroundColor(QColor(150,150,150));

//Wasser-Anzeige:
        //printf("K Wasser Konstr. %3d", Wasser);
        WasserBalken=new QWidget(this,"");
        WasserBalken->setGeometry(63, 31, 74, 11);
        WasserBalken->setBackgroundColor(QColor(150,150,150));

//Lschen-Anzeige:
        //printf("K Lschen Konstr. \n");
        LoeschBox = new QCheckBox(this,"" );
        LoeschBox->setGeometry(50, 32,10,10);
        connect (LoeschBox, SIGNAL(clicked()), this, SLOT(setLoeschen()));

//Steuerelemente Anzeigen
        init(FeuerWehr,Richtung,Speed,Benzin,Wasser,Loeschen);

}
void Kontroll::init(int Tp, double Richtg, double Sp, int B, int W, bool L)
{
        //printf("Kontroll konstruktor %1d\n", Tp);
        FeuerWehr=Tp;
        Richtung=Richtg;
        Speed=Sp;
        Benzin=B;
        Wasser=W;
        Loeschen=L;

//Richtung-Kontrollelemente:
        //printf("K Richtung Konstr.");
        RichtungZeigen();

//Geschwindigkeits-Kontrollelemente:
        //printf("K Speed Konstr.");
        KSpeedL->setNum(int(Speed*100));

//Benzin-Anzeige:
        //printf("K Benzin Konstr. %3d", Benzin);
        BenzinZeigen();

//Wasser-Anzeige:
        //printf("K Wasser Konstr. %3d", Wasser);
        WasserZeigen();

//Lschen-Anzeige:
        //printf("K Lschen Konstr. \n");
        LoeschBox->setChecked(Loeschen);

//Steuerelemente Anzeigen
        KRichtungBminus->show();
        KRichtungBplus->show();
        KRichtungL->show();
        KSpeedBminus->show();
        KSpeedBplus->show();
        KSpeedL->show();
        LoeschBox->show();
}

Kontroll::~Kontroll()
{
        //printf("Kontroll destruktor\n");
}

void Kontroll::closeEvent(QCloseEvent *e)
{
        //printf("k1_hidden %1d \n", FeuerWehr);
        e->accept();
        emit k1_hidden(FeuerWehr);
}

void Kontroll::focusOutEvent(QFocusEvent*)
{
//verhindert, dass Das KontrollFeld hinter dem Spielfeld verschwindet
        //printf("K focus out\n");
        raise();
}

void Kontroll::moveEvent(QMoveEvent *)
{
        emit k1_moved();
}
void Kontroll::mousePressEvent(QMouseEvent *mp)
{
        if (mp->button()==RightButton)
                close();
        else
        {
                MausPX=mp->globalX();
                MausPY=mp->globalY();
        }
        //printf("MausPX %5d, MausPY %5d\n", MausPX, MausPY);
}
void Kontroll::mouseMoveEvent(QMouseEvent *mm)
{
        MausRX=mm->globalX();
        MausRY=mm->globalY();
        move(x()+MausRX-MausPX, y()+MausRY-MausPY);
        //printf("MausRX %5d, MausRY %5d\n\n", MausRX, MausRY);
        MausPX=MausRX;
        MausPY=MausRY;
}
void Kontroll::mouseReleaseEvent(QMouseEvent *mr)
{
        MausRX=mr->globalX();
        MausRY=mr->globalY();
        move(x()+MausRX-MausPX, y()+MausRY-MausPY);
        //printf("MausRX %5d, MausRY %5d\n\n", MausRX, MausRY);
}

void Kontroll::RichtungZeigen()
{
        //printf("K RichtungZeigen %1d: %3d\n", FeuerWehr, int(Richtung));
        KRichtungL->setNum(int(Richtung));
}
void Kontroll::BenzinZeigen()
{
        //printf("K BenzinZeigen \n");
        int B=int(float (Benzin)/100.0*BenzinBalken->width());
        BenzinBalken->erase();
        QPainter p;
        p.begin (BenzinBalken);
        QRect r=QRect(0,0,B, BenzinBalken->height() );
        p.setPen(red);
        p.setBrush(red);
        p.drawRect(r);
        p.end();
}
void Kontroll::WasserZeigen()
{
        //printf("K WasserZeigen \n");
        int B=int(float (Wasser)/100.0*WasserBalken->width());
        WasserBalken->erase();
        QPainter p;
        p.begin (WasserBalken);
        QRect r=QRect(0,0,B,WasserBalken->height());
        p.setPen(blue);
        p.setBrush(blue);
        p.drawRect(r);
        p.end();
}
void Kontroll::paintEvent(QPaintEvent *)
{
        BenzinZeigen();
        WasserZeigen();

    //Rahmen anzeigen
        QPainter p;
        p.begin (this);
        p.setPen(QColor(250, 250, 250));
        p.drawLine(0,0,width(),0);
        p.drawLine(0,0,0,height());
        p.setPen(QColor(50, 50, 50));
        p.drawLine(0,height()-1,width(),height()-1);
        p.drawLine(width()-1,height(),width()-1,0);

    //SchriftZug
        p.setFont(QFont("helvetica",10,QFont::Normal));
        char Name[]="Lschzug  ";
	      Name[9]=FeuerWehr+48;
        char *Name_p=Name;
        p.drawText(2,10,Name_p,11);
        p.end();

}
void Kontroll::RichtungSlot(double R)
{
        //printf("K RichtungAnzeigen %1d: %3d\n", fw, int(R+0.5));
        KRichtungL->setNum(int(R+0.5));
        Richtung=R;
}
void Kontroll::LoeschenSlot(bool L)
{
        //printf("K LschenAnzeigen\n");
        LoeschBox->setChecked(L);
        Loeschen=L;
}
void Kontroll::setRichtungP()
{
        Richtung=Richtung+5;
        if (Richtung>360) Richtung=Richtung-360;
        //printf("K RichtungSetzen %3d\n", int(Richtung+0.5));
        KRichtungL->setNum(int(Richtung));
        emit RichtungChanged(Richtung);
}
void Kontroll::setRichtungM()
{
        Richtung=Richtung-5;
        if (Richtung<0) Richtung=Richtung+360;
        //printf("K RichtungSetzen %3d\n", int(Richtung+0.5));
        KRichtungL->setNum(int(Richtung));
        emit RichtungChanged(Richtung);
}

void Kontroll::setSpeedP()
{
        if (Speed<0.15)
                Speed=Speed+0.01;
        else if (Speed<=0.5)
                Speed=Speed+0.02;
        if (Speed>0.5)Speed=0.5;
        //printf("K SpeedSetzen %3d\n", int(Speed*100+0.5));
        KSpeedL->setNum(int(Speed*100));
        emit SpeedChanged(Speed);
}
void Kontroll::setSpeedM()
{
        if (Speed<0.15)
                Speed=Speed-0.01;
        else
                Speed=Speed-0.02;
        if (Speed<0.0) Speed=0.0;
        //printf("K SpeedSetzen %3d\n", int(Speed));
        KSpeedL->setNum(int(Speed*100));
        emit SpeedChanged(Speed);
}

void Kontroll::setLoeschen()
{
        Loeschen=LoeschBox->isChecked();
        if (Loeschen==true && Wasser<=0)
        {
                LoeschBox->setChecked(false);
                return;
        }
        emit LoeschenChanged(Loeschen);
        emit LoeschenChanged2(FeuerWehr, Loeschen);
}

void Kontroll::WasserSlot(int W)
{
        Wasser=int(float(W)+.99);
        //printf("K getWasser %3d: %3d\n", FeuerWehr, Wasser);
        WasserZeigen();
}

void Kontroll::BenzinSlot(int B)
{
        Benzin=int(float(B)+.99);
        //printf("K getBenzin %3d: %3d\n", FeuerWehr, Benzin);
        BenzinZeigen();
}
void Kontroll::SpeedSlot(double S)
{
        //printf("K RichtungAnzeigen %1d: %1.3f\n", fw, S);
        KSpeedL->setNum(int((S*1000+0.5)/10));
        Speed=S;
}

bool Kontroll::getInstanzExists()
{
        return InstanzExists;
}
bool Kontroll::InstanzExists=false;
#include "kontroll1.moc"
