/***************************************************************************
                          quantadoc.h  -  description
                             -------------------
    begin                :   18 23:09:05 EET 1999
    copyright            : (C) 1999 by Yacovlev Alexander & Dmitry Poplavsky
    email                : pdima@mail.univ.kiev.ua
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QUANTADOC_H
#define QUANTADOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>
#include <qdict.h>

// forward declaration of the Quanta classes
class QuantaApp;
class QuantaView;
class KWrite;
class QPopupMenu;

/**	QuantaDoc provides a document object for a document-view model.
  *
  * The QuantaDoc class provides a document object that can be used in conjunction with the classes QuantaApp and QuantaView
  * to create a document-view model for standard KDE applications based on KApplication and KTMainWindow. Thereby, the document object
  * is created by the QuantaApp instance and contains the document structure with the according methods for manipulation of the document
  * data by QuantaView objects. Also, QuantaDoc contains the methods for serialization of the document data from and to files.
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
  * @version KDevelop version 0.4 code generation
  */
class QuantaDoc : public QObject
{
  Q_OBJECT
  public:
    /** Constructor for the fileclass of the application */
    QuantaDoc(QWidget *parent, const char *name=0);
    /** Destructor for the fileclass of the application */
    ~QuantaDoc();

    /** adds a view to the document which represents the document contents. Usually this is your main view. */
    void addView(QuantaView *view);
    /** removes a view from the list of currently connected views */
    void removeView(QuantaView *view);
    /** sets the modified flag for the document after a modifying action on the view connected to the document.*/
    void setModified(bool _m=true);
    /** returns if the document is modified or not. Use this to determine if your document needs saving by the user on closing.*/
    bool isModified();
    /** "save modified" - asks the user for saving if the document is modified */
    bool saveModified();	
    /** deletes the document's contents */
    void deleteContents();
    /** initializes the document generally */
    bool newDocument(const char *filename = 0);
    /** closes the acutal document */
    void closeDocument();
    /** loads the document by filename and format and emits the updateViews() signal */
    bool openDocument(const QString &filename, const char *format=0);
    /** saves the document under filename and format.*/	
    bool saveDocument(const QString &filename, const char *format=0);
    /** sets the path to the file connected with the document */
    void setAbsFilePath(const QString &filename);
    /** returns the pathname of the current document file*/
    QString getAbsFilePath();
    /** sets the filename of the document */
    void setTitle(const QString &_t);
    /** returns the title of the document */
    const QString &getTitle() const;
    /** change file name in tab bar etc */
    void changeFileName(QString newname);
    /** save all files */
    bool saveAll(bool type=true);
    /** create new write classa */
    KWrite *newWrite(QWidget *parent);
	
  public slots:
    /** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
     * As this view normally repaints itself, it is excluded from the paintEvent.
     */
    void slotUpdateAllViews(QuantaView *sender);
    /**  */
    void selectWrite( int id);
 	
  public:	
    /** the list of the views currently connected to the document */
    static QList<QuantaView> *pViewList;	

  private:
    QString title;

  public:
  	/** Pointer to write from QuantaView */
    KWrite *write;
  	/** for save path with files for html (images ...) */
  	QString basePath;
    /** view */
    QuantaView* view;
    /** app */
    QuantaApp* app;
    /** list of names */
    QDict<int> *fileList;
    /** menu on right button */
    QPopupMenu * writeRBMenu;

};

#endif // QUANTADOC_H
