/* 
    channel for Bt848 frame grabber driver

    Copyright (C) 1996,97 Marcus Metzler (mocm@thp.uni-koeln.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * channel.cc 
 */

#include "channel.h"
#include <string.h>

int channel::version= CFVER_3;

channel::channel(int freq,const char *n,int c,int b,int hu,int co,int no,int in,int cntry, const char *cid)
{
  name=new char[strlen(n)+1];
  strcpy(name,n);
  frequency=freq;
  color=c;
  brightness=b;
  hue=hu;
  contrast=co;
  norm=no;
  input=in;
  country=cntry;
  channelId=new char[strlen(cid)+1];
  strcpy(channelId,cid);
}


channel::~channel()
{
  delete(name);
  delete(channelId);
}

ostream &operator<<(ostream &stream, channel &x)
{
  stream << "*" << endl;
  stream << "Chnl: " << x.name << endl;
  stream << "Frq: " << x.frequency;
  if (x.channelId)
    stream << " " << x.channelId << endl;
  else 
    stream << " ??" << endl;
  stream << "CBHC: " << x.color << " " << x.brightness << " " << x.hue << " " << x.contrast << endl; 
  stream << "NIS: " << x.norm << " " << x.input << endl;
  stream << "Cntry: " << x.country << endl; 
}

istream &operator>>(istream &stream, channel &x)
{
  char cdummy[50];
  
  switch ( x.version ) {
  case CFVER_XTV:
    stream >> cdummy >> cdummy;
    if (x.name) delete(x.name);
    x.name=new char[sizeof(cdummy)];
    strcpy(x.name,cdummy);
    stream.get(cdummy,sizeof(cdummy)); // get full channel name
    strcat(x.name,cdummy);
    
    stream >> cdummy >> x.frequency;
    stream >> cdummy >> x.color >> x.brightness >> x.hue >> x.contrast;
    stream >> cdummy >> x.norm >> x.input; 
    x.country=-1;
    x.channelId=new char[4];
    strcpy(x.channelId,"??");
    break;
  case CFVER_1:
    stream >> cdummy;
    stream >> cdummy;
    if (x.name) delete(x.name);
    x.name=new char[sizeof(cdummy)];
    strcpy(x.name,cdummy);
    stream.get(cdummy,sizeof(cdummy)); // get full channel name
    strcat(x.name,cdummy);

    stream >> cdummy >> x.frequency;
    stream >> cdummy >> x.color >> x.brightness >> x.hue >> x.contrast;
    stream >> cdummy >> x.norm >> x.input;
    stream >> cdummy; // old startwiththis
    x.country=-1;
    x.channelId=new char[4];
    strcpy(x.channelId,"??");
    break;
  case CFVER_2:
    stream >> cdummy >> cdummy;  // * \n Channel: 
    if (x.name) delete(x.name);
    x.name=new char[255];
    strcpy(x.name,cdummy);
    stream.get(cdummy,sizeof(cdummy)); // get full channel name
    strcat(x.name,cdummy);
  
    stream >> cdummy >> x.frequency;
    stream >> cdummy >> x.color >> x.brightness >> x.hue >> x.contrast;
    stream >> cdummy >> x.norm >> x.input;
    stream >> cdummy >> x.country;
    x.country=-1;
    x.channelId=new char[4];
    strcpy(x.channelId,"??");
    break;
  case CFVER_3:
    stream >> cdummy >> cdummy;  // * \n Channel: 

    if (x.name) delete(x.name);
    x.name=new char[255];
    strcpy(x.name,cdummy);
    stream.get(cdummy,sizeof(cdummy)); // get full channel name
    strcat(x.name,cdummy);
  
    stream >> cdummy >> x.frequency >> cdummy;

    if (x.channelId) delete(x.channelId);
    x.channelId=new char[255];
    strcpy(x.channelId,cdummy);
    stream.get(cdummy,sizeof(cdummy)); // get full channelId
    strcat(x.channelId,cdummy);

    stream >> cdummy >> x.color >> x.brightness >> x.hue >> x.contrast;
    stream >> cdummy >> x.norm >> x.input;
    stream >> cdummy >> x.country;
    break;
  default:
    cerr << "Warning: Unsupported channel file format " << x.version << endl;
  }
}






