/* 
    sound.h for Bt848 frame grabber driver

    Copyright (C) 1996,97 Marcus Metzler (mocm@thp.uni-koeln.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _sound_h
#define _sound_h

#include <sys/soundcard.h>

#define VOL_LEFT  1
#define VOL_RIGHT 2
#define VOL_BOTH  3

#define NO_MDEV   255

struct _lrvol {
  unsigned char l,r;
};

typedef _lrvol lr_vol;
  
class mixer
{
public:
  mixer(const char *filename="/dev/mixer", 
	unsigned int device = NO_MDEV,
	bool rec= true ); 
  ~mixer(); 

  void setVolume( int vol, int pos = VOL_BOTH );
  void setStereoVolume(int rvol, int lvol);
  int getVolume( int pos = VOL_LEFT );

  bool setDevice(unsigned int _dev);
  unsigned int getDevice() { return dev; }

  bool isStereoDevice();

  // list access
  static char *getFirstDeviceName(int *nr, bool rec_only);
  static char *getNextDeviceName(int *nr, bool rec_only);

  static int name2Device(const char *_devName);
  
private:
  unsigned int dev;
  lr_vol svolumes;
  int mixer_device;
  static unsigned int devmask,recmask,recsrc,stereodevs,caps;
  static unsigned int locked_channels, muted_channels;
  static int  devNr;
  static bool globaldone;
};

#endif /* _sound_h */
/* DON'T ADD STUFF AFTER THIS #endif */





