/* 
    xWinTV using Bt848 frame grabber driver

    Copyright (C) 1998 Moritz Wenk (wenk@mathematik.uni-kl.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef VIDEOTXT_H
#define VIDEOTXT_H

#include "vtx.h"

//#include "/home/wenk/soft/wintv/bttv/vtx-driver/vtx.h"
//#include <vtx.h>

#define REQ_MAJOR 1
#define REQ_MINOR 6
#define DVTXDEV "/dev/vtx"

#define VTXOK 0
#define VTXNOTFOUND 1
#define VTXERR -1
#define VTXEINVAL -2
#define VTXEOPEN -3
#define VTXEVERSION -4
#define VTXENOTOPEN -5

typedef enum { FMT_ISO, FMT_ANSI, FMT_TEXT, FMT_VTX, FMT_GIF, FMT_GIFINT, FMT_PPM,
	       FMT_PS, FMT_IPS, FMT_CPS } ofmt_t;

typedef unsigned char chr_t;
typedef unsigned short attrib_t;

typedef struct {
  chr_t chr[VTX_PAGESIZE];
  attrib_t attrib[VTX_PAGESIZE];
  vtx_pageinfo_t info;
} vtxpage_t;

typedef struct {
  int xsize, ysize, bpr, bpc;
  unsigned char *bitmap;
} vtxbmfont_t;


struct STRTAB {
    int  nr;
    char *str;
};

static struct STRTAB chipset[] = {
  { SAA5243, "SAA5243" },
  { SAA5246, "SAA5246" },
  { SAA5249, "SAA5249" },
  { SAA5248, "SAA5248" },
  { XSTV5346, "XSTV5346" }
};

//============================================================================================
//============================================================================================

class vtxClass
{
public:
  vtxClass(char *_vtxdev=DVTXDEV);
  ~vtxClass() { closeDevice(); }

  int chkparity(byte_t *val);
  byte_t mkparity(byte_t val);
  
  int clearpgbuf(int pgbuf);
  int checkpage(int pgbuf);
  int stop_dau(int pgbuf);
  int reset_pgfound(int pgbuf);
  int searchpage(int page, int hour, int minute, int pagemask, int pgbuf);
  int getpage(int pgbuf, int x1, int y1, int x2, int y2, byte_t *buffer, vtx_pageinfo_t *info);
  int putpage(int x1, int y1, int x2, int y2, const byte_t *buffer, const vtx_pageinfo_t *info);
  int set_display(vtxdisp_t disp);
  int clear_cache(void);
  int set_vir(int vir);

private:

  int openDevice(int major, int minor, vtx_info_t *prg_info);
  void closeDevice(void);
  // resources 
  char *vtxdev;
  int fvtx;

  int page_timeout, show_hidden, show_header, output_virtual;
  ofmt_t ofmt;
  vtx_info_t vtx_info;
  vtxpage_t page;
  vtxbmfont_t *vtxbmfont;
  char *outdir, *fname_prefix;
};




#endif
