/* $Id: kget.h,v 1.3 1999/02/23 21:50:39 koss Exp $
   $Log: kget.h,v $
   Revision 1.3  1999/02/23 21:50:39  koss
   Replaced about dialog and help menu with getHelpMenu() from
   KApplication
   getSize() is now called only for queued transfers ( not for delayed )
   statusbar update for speed and remaining time

   Revision 1.2  1999/02/19 15:43:56  koss
   Fixed bug in showing speed, it remained from the times of kget 0.5.1
   when only ppp speed was showed.
   Fixed transfer mode switching + updateToolbar() + checkQueue()

   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.3  1999/02/07 17:27:53  matt
   updated for new setting dialogs
   new item statuses
   get sizes function
   slotError() update
   updated for new icons

   Revision 1.2  1998/12/19 19:40:34  matt
   new philosophy - mode and status
   new toolbar items
   new popup
   renaming items

   Revision 1.1.1.1  1998/05/06 19:13:31  matt
   Imported sources

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   */


#ifndef _KMAINWIDGET_H_
#define _KMAINWIDGET_H_

#include <drag.h>
#include <qtimer.h>
#include <qdatetime.h>

#include <kmenubar.h>
#include <ktmainwindow.h>

class KIOJob;
class KAudio;
class KMainWidget;
class DropTarget;
class KMyTabListBox;
class LogWindow;

class KItem : public QObject {
    
public:
  enum TransferModes { MD_QUEUED, MD_DELAYED, MD_SCHEDULED  };

  enum TransferStatus { ST_STOPPED, ST_RUNNING, ST_TRYING, ST_FINISHED,
	 ST_RETRYING, ST_SIZE_CHECK };

  KItem( const char *_src, const char *_dest, int _mode )
    {
      src = _src; dest = _dest;
      mode = _mode; job = 0L;

      totalSize = 0;  processedSize = 0; percent = 0;
      totalFiles = 1; processedFiles = 0;
      status = ST_STOPPED;
      canResume = true;
      startTime = QDateTime::currentDateTime();
      speed = 0; stalled = false;
    }
  
  friend class KMainWidget;
  friend class ConfigDlg;

protected:

  QString src;
  QString dest;
  
  int id;
  KIOJob *job;

  QDateTime startTime;

  unsigned long totalSize;
  unsigned long processedSize;
  int percent;
  int totalFiles;
  int processedFiles;

  int speed;
  QTime remainingTime;
  bool stalled;

  int status;
  int mode;

  int retryCount;

  bool canResume;
};


struct DirItem {
  QString extRegexp;
  QString defaultDir;
};


enum ConnectionType { PERMANENT, ETHERNET, PLIP, SLIP, PPP, ISDN };

enum WindowStyle { NORMAL, DOCKED, DROP_TARGET };


class KMainWidget : public KTMainWindow {

    Q_OBJECT

public:

  enum ToolbarFields { TOOL_RESUME, TOOL_PAUSE, TOOL_DELETE, TOOL_RESTART,
		       TOOL_QUEUE, TOOL_TIMER, TOOL_DELAY,
		       TOOL_PREFERENCES, TOOL_LOG_WINDOW, TOOL_PASTE,
		       TOOL_EXPERT, TOOL_USELASTDIR, TOOL_DISCONNECT, TOOL_SHUTDOWN,
		       TOOL_OFFLINE_MODE, TOOL_CLIPBOARD,
		       TOOL_DROP_TARGET, TOOL_DOCK
  };
  
  
  enum StatusbarFields { ID_TOTAL_TRANSFERS = 1, ID_TOTAL_FILES, ID_TOTAL_SIZE,
			 ID_TOTAL_TIME, ID_TOTAL_SPEED };

  enum DownloadStatus { STATUS_EMPTY, STATUS_DELAYED, STATUS_LOADING, STATUS_SCHEDULED };

  KMainWidget();
  ~KMainWidget();

  void addTransfer( QString src );

  bool getStyle9x() { return b_style9x; }

protected:

  void closeEvent( QCloseEvent * );

  void readSettings();
  void writeSettings();

  void readTransfers( bool ask_for_name = false );
  void writeTransfers( bool ask_for_name = false );

  void writeLog();

  void setupMenuBar();
  void setupToolBar();
  void setupStatusBar();
  void setupTabListBox();

  void updateToolBar();
  void updateStatusBar();

  void checkQueue();

  void Connect( KIOJob *job );

  // some flags
  bool b_deleteMode;
  bool b_online;
  bool b_viewLogWindow;

  // utility functions
  void disconnect();
  int downloadStatus();
  void checkOnline();
  void pauseAll();
  QString convertSize( int size );
  void log( const char *message, bool logwin = true, bool statusbar = true );
  void logid( const char *message, int id );

  // connection options
  bool b_reconnectOnError;
  uint reconnectTime;
  uint reconnectRetries;
  bool b_reconnectOnBroken;
  int connectionType;
  int linkNumber;
  bool b_offlineMode;

  // automation options
  bool b_autoSave;
  uint autoSaveInterval;
  bool b_autoDisconnect;
  QString disconnectCommand;
  bool b_timedDisconnect;
  QDate disconnectDate;
  QTime disconnectTime;
  bool b_autoShutdown;
  bool b_autoPaste;

  // limits options
  uint maxSimultaneousConnections;

  // advanced options
  bool b_addQueued;
  bool b_showDownloadWindows;
  bool b_startIconified;
  bool b_removeOnSuccess;
  bool b_getSizes;
  bool b_expertMode;

  // directories options
  bool b_useLastDir;

  // system options
  int windowStyle;
  bool b_style9x;
  bool b_showStatusbar;

  bool b_useSound;

  QString audioAdded;
  QString audioStarted;
  QString audioFinished;
  QString audioFinishedAll;

  bool b_useAnimation;

  // various timers
  QTimer *animTimer;         // animation timer
  QTimer *connectionTimer;   // timer that checks whether we are online
  QTimer *transferTimer;     // timer for scheduled transfers
  QTimer *autosaveTimer;     // timer for autosaving transfer list
  QTimer *clipboardTimer;    // timer for checking clipboard - autopaste function

  QString logFileName;

private:

  KMyTabListBox *myTabListBox;
  QPopupMenu *fileMenu, *optionsMenu, *viewMenu, *helpMenu, *popupMenu;

  LogWindow *logWindow;

  KAudio *audio;

  QFont  tablistboxfont;

  QString mainProperties;

  QString lastClipboard;

  QList<KItem> GlobalItemList;
  QList<DirItem> defaultDirList;

  KToolBar::BarPosition toolbarPos;
  KMenuBar::menuPosition menubarPos;

  // Popup menu IDs
  int pop_resume, pop_pause, pop_delay;
  int pop_queued, pop_scheduled, pop_delayed;
  int pop_begin, pop_end;

  // Options menu IDs
  int op_useanimation, op_usesound;

  // View menu IDs
  int vw_statusbar, vw_logwindow;

  QString currentDirectory;

  uint animCounter;

  int _sock;

protected slots:
  void saveYourself();
  void slotCheckConnection();

public slots:

  void quit();

  void openTransfer();
  void pasteTransfer();
  void exportTransfers();
  void importTransfers();
  void importTextFile();

  void resumeCurrent();
  void pauseCurrent();
  void deleteCurrent();
  void restartCurrent();

  void queueCurrent();
  void timerCurrent();
  void delayCurrent();

  void configCurrent();
  void openConfigDialog( bool scheduling = false );
  void openDownloadWindow();

  void toggleExpertMode();
  void toggleOfflineMode();
  void toggleUseLastDir();
  void toggleAutoDisconnect();
  void toggleAutoShutdown();
  void toggleAutoPaste();

  void toggleAnimation();
  void toggleSound();

  void toggleStatusbar();
  void toggleLogWindow();

  void slotNormalWindow();
  void slotDropTarget();
  void slotDock();

  void slotAnimTimeout();
  void slotTransferTimeout();
  void slotAutosaveTimeout();

  void slotPreferences();

  /// Drag and Drop
  void slotDropEvent( KDNDDropZone * _dropZone );

protected slots:

  // job signals
  void slotSpeed( int, unsigned long );
  void slotProcessedSize( int, unsigned long );
  void slotTotalSize( int, unsigned long );
  void slotTotalFiles( int, unsigned long );
  void slotProcessedFiles( int, unsigned long );

  void slotFinished( int );
  void slotCanceled( int );
  void slotError( int, int, const char* );
  void slotCopying( int, const char*, const char* );
  void slotRenamed( int, const char* );
  void slotCanResume( int, bool );

  // clicks on TabListBox
  void slotHighlightedEvent( int Index );
  void slotMidClickEvent( int Index );

  void slotPopupMenu( int Index );
  void slotMoveToBegin();
  void slotMoveToEnd();

  void slotCopyToClipboard();
  void slotCheckClipboard();

};

extern KMainWidget *kmain;
extern DropTarget *drop_target;

#endif // _KMAINWIDGET_H_
