/* $Id$
   $Log$

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <qlayout.h>
#include <kapp.h>

#include "logwindow.h"
#include "kmainwidget.h"

LogWindow::LogWindow() : QWidget( 0 )
{

  QBoxLayout *topLayout = new QVBoxLayout( this, 10, 5 );
	
  topLayout->addSpacing( 10 );

  ml_log = new QMultiLineEdit( this );
  topLayout->addWidget( ml_log );

  pb_close = new QPushButton(i18n("Close"), this );
  pb_close->adjustSize();
  pb_close->setFixedSize( pb_close->sizeHint() );
  topLayout->addWidget( pb_close );

  connect( pb_close, SIGNAL( clicked() ), this, SLOT( closeLog() ) );

  topLayout->addSpacing( 10 );

  topLayout->activate();
  setCaption(i18n("Caitoo Log Window"));

}


LogWindow::~LogWindow()
{
}


void LogWindow::closeLog() {
  kmain->toggleLogWindow();
}


void LogWindow::closeEvent( QCloseEvent* ) {
  kmain->toggleLogWindow();
}


void LogWindow::message( const char *message ) {
  ml_log->append( message );

}


QString LogWindow::getText() {
  return ml_log->text();
}
